/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.config;

import com.google.common.collect.Maps;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ChangeConfigParser;
import com.troblecodings.signals.contentpacks.OneSignalNonPredicateConfigParser;
import com.troblecodings.signals.contentpacks.OneSignalPredicateConfigParser;
import com.troblecodings.signals.enums.PathType;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import com.troblecodings.signals.signalbox.config.ConfigInfo;
import com.troblecodings.signals.signalbox.config.ResetInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class SignalConfig {
    private SignalConfig() {
    }

    public static void change(ConfigInfo info) {
        List<PredicatedPropertyBase.ConfigProperty> shuntingValues;
        Signal currentSignal = info.currentinfo.signal;
        if (info.type.equals((Object)PathType.NORMAL)) {
            if (info.nextinfo != null) {
                Signal nextSignal = info.nextinfo.signal;
                List<PredicatedPropertyBase.ConfigProperty> values = ChangeConfigParser.CHANGECONFIGS.get(Maps.immutableEntry((Object)((Object)currentSignal), (Object)((Object)nextSignal)));
                if (values != null) {
                    SignalConfig.changeIfPresent(values, info);
                } else {
                    SignalConfig.loadDefault(info);
                }
            } else {
                SignalConfig.loadDefault(info);
            }
        } else if (info.type.equals((Object)PathType.SHUNTING) && (shuntingValues = OneSignalNonPredicateConfigParser.SHUNTINGCONFIGS.get((Object)currentSignal)) != null) {
            SignalConfig.loadWithoutPredicate(shuntingValues, info.currentinfo);
        }
    }

    private static void loadDefault(ConfigInfo info) {
        List<PredicatedPropertyBase.ConfigProperty> defaultValues = OneSignalPredicateConfigParser.DEFAULTCONFIGS.get((Object)info.currentinfo.signal);
        if (defaultValues != null) {
            SignalConfig.changeIfPresent(defaultValues, info);
        }
    }

    public static void reset(ResetInfo info) {
        List<PredicatedPropertyBase.ConfigProperty> resetValues = OneSignalNonPredicateConfigParser.RESETCONFIGS.get((Object)info.current.signal);
        if (resetValues == null) {
            return;
        }
        SignalStateHandler.runTaskWhenSignalLoaded(info.current, (stateInfo, oldProperties, _u) -> {
            HashMap<Class, Object> object = new HashMap<Class, Object>();
            object.put(Boolean.class, info.isRepeater);
            object.put(Map.class, oldProperties);
            HashMap<SEProperty, String> propertiesToSet = new HashMap<SEProperty, String>();
            resetValues.forEach(property -> {
                if (property.test(object)) {
                    propertiesToSet.putAll(((Map)property.state).entrySet().stream().filter(entry -> oldProperties.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                }
            });
            if (!propertiesToSet.isEmpty()) {
                SignalStateHandler.setStates(info.current, propertiesToSet);
            }
        });
    }

    private static void changeIfPresent(List<PredicatedPropertyBase.ConfigProperty> values, ConfigInfo info) {
        SignalStateHandler.runTaskWhenSignalLoaded(info.currentinfo, (stateInfo, oldProperties, _u) -> {
            if (info.nextinfo != null) {
                SignalStateHandler.runTaskWhenSignalLoaded(info.nextinfo, (nextInfo, nextProperties, _u2) -> SignalConfig.changeSignals(values, info, oldProperties, nextProperties));
            } else {
                SignalConfig.changeSignals(values, info, oldProperties, null);
            }
        });
    }

    private static void changeSignals(List<PredicatedPropertyBase.ConfigProperty> values, ConfigInfo info, Map<SEProperty, String> oldProperties, Map<SEProperty, String> nextProperties) {
        HashMap<Class, Object> object = new HashMap<Class, Object>();
        if (info.nextinfo != null) {
            object.put(Map.class, nextProperties);
        }
        object.put(Integer.class, info.speed);
        object.put(String.class, info.zs2Value);
        object.put(Boolean.class, info.isSignalRepeater);
        HashMap<SEProperty, String> propertiesToSet = new HashMap<SEProperty, String>();
        values.forEach(property -> {
            if (property.test(object)) {
                propertiesToSet.putAll(((Map)property.state).entrySet().stream().filter(entry -> oldProperties.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        });
        if (!propertiesToSet.isEmpty()) {
            SignalStateHandler.setStates(info.currentinfo, propertiesToSet);
        }
    }

    private static void loadWithoutPredicate(List<PredicatedPropertyBase.ConfigProperty> values, SignalStateInfo current) {
        if (values != null) {
            SignalStateHandler.runTaskWhenSignalLoaded(current, (info, oldProperties, _u) -> {
                HashMap<SEProperty, String> propertiesToSet = new HashMap<SEProperty, String>();
                values.forEach(property -> propertiesToSet.putAll(((Map)property.state).entrySet().stream().filter(entry -> oldProperties.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
                if (!propertiesToSet.isEmpty()) {
                    SignalStateHandler.setStates(current, propertiesToSet);
                }
            });
        }
    }
}

