/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.RedstoneIO;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.JsonEnumHolder;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryEntry;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.enums.PathType;
import com.troblecodings.signals.enums.SignalBoxNetwork;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.OtherSignalIdentifier;
import com.troblecodings.signals.signalbox.Path;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.signalbox.SignalBoxUtil;
import com.troblecodings.signals.signalbox.config.ConfigInfo;
import com.troblecodings.signals.signalbox.config.ResetInfo;
import com.troblecodings.signals.signalbox.config.SignalConfig;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SignalBoxPathway
implements IChunkLoadable {
    private final ExecutorService service = Executors.newFixedThreadPool(1);
    private final Map<BlockPos, SignalBoxNode> mapOfResetPositions = new HashMap<BlockPos, SignalBoxNode>();
    private final Map<BlockPos, SignalBoxNode> mapOfBlockingPositions = new HashMap<BlockPos, SignalBoxNode>();
    private ImmutableList<SignalBoxNode> listOfNodes = ImmutableList.of();
    private PathType type = PathType.NONE;
    private Point firstPoint = new Point();
    private Point lastPoint = new Point();
    private int speed = -1;
    private String zs2Value = "";
    private int delay = 0;
    private Optional<Map.Entry<MainSignalIdentifier, MainSignalIdentifier>> signalPositions = Optional.empty();
    private Optional<MainSignalIdentifier> lastSignal = Optional.empty();
    private ImmutableMap<BlockPos, OtherSignalIdentifier> distantSignalPositions = ImmutableMap.of();
    private Map<Point, SignalBoxNode> modeGrid = null;
    private boolean emptyOrBroken = false;
    private World world;
    private BlockPos tilePos;
    private boolean isBlocked;
    private boolean isAutoPathway = false;
    private Point originalFirstPoint = null;
    private Consumer<SignalBoxPathway> consumer;
    private SignalBoxGrid holder = null;
    private SignalBoxTileEntity tile;
    private TrainNumber trainNumber;
    private SignalBoxPathway pathwayToBlock;
    private SignalBoxPathway pathwayToReset;
    private static final String LIST_OF_NODES = "listOfNodes";
    private static final String PATH_TYPE = "pathType";
    private static final String IS_BLOCKED = "isBlocked";
    private static final String ORIGINAL_FIRST_POINT = "origianlFirstPoint";
    private static final String PATHWAY_TO_BLOCK = "pathwayToBlock";
    private static final String PATHWAY_TO_RESET = "pathwayToReset";
    private static final String END_POINT = "endPoint";
    private static final String TILE_POS = "signalBoxPos";
    private Map.Entry<BlockPos, Point> blockPW = null;
    private Map.Entry<BlockPos, Point> resetPW = null;
    private SignalStateInfo lastSignalInfo = null;
    private boolean isExecutingSignalSet = false;

    public SignalBoxPathway(Map<Point, SignalBoxNode> modeGrid) {
        this.modeGrid = modeGrid;
    }

    public void setTile(SignalBoxTileEntity tile) {
        this.world = tile.func_145831_w();
        this.tilePos = tile.func_174877_v();
        this.tile = tile;
    }

    public SignalBoxPathway(Map<Point, SignalBoxNode> modeGrid, List<SignalBoxNode> pNodes, PathType type) {
        this(modeGrid);
        this.listOfNodes = ImmutableList.copyOf(pNodes);
        this.type = Objects.requireNonNull(type);
        if (this.listOfNodes.size() < 2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.type.equals((Object)PathType.NONE)) {
            throw new IllegalArgumentException();
        }
        this.initalize();
        this.originalFirstPoint = new Point(this.firstPoint);
        this.updatePathwayToAutomatic();
        this.resetAllTrainNumbers();
    }

    private void initalize() {
        AtomicInteger atomic = new AtomicInteger(Integer.MAX_VALUE);
        AtomicReference<Byte> zs2Value = new AtomicReference<Byte>((byte)-1);
        AtomicInteger delayAtomic = new AtomicInteger(0);
        ImmutableMap.Builder distantPosBuilder = ImmutableMap.builder();
        this.mapOfBlockingPositions.clear();
        this.mapOfResetPositions.clear();
        this.foreachEntry((optionEntry, node) -> {
            optionEntry.getEntry(PathEntryType.SPEED).ifPresent(value -> atomic.updateAndGet(in -> Math.min(in, value)));
            optionEntry.getEntry(PathEntryType.BLOCKING).ifPresent(position -> this.mapOfBlockingPositions.put((BlockPos)position, (SignalBoxNode)node));
            optionEntry.getEntry(PathEntryType.RESETING).ifPresent(position -> this.mapOfResetPositions.put((BlockPos)position, (SignalBoxNode)node));
            optionEntry.getEntry(PathEntryType.ZS2).ifPresent(value -> zs2Value.set((Byte)value));
        });
        this.foreachPath((path, node) -> {
            Rotation rotation = SignalBoxUtil.getRotationFromDelta(node.getPoint().delta(path.point1));
            for (EnumGuiMode mode : Arrays.asList(EnumGuiMode.VP, EnumGuiMode.RS)) {
                ModeSet modeSet = new ModeSet(mode, rotation);
                node.getOption(modeSet).ifPresent(option -> option.getEntry(PathEntryType.SIGNAL).ifPresent(position -> {
                    Optional<Boolean> repeaterOption = option.getEntry(PathEntryType.SIGNAL_REPEATER);
                    distantPosBuilder.put(position, (Object)new OtherSignalIdentifier(node.getPoint(), modeSet, (BlockPos)position, repeaterOption.isPresent() && repeaterOption.get() != false, mode.equals((Object)EnumGuiMode.RS)));
                }));
            }
            node.getModes().entrySet().stream().filter(entry -> ((ModeSet)entry.getKey()).mode.equals((Object)EnumGuiMode.BUE)).forEach(entry -> ((PathOptionEntry)entry.getValue()).getEntry(PathEntryType.DELAY).ifPresent(value -> delayAtomic.updateAndGet(in -> Math.max(in, value))));
        }, null);
        this.distantSignalPositions = distantPosBuilder.build();
        SignalBoxNode firstNode = (SignalBoxNode)this.listOfNodes.get(this.listOfNodes.size() - 1);
        this.firstPoint = firstNode.getPoint();
        MainSignalIdentifier firstPos = this.makeFromNext(this.type, firstNode, (SignalBoxNode)this.listOfNodes.get(this.listOfNodes.size() - 2), Rotation.NONE);
        SignalBoxNode lastNode = (SignalBoxNode)this.listOfNodes.get(0);
        this.lastPoint = lastNode.getPoint();
        MainSignalIdentifier lastPos = this.makeFromNext(this.type, lastNode, (SignalBoxNode)this.listOfNodes.get(1), Rotation.CLOCKWISE_180);
        if (lastPos != null) {
            this.lastSignal = Optional.of(lastPos);
        }
        this.signalPositions = firstPos != null ? Optional.of(Maps.immutableEntry((Object)firstPos, (Object)lastPos)) : Optional.empty();
        this.speed = atomic.get();
        this.zs2Value = JsonEnumHolder.ZS32.getObjFromID(Byte.toUnsignedInt(zs2Value.get()));
        this.delay = delayAtomic.get();
    }

    private MainSignalIdentifier makeFromNext(PathType type, SignalBoxNode first, SignalBoxNode next, Rotation pRotation) {
        Point delta = first.getPoint().delta(next.getPoint());
        Rotation rotation = SignalBoxUtil.getRotationFromDelta(delta).func_185830_a(pRotation);
        for (EnumGuiMode mode : type.getModes()) {
            ModeSet modeSet = new ModeSet(mode, rotation);
            BlockPos possiblePosition = first.getOption(modeSet).flatMap(option -> option.getEntry(PathEntryType.SIGNAL)).orElse(null);
            if (possiblePosition == null) continue;
            return new MainSignalIdentifier(first.getPoint(), modeSet, possiblePosition);
        }
        return null;
    }

    public void write(NBTWrapper tag) {
        NBTWrapper pointWrapper;
        tag.putList(LIST_OF_NODES, this.listOfNodes.stream().map(node -> {
            NBTWrapper entry = new NBTWrapper();
            node.getPoint().write(entry);
            return entry;
        })::iterator);
        tag.putString(PATH_TYPE, this.type.name());
        tag.putBoolean(IS_BLOCKED, this.isBlocked);
        if (this.originalFirstPoint != null) {
            NBTWrapper originalFirstPoint = new NBTWrapper();
            this.originalFirstPoint.write(originalFirstPoint);
            tag.putWrapper(ORIGINAL_FIRST_POINT, originalFirstPoint);
        }
        if (this.pathwayToBlock != null) {
            NBTWrapper blockWrapper = new NBTWrapper();
            blockWrapper.putBlockPos(TILE_POS, this.pathwayToBlock.tilePos);
            pointWrapper = new NBTWrapper();
            this.pathwayToBlock.lastPoint.write(pointWrapper);
            blockWrapper.putWrapper(END_POINT, pointWrapper);
            tag.putWrapper(PATHWAY_TO_BLOCK, blockWrapper);
        }
        if (this.pathwayToReset != null) {
            NBTWrapper resetWrapper = new NBTWrapper();
            resetWrapper.putBlockPos(TILE_POS, this.pathwayToReset.tilePos);
            pointWrapper = new NBTWrapper();
            this.pathwayToReset.lastPoint.write(pointWrapper);
            resetWrapper.putWrapper(END_POINT, pointWrapper);
            tag.putWrapper(PATHWAY_TO_RESET, resetWrapper);
        }
        if (this.trainNumber != null) {
            this.trainNumber.writeTag(tag);
        }
    }

    public void read(NBTWrapper tag) {
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        tag.getList(LIST_OF_NODES).forEach(nodeNBT -> {
            Point point = new Point();
            point.read((NBTWrapper)nodeNBT);
            SignalBoxNode node = this.modeGrid.get(point);
            if (node == null) {
                OpenSignalsMain.getLogger().error("Detecting broken pathway at {}!", (Object)point.toString());
                this.emptyOrBroken = true;
                return;
            }
            nodeBuilder.add((Object)node);
        });
        this.listOfNodes = nodeBuilder.build();
        this.type = PathType.valueOf(tag.getString(PATH_TYPE));
        this.isBlocked = tag.getBoolean(IS_BLOCKED);
        if (this.listOfNodes.size() < 2) {
            OpenSignalsMain.getLogger().error("Detecting pathway with only 2 elements!");
            this.emptyOrBroken = true;
            return;
        }
        this.initalize();
        NBTWrapper originalFirstPoint = tag.getWrapper(ORIGINAL_FIRST_POINT);
        if (!originalFirstPoint.isTagNull()) {
            this.originalFirstPoint = new Point();
            this.originalFirstPoint.read(originalFirstPoint);
        }
        this.trainNumber = TrainNumber.of(tag);
        this.updatePathwayToAutomatic();
        this.updateSignalStates();
    }

    public void readLinkedPathways(NBTWrapper tag) {
        NBTWrapper resetWrapper;
        NBTWrapper blockWrapper = tag.getWrapper(PATHWAY_TO_BLOCK);
        if (!blockWrapper.isTagNull()) {
            Point end = new Point();
            end.read(blockWrapper.getWrapper(END_POINT));
            BlockPos otherPos = blockWrapper.getBlockPos(TILE_POS);
            if (this.world == null || this.world.field_72995_K) {
                this.blockPW = Maps.immutableEntry((Object)otherPos, (Object)end);
            } else {
                SignalBoxPathway otherPathway;
                AtomicReference<SignalBoxGrid> otherGrid = new AtomicReference<SignalBoxGrid>();
                otherGrid.set(SignalBoxHandler.getGrid(new StateInfo(this.world, otherPos)));
                if (otherGrid.get() == null) {
                    this.loadTileAndExecute(otherPos, tile -> otherGrid.set(tile.getSignalBoxGrid()));
                }
                this.pathwayToBlock = otherPathway = ((SignalBoxGrid)otherGrid.get()).getPathwayByLastPoint(end);
            }
        }
        if (!(resetWrapper = tag.getWrapper(PATHWAY_TO_RESET)).isTagNull()) {
            Point end = new Point();
            end.read(resetWrapper.getWrapper(END_POINT));
            BlockPos otherPos = resetWrapper.getBlockPos(TILE_POS);
            if (this.world == null || this.world.field_72995_K) {
                this.resetPW = Maps.immutableEntry((Object)otherPos, (Object)end);
            } else {
                SignalBoxPathway otherPathway;
                AtomicReference<SignalBoxGrid> otherGrid = new AtomicReference<SignalBoxGrid>();
                otherGrid.set(SignalBoxHandler.getGrid(new StateInfo(this.world, otherPos)));
                if (otherGrid.get() == null) {
                    this.loadTileAndExecute(otherPos, tile -> otherGrid.set(tile.getSignalBoxGrid()));
                }
                this.pathwayToReset = otherPathway = ((SignalBoxGrid)otherGrid.get()).getPathwayByLastPoint(end);
            }
        }
    }

    public void linkPathways() {
        SignalBoxPathway otherPathway;
        AtomicReference<SignalBoxGrid> otherGrid;
        if (this.world == null || this.world.field_72995_K) {
            return;
        }
        if (this.blockPW != null) {
            otherGrid = new AtomicReference<SignalBoxGrid>();
            otherGrid.set(SignalBoxHandler.getGrid(new StateInfo(this.world, this.blockPW.getKey())));
            if (otherGrid.get() == null) {
                this.loadTileAndExecute(this.blockPW.getKey(), tile -> otherGrid.set(tile.getSignalBoxGrid()));
            }
            if (otherGrid.get() != null) {
                this.pathwayToBlock = otherPathway = ((SignalBoxGrid)otherGrid.get()).getPathwayByLastPoint(this.blockPW.getValue());
                this.blockPW = null;
            }
        }
        if (this.resetPW != null) {
            otherGrid = new AtomicReference();
            otherGrid.set(SignalBoxHandler.getGrid(new StateInfo(this.world, this.resetPW.getKey())));
            if (otherGrid.get() == null) {
                this.loadTileAndExecute(this.resetPW.getKey(), tile -> otherGrid.set(tile.getSignalBoxGrid()));
            }
            if (otherGrid.get() != null) {
                this.pathwayToReset = otherPathway = ((SignalBoxGrid)otherGrid.get()).getPathwayByLastPoint(this.resetPW.getValue());
                this.resetPW = null;
            }
        }
    }

    private void foreachEntry(Consumer<PathOptionEntry> consumer, @Nullable Point point) {
        this.foreachEntry((PathOptionEntry entry, SignalBoxNode _u) -> consumer.accept((PathOptionEntry)entry), point);
    }

    private void foreachEntry(BiConsumer<PathOptionEntry, SignalBoxNode> consumer) {
        this.foreachEntry(consumer, null);
    }

    private void foreachPath(BiConsumer<Path, SignalBoxNode> consumer, @Nullable Point point) {
        for (int i = this.listOfNodes.size() - 2; i > 0; --i) {
            Point oldPos = ((SignalBoxNode)this.listOfNodes.get(i - 1)).getPoint();
            Point newPos = ((SignalBoxNode)this.listOfNodes.get(i + 1)).getPoint();
            SignalBoxNode current = (SignalBoxNode)this.listOfNodes.get(i);
            consumer.accept(new Path(oldPos, newPos), current);
            if (current.getPoint().equals(point)) break;
        }
    }

    private void foreachEntry(BiConsumer<PathOptionEntry, SignalBoxNode> consumer, @Nullable Point point) {
        this.foreachPath((path, current) -> current.getOption((Path)path).ifPresent(entry -> consumer.accept((PathOptionEntry)entry, (SignalBoxNode)current)), point);
    }

    public void setPathStatus(EnumPathUsage status, @Nullable Point point) {
        this.foreachEntry((PathOptionEntry option) -> {
            option.getEntry(PathEntryType.OUTPUT).ifPresent(pos -> SignalBoxHandler.updateRedstoneOutput(new StateInfo(this.world, (BlockPos)pos), !status.equals((Object)EnumPathUsage.FREE)));
            option.setEntry(PathEntryType.PATHUSAGE, status);
        }, point);
    }

    public void setPathStatus(EnumPathUsage status) {
        this.setPathStatus(status, null);
    }

    private SignalStateInfo getLastSignalInfo() {
        Signal nextSignal;
        if (this.lastSignalInfo != null) {
            return this.lastSignalInfo;
        }
        StateInfo identifier = new StateInfo(this.world, this.tilePos);
        SignalStateInfo lastInfo = null;
        if (this.lastSignal.isPresent()) {
            nextSignal = SignalBoxHandler.getSignal(identifier, this.lastSignal.get().pos);
            if (nextSignal != null) {
                lastInfo = new SignalStateInfo(this.world, this.lastSignal.get().pos, nextSignal);
            }
            lastInfo = new SignalStateInfo(this.world, this.lastSignal.get().pos, nextSignal);
        }
        if (this.pathwayToBlock != null && this.pathwayToBlock.lastSignal.isPresent() && (nextSignal = SignalBoxHandler.getSignal(new StateInfo(this.pathwayToBlock.world, this.pathwayToBlock.tilePos), this.pathwayToBlock.lastSignal.get().pos)) != null) {
            lastInfo = new SignalStateInfo(this.world, this.pathwayToBlock.lastSignal.get().pos, nextSignal);
        }
        return lastInfo;
    }

    public void updatePathwaySignals() {
        if (this.world == null || this.world.field_72995_K) {
            return;
        }
        SignalStateInfo lastSignal = this.getLastSignalInfo();
        if (this.delay > 0) {
            this.setPathStatus(EnumPathUsage.PREPARED);
            if (this.pathwayToBlock != null) {
                this.pathwayToBlock.loadTileAndExecute(_u -> {
                    this.pathwayToBlock.isExecutingSignalSet = true;
                    this.pathwayToBlock.setPathStatus(EnumPathUsage.PREPARED);
                    this.pathwayToBlock.executeConsumer();
                });
            }
            if (this.isExecutingSignalSet) {
                return;
            }
            this.isExecutingSignalSet = true;
            this.service.execute(() -> {
                try {
                    Thread.sleep(this.delay * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.emptyOrBroken) {
                    return;
                }
                ImmutableMap<BlockPos, OtherSignalIdentifier> immutableMap = this.distantSignalPositions;
                synchronized (immutableMap) {
                    this.isExecutingSignalSet = false;
                    this.setSignals(this.getLastSignalInfo());
                }
                this.world.func_73046_m().func_152344_a(() -> {
                    this.loadTileAndExecute(thisTile -> {
                        SignalBoxPathway pw = thisTile.getSignalBoxGrid().getPathwayByLastPoint(this.getLastPoint());
                        pw.setPathStatus(EnumPathUsage.SELECTED);
                        pw.executeConsumer();
                    });
                    if (this.pathwayToBlock != null) {
                        this.pathwayToBlock.loadTileAndExecute(otherTile -> {
                            this.pathwayToBlock = otherTile.getSignalBoxGrid().getPathwayByLastPoint(this.pathwayToBlock.getLastPoint());
                            this.pathwayToBlock.setPathStatus(EnumPathUsage.SELECTED);
                            this.pathwayToBlock.executeConsumer();
                            this.pathwayToBlock.isExecutingSignalSet = false;
                        });
                    }
                });
            });
            return;
        }
        this.setSignals(lastSignal);
    }

    private SignalBoxPathway getNextPathway() {
        return this.holder.startsToPath.get(this.lastPoint);
    }

    public void setSignals() {
        this.setSignals(this.getLastSignalInfo());
    }

    private void setSignals(SignalStateInfo lastSignal) {
        if (this.isExecutingSignalSet) {
            return;
        }
        StateInfo identifier = new StateInfo(this.world, this.tilePos);
        this.signalPositions.ifPresent(entry -> {
            if (this.isBlocked) {
                return;
            }
            Signal first = SignalBoxHandler.getSignal(identifier, ((MainSignalIdentifier)entry.getKey()).pos);
            if (first == null) {
                return;
            }
            SignalStateInfo firstInfo = new SignalStateInfo(this.world, ((MainSignalIdentifier)entry.getKey()).pos, first);
            SignalConfig.change(new ConfigInfo(firstInfo, lastSignal, this.speed, this.zs2Value, this.type));
        });
        this.distantSignalPositions.values().forEach(position -> {
            Signal current = SignalBoxHandler.getSignal(identifier, position.pos);
            if (current == null) {
                return;
            }
            SignalConfig.change(new ConfigInfo(new SignalStateInfo(this.world, position.pos, current), lastSignal, this.speed, this.zs2Value, this.type, position.isRepeater));
        });
        if (this.lastSignal.isPresent() && this.pathwayToReset != null) {
            Signal signal = SignalBoxHandler.getSignal(identifier, this.lastSignal.get().pos);
            if (signal == null) {
                return;
            }
            this.pathwayToReset.setSignals(new SignalStateInfo(this.world, this.lastSignal.get().pos, signal));
        }
        this.updateSignalStates();
    }

    private void updateSignalStates() {
        ArrayList<MainSignalIdentifier> redSignals = new ArrayList<MainSignalIdentifier>();
        ArrayList<MainSignalIdentifier> greenSignals = new ArrayList<MainSignalIdentifier>();
        this.signalPositions.ifPresent(entry -> {
            if (this.isBlocked) {
                return;
            }
            MainSignalIdentifier.SignalState previous = ((MainSignalIdentifier)entry.getKey()).state;
            ((MainSignalIdentifier)entry.getKey()).state = MainSignalIdentifier.SignalState.GREEN;
            if (!((MainSignalIdentifier)entry.getKey()).state.equals((Object)previous)) {
                greenSignals.add((MainSignalIdentifier)entry.getKey());
            }
        });
        this.distantSignalPositions.values().forEach(position -> {
            SignalBoxPathway next = this.getNextPathway();
            MainSignalIdentifier.SignalState previous = position.state;
            if (this.lastSignal != null && next != null && !next.isEmptyOrBroken()) {
                if (!next.isExecutingSignalSet) {
                    position.state = MainSignalIdentifier.SignalState.GREEN;
                }
            } else if (this.pathwayToBlock != null) {
                SignalBoxPathway otherNext = this.pathwayToBlock.getNextPathway();
                if (otherNext != null && !otherNext.isEmptyOrBroken()) {
                    if (!otherNext.isExecutingSignalSet) {
                        position.state = MainSignalIdentifier.SignalState.GREEN;
                    }
                } else {
                    position.state = MainSignalIdentifier.SignalState.RED;
                }
            } else {
                position.state = MainSignalIdentifier.SignalState.RED;
            }
            if (position.isRSSignal) {
                position.state = MainSignalIdentifier.SignalState.GREEN;
            }
            if (position.state.equals((Object)previous)) {
                return;
            }
            if (position.state.equals((Object)MainSignalIdentifier.SignalState.RED)) {
                redSignals.add((MainSignalIdentifier)position);
            } else if (position.state.equals((Object)MainSignalIdentifier.SignalState.GREEN)) {
                greenSignals.add((MainSignalIdentifier)position);
            }
        });
        this.updateSignalsOnClient(redSignals, greenSignals);
    }

    public List<MainSignalIdentifier> getGreenSignals() {
        ArrayList<MainSignalIdentifier> returnList = new ArrayList<MainSignalIdentifier>();
        this.signalPositions.ifPresent(entry -> {
            if (((MainSignalIdentifier)entry.getKey()).state.equals((Object)MainSignalIdentifier.SignalState.GREEN)) {
                returnList.add((MainSignalIdentifier)entry.getKey());
            }
        });
        this.distantSignalPositions.values().forEach(signal -> {
            if (signal.state.equals((Object)MainSignalIdentifier.SignalState.GREEN)) {
                returnList.add((MainSignalIdentifier)signal);
            }
        });
        return returnList;
    }

    public void setUpdater(Consumer<SignalBoxPathway> consumer) {
        this.consumer = consumer;
    }

    private void executeConsumer() {
        this.consumer.accept(this);
    }

    public void setOtherPathwayToBlock(SignalBoxPathway pathway) {
        this.pathwayToBlock = pathway;
        if (this.delay == 0 && this.pathwayToBlock.delay > 0) {
            this.resetFirstSignal();
            this.resetOther();
        }
        this.delay = Math.max(this.delay, this.pathwayToBlock.delay);
        this.updatePathwaySignals();
        this.executeConsumer();
    }

    public void setOtherPathwayToReset(SignalBoxPathway pathway) {
        this.pathwayToReset = pathway;
    }

    public void setSignalBoxGrid(SignalBoxGrid holder) {
        this.holder = holder;
    }

    private void updateSignalsOnClient(List<MainSignalIdentifier> redSignals) {
        this.updateSignalsOnClient(redSignals, new ArrayList<MainSignalIdentifier>());
    }

    private void updateSignalsOnClient(List<MainSignalIdentifier> redSignals, List<MainSignalIdentifier> greenSignals) {
        if (redSignals.isEmpty() && greenSignals.isEmpty()) {
            return;
        }
        if (this.world == null || this.world.field_72995_K) {
            return;
        }
        this.world.func_73046_m().func_152344_a(() -> {
            WriteBuffer buffer = new WriteBuffer();
            buffer.putEnumValue(SignalBoxNetwork.SET_SIGNALS);
            buffer.putByte((byte)redSignals.size());
            redSignals.forEach(signal -> {
                signal.writeNetwork(buffer);
                this.holder.updateSubsidiarySignal(signal.getPoint(), signal.getModeSet(), new SubsidiaryEntry(null, false));
            });
            buffer.putByte((byte)greenSignals.size());
            greenSignals.forEach(signal -> signal.writeNetwork(buffer));
            if (this.tile == null || !this.tile.isBlocked()) {
                return;
            }
            OpenSignalsMain.network.sendTo(this.tile.get(0).getPlayer(), buffer);
        });
    }

    public void resetPathway() {
        this.resetPathway(null);
    }

    private void resetFirstSignal() {
        this.signalPositions.ifPresent(entry -> {
            Signal current = SignalBoxHandler.getSignal(new StateInfo(this.world, this.tilePos), ((MainSignalIdentifier)entry.getKey()).pos);
            if (current == null) {
                return;
            }
            SignalConfig.reset(new ResetInfo(new SignalStateInfo(this.world, ((MainSignalIdentifier)entry.getKey()).pos, current), false));
            MainSignalIdentifier.SignalState previous = ((MainSignalIdentifier)entry.getKey()).state;
            ((MainSignalIdentifier)entry.getKey()).state = MainSignalIdentifier.SignalState.RED;
            if (!((MainSignalIdentifier)entry.getKey()).state.equals((Object)previous)) {
                this.updateSignalsOnClient((List<MainSignalIdentifier>)ImmutableList.of(entry.getKey()));
            }
        });
    }

    private void resetOther() {
        ArrayList<MainSignalIdentifier> redSignals = new ArrayList<MainSignalIdentifier>();
        this.distantSignalPositions.values().forEach(position -> {
            Signal current = SignalBoxHandler.getSignal(new StateInfo(this.world, this.tilePos), position.pos);
            if (current == null) {
                return;
            }
            SignalConfig.reset(new ResetInfo(new SignalStateInfo(this.world, position.pos, current), position.isRepeater));
            MainSignalIdentifier.SignalState previous = position.state;
            position.state = MainSignalIdentifier.SignalState.RED;
            if (!position.state.equals((Object)previous)) {
                redSignals.add((MainSignalIdentifier)position);
            }
        });
        this.updateSignalsOnClient(redSignals);
        this.resetAllTrainNumbers();
        this.sendTrainNumberUpdates();
    }

    public void resetPathway(@Nullable Point point) {
        this.setPathStatus(EnumPathUsage.FREE, point);
        this.resetFirstSignal();
        if (point == null || point.equals(this.getLastPoint()) || point.equals(((SignalBoxNode)this.listOfNodes.get(1)).getPoint())) {
            this.emptyOrBroken = true;
            this.isBlocked = false;
            this.resetOther();
            if (this.pathwayToReset != null) {
                this.pathwayToReset.loadTileAndExecute(tile -> tile.getSignalBoxGrid().resetPathway(this.pathwayToReset.getFirstPoint()));
            }
        }
    }

    public void compact(Point point) {
        ArrayList<MainSignalIdentifier> redSignals = new ArrayList<MainSignalIdentifier>();
        this.foreachPath((path, node) -> {
            Rotation rotation = SignalBoxUtil.getRotationFromDelta(node.getPoint().delta(path.point1));
            for (EnumGuiMode mode : Arrays.asList(EnumGuiMode.VP, EnumGuiMode.RS)) {
                node.getOption(new ModeSet(mode, rotation)).ifPresent(option -> option.getEntry(PathEntryType.SIGNAL).ifPresent(position -> {
                    Signal current = SignalBoxHandler.getSignal(new StateInfo(this.world, this.tilePos), position);
                    if (current == null) {
                        return;
                    }
                    OtherSignalIdentifier identifier = (OtherSignalIdentifier)this.distantSignalPositions.getOrDefault(position, (Object)new OtherSignalIdentifier(point, new ModeSet(mode, rotation), (BlockPos)position, false, mode.equals((Object)EnumGuiMode.RS)));
                    SignalConfig.reset(new ResetInfo(new SignalStateInfo(this.world, (BlockPos)position, current), identifier.isRepeater));
                    MainSignalIdentifier.SignalState previous = identifier.state;
                    identifier.state = MainSignalIdentifier.SignalState.RED;
                    if (!identifier.state.equals((Object)previous)) {
                        redSignals.add(identifier);
                    }
                }));
            }
        }, point);
        this.listOfNodes = ImmutableList.copyOf((Collection)this.listOfNodes.subList(0, this.listOfNodes.indexOf((Object)this.modeGrid.get(point)) + 1));
        this.initalize();
        this.updateSignalsOnClient(redSignals);
        this.updateTrainNumber(this.trainNumber);
    }

    public Optional<Point> tryReset(BlockPos position) {
        SignalBoxNode node = this.mapOfResetPositions.get(position);
        if (node == null) {
            if (this.checkReverseReset(position)) {
                return Optional.of(this.firstPoint);
            }
            return Optional.empty();
        }
        Point point = node.getPoint();
        AtomicBoolean atomic = new AtomicBoolean(false);
        this.foreachEntry((PathOptionEntry option, SignalBoxNode cNode) -> option.getEntry(PathEntryType.BLOCKING).ifPresent(pos -> {
            if (this.isPowerd((BlockPos)pos)) {
                atomic.set(true);
            }
        }), point);
        if (atomic.get()) {
            return Optional.empty();
        }
        this.resetPathway(point);
        return Optional.of(point);
    }

    private boolean checkReverseReset(BlockPos pos) {
        if (!this.isBlocked || this.getFirstPoint().equals(this.originalFirstPoint)) {
            return false;
        }
        SignalBoxNode firstNode = (SignalBoxNode)this.listOfNodes.get(this.listOfNodes.size() - 1);
        for (Rotation rot : Rotation.values()) {
            if (!this.tryReversReset(pos, firstNode, rot)) continue;
            return true;
        }
        return false;
    }

    private boolean tryReversReset(BlockPos pos, SignalBoxNode node, Rotation rot) {
        AtomicBoolean canReset = new AtomicBoolean(false);
        for (EnumGuiMode mode : Arrays.asList(EnumGuiMode.CORNER, EnumGuiMode.STRAIGHT)) {
            node.getOption(new ModeSet(mode, rot)).ifPresent(entry -> entry.getEntry(PathEntryType.RESETING).ifPresent(blockPos -> {
                if (!blockPos.equals((Object)pos)) {
                    return;
                }
                AtomicBoolean atomic = new AtomicBoolean(false);
                this.foreachEntry((option, cNode) -> option.getEntry(PathEntryType.BLOCKING).ifPresent(blockingPos -> {
                    if (this.isPowerd((BlockPos)blockingPos)) {
                        atomic.set(true);
                    }
                }));
                if (atomic.get()) {
                    return;
                }
                canReset.set(true);
                this.resetPathway();
            }));
        }
        return canReset.get();
    }

    private boolean isPowerd(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (state == null || !(state.func_177230_c() instanceof RedstoneIO)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)RedstoneIO.POWER);
    }

    public boolean tryBlock(BlockPos position) {
        if (!this.mapOfBlockingPositions.containsKey(position)) {
            return false;
        }
        this.resetFirstSignal();
        this.setPathStatus(EnumPathUsage.BLOCKED);
        if (!this.isBlocked) {
            this.getTrainNumberFromPrevious();
        }
        this.isBlocked = true;
        if (this.pathwayToBlock != null) {
            this.pathwayToBlock.loadTileAndExecute(otherTile -> {
                this.pathwayToBlock = otherTile.getSignalBoxGrid().getPathwayByLastPoint(this.pathwayToBlock.getLastPoint());
                this.pathwayToBlock.setPathStatus(EnumPathUsage.BLOCKED);
                this.pathwayToBlock.updateTrainNumber(this.trainNumber);
            });
        }
        return true;
    }

    private void getTrainNumberFromPrevious() {
        SignalBoxPathway previous = this.holder.getPathwayByLastPoint(this.firstPoint);
        if (previous != null) {
            this.updateTrainNumber(previous.trainNumber);
        }
    }

    public void checkTrainNumberUpdate(TrainNumber number, SignalBoxNode node) {
        if (!this.listOfNodes.contains((Object)node)) {
            return;
        }
        this.updateTrainNumber(number);
    }

    private void updateTrainNumber(TrainNumber number) {
        this.resetAllTrainNumbers();
        SignalBoxNode setNode = (SignalBoxNode)this.listOfNodes.get((this.listOfNodes.size() - 1) / 2);
        setNode.setTrainNumber(number);
        this.trainNumber = number;
        this.sendTrainNumberUpdates();
    }

    private void sendTrainNumberUpdates() {
        if (!this.tile.isBlocked()) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_TRAIN_NUMBER);
        buffer.putInt(this.listOfNodes.size());
        this.listOfNodes.forEach(node -> {
            node.getPoint().writeNetwork(buffer);
            node.getTrainNumber().writeNetwork(buffer);
        });
        OpenSignalsMain.network.sendTo(this.tile.get(0).getPlayer(), buffer);
    }

    private void resetAllTrainNumbers() {
        this.listOfNodes.forEach(node -> node.removeTrainNumber());
    }

    public void deactivateAllOutputsOnPathway() {
        this.foreachPath((_u, node) -> {
            List<BlockPos> outputs = node.clearAllManuellOutputs();
            outputs.forEach(pos -> SignalBoxHandler.updateRedstoneOutput(new StateInfo(this.world, (BlockPos)pos), false));
        }, null);
    }

    public void updatePathwayToAutomatic() {
        SignalBoxNode first = this.modeGrid.get(this.originalFirstPoint);
        if (first == null) {
            this.isAutoPathway = false;
            return;
        }
        this.isAutoPathway = first.isAutoPoint();
    }

    private boolean loadTileAndExecute(Consumer<SignalBoxTileEntity> consumer) {
        return this.loadTileAndExecute(this.tilePos, consumer);
    }

    private boolean loadTileAndExecute(BlockPos tilePos, Consumer<SignalBoxTileEntity> consumer) {
        return this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.world, tilePos, (blockTile, _u) -> consumer.accept((SignalBoxTileEntity)blockTile));
    }

    public void checkReRequest() {
        if (this.isAutoPathway) {
            this.holder.requestWay(this.originalFirstPoint, this.getLastPoint());
        }
    }

    public Point getFirstPoint() {
        return this.firstPoint;
    }

    public Point getLastPoint() {
        return this.lastPoint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.firstPoint, this.lastPoint, this.listOfNodes, this.modeGrid, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignalBoxPathway other = (SignalBoxPathway)obj;
        return Objects.equals(this.firstPoint, other.firstPoint) && Objects.equals(this.lastPoint, other.lastPoint) && Objects.equals(this.listOfNodes, other.listOfNodes) && Objects.equals(this.modeGrid, other.modeGrid) && this.type == other.type;
    }

    public String toString() {
        return "SignalBoxPathway [start=" + this.firstPoint + ", end=" + this.lastPoint + "]";
    }

    public ImmutableList<SignalBoxNode> getListOfNodes() {
        return this.listOfNodes;
    }

    public boolean isEmptyOrBroken() {
        return this.emptyOrBroken;
    }

    public boolean isShuntingPath() {
        return this.type.equals((Object)PathType.SHUNTING);
    }
}

