/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.CombinedRedstoneInput;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.SubsidiarySignalParser;
import com.troblecodings.signals.core.RedstoneUpdatePacket;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryEntry;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.enums.SignalBoxNetwork;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxPathway;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.signalbox.SignalBoxUtil;
import com.troblecodings.signals.signalbox.config.ResetInfo;
import com.troblecodings.signals.signalbox.config.SignalConfig;
import com.troblecodings.signals.signalbox.debug.SignalBoxFactory;
import com.troblecodings.signals.signalbox.entrys.INetworkSavable;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;

public class SignalBoxGrid
implements INetworkSavable {
    private static final String NODE_LIST = "nodeList";
    private static final String SUBSIDIARY_LIST = "subsidiaryList";
    private static final String SUBSIDIARY_COUNTER = "subsidiaryCounter";
    private static final String PATHWAY_LIST = "pathwayList";
    private static final String NEXT_PATHWAYS = "nextPathways";
    private static final String START_POINT = "startPoint";
    private static final String END_POINT = "endPoint";
    protected final Map<Point, SignalBoxPathway> startsToPath = new HashMap<Point, SignalBoxPathway>();
    protected final Map<Point, SignalBoxPathway> endsToPath = new HashMap<Point, SignalBoxPathway>();
    protected final List<Map.Entry<Point, Point>> nextPathways = new ArrayList<Map.Entry<Point, Point>>();
    protected final Map<Point, SignalBoxNode> modeGrid = new HashMap<Point, SignalBoxNode>();
    protected final SignalBoxFactory factory;
    private final Map<Point, Map<ModeSet, SubsidiaryEntry>> enabledSubsidiaryTypes = new HashMap<Point, Map<ModeSet, SubsidiaryEntry>>();
    private int counter;
    private SignalBoxTileEntity tile;
    private final List<Map.Entry<Point, Point>> toAdd = new ArrayList<Map.Entry<Point, Point>>();
    private boolean executingForEach = false;

    public SignalBoxGrid() {
        this.factory = SignalBoxFactory.getFactory();
    }

    public void setTile(SignalBoxTileEntity tile) {
        this.tile = tile;
        this.startsToPath.values().forEach(pw -> pw.setTile(tile));
    }

    public void onLoad() {
        this.startsToPath.values().forEach(pw -> pw.linkPathways());
    }

    public void updatePathwayToAutomatic(Point point) {
        SignalBoxPathway pathway = this.startsToPath.get(point);
        if (pathway == null) {
            OpenSignalsMain.getLogger().warn("No pathway to update automatic at [" + point + "]!");
            return;
        }
        pathway.updatePathwayToAutomatic();
    }

    private void onWayAdd(SignalBoxPathway pathway) {
        this.startsToPath.put(pathway.getFirstPoint(), pathway);
        this.endsToPath.put(pathway.getLastPoint(), pathway);
        this.updatePrevious(pathway);
    }

    public List<MainSignalIdentifier> getGreenSignals() {
        ArrayList<MainSignalIdentifier> returnList = new ArrayList<MainSignalIdentifier>();
        this.startsToPath.values().forEach(pathway -> returnList.addAll(pathway.getGreenSignals()));
        return returnList;
    }

    public boolean resetPathway(Point p1) {
        this.enabledSubsidiaryTypes.remove(p1);
        if (this.startsToPath.isEmpty()) {
            return false;
        }
        SignalBoxPathway pathway = this.startsToPath.get(p1);
        if (pathway == null) {
            OpenSignalsMain.getLogger().warn("No Pathway to reset on [" + p1 + "]!");
            return false;
        }
        this.resetPathway(pathway);
        this.updateToNet(pathway);
        this.tryNextPathways();
        return true;
    }

    protected void resetPathway(SignalBoxPathway pathway) {
        pathway.resetPathway();
        this.updatePrevious(pathway);
        this.startsToPath.remove(pathway.getFirstPoint());
        this.endsToPath.remove(pathway.getLastPoint());
    }

    private void updateToNet(SignalBoxPathway pathway) {
        if (this.tile == null || !this.tile.isBlocked()) {
            return;
        }
        ImmutableList<SignalBoxNode> nodes = pathway.getListOfNodes();
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_PW_UPDATE);
        buffer.putInt(nodes.size());
        nodes.forEach(node -> {
            node.getPoint().writeNetwork(buffer);
            node.writeUpdateNetwork(buffer);
        });
        OpenSignalsMain.network.sendTo(this.tile.get(0).getPlayer(), buffer);
    }

    public boolean requestWay(Point p1, Point p2) {
        if (this.startsToPath.containsKey(p1) || this.endsToPath.containsKey(p2)) {
            return false;
        }
        Optional<SignalBoxPathway> ways = SignalBoxUtil.requestWay(this.modeGrid, p1, p2);
        ways.ifPresent(way -> {
            way.setTile(this.tile);
            way.deactivateAllOutputsOnPathway();
            way.setUpdater(pathway -> {
                this.updatePrevious((SignalBoxPathway)pathway);
                this.updateToNet((SignalBoxPathway)pathway);
            });
            way.setSignalBoxGrid(this);
            way.setPathStatus(EnumPathUsage.SELECTED);
            way.updatePathwaySignals();
            this.onWayAdd((SignalBoxPathway)way);
            this.updateToNet((SignalBoxPathway)way);
        });
        return ways.isPresent();
    }

    private void updatePrevious(SignalBoxPathway pathway) {
        SignalBoxPathway previousPath = pathway;
        int count = 0;
        while ((previousPath = this.endsToPath.get(previousPath.getFirstPoint())) != null) {
            if (count > this.endsToPath.size()) {
                OpenSignalsMain.getLogger().error("Detected signalpath cycle, aborting!");
                this.startsToPath.values().forEach(path -> {
                    path.resetPathway();
                    this.updateToNet((SignalBoxPathway)path);
                });
                this.clearPaths();
                break;
            }
            previousPath.setSignals();
            ++count;
        }
        if (count == 0 && OpenSignalsMain.isDebug()) {
            OpenSignalsMain.getLogger().debug("Could not find previous! " + pathway);
        }
    }

    public void resetAllPathways() {
        this.startsToPath.values().forEach(pathway -> pathway.resetPathway());
        this.clearPaths();
    }

    private void clearPaths() {
        this.startsToPath.clear();
        this.endsToPath.clear();
        this.nextPathways.clear();
    }

    public List<Point> getAllInConnections() {
        return this.modeGrid.values().stream().filter(SignalBoxNode::containsInConnection).map(SignalBoxNode::getPoint).collect(Collectors.toList());
    }

    public List<Point> getValidStarts() {
        return this.modeGrid.values().stream().filter(SignalBoxNode::isValidStart).map(SignalBoxNode::getPoint).collect(Collectors.toList());
    }

    public List<Point> getValidEnds() {
        return this.modeGrid.values().stream().filter(SignalBoxNode::isValidEnd).map(SignalBoxNode::getPoint).collect(Collectors.toList());
    }

    public void updateInput(RedstoneUpdatePacket update) {
        ImmutableList nodeCopy = ImmutableList.copyOf(this.startsToPath.values());
        if (update.block instanceof CombinedRedstoneInput) {
            if (update.state) {
                this.tryBlock((List<SignalBoxPathway>)nodeCopy, update.pos);
            } else {
                this.tryReset((List<SignalBoxPathway>)nodeCopy, update.pos);
            }
        } else {
            this.tryBlock((List<SignalBoxPathway>)nodeCopy, update.pos);
            this.tryReset((List<SignalBoxPathway>)nodeCopy, update.pos);
        }
    }

    private void tryBlock(List<SignalBoxPathway> pathways, BlockPos pos) {
        pathways.forEach(pathway -> {
            if (pathway.tryBlock(pos)) {
                this.updatePrevious((SignalBoxPathway)pathway);
                this.updateToNet((SignalBoxPathway)pathway);
            }
        });
    }

    private void tryReset(List<SignalBoxPathway> pathways, BlockPos pos) {
        pathways.forEach(pathway -> {
            Point first = pathway.getFirstPoint();
            Optional<Point> optPoint = pathway.tryReset(pos);
            if (optPoint.isPresent()) {
                if (pathway.isEmptyOrBroken()) {
                    this.resetPathway((SignalBoxPathway)pathway);
                    this.updateToNet((SignalBoxPathway)pathway);
                    pathway.checkReRequest();
                } else {
                    this.updateToNet((SignalBoxPathway)pathway);
                    pathway.compact(optPoint.get());
                    this.startsToPath.remove(first);
                    this.startsToPath.put(pathway.getFirstPoint(), (SignalBoxPathway)pathway);
                }
            }
        });
        this.tryNextPathways();
    }

    private void tryNextPathways() {
        this.executingForEach = true;
        this.nextPathways.removeIf(entry -> {
            boolean request = this.requestWay((Point)entry.getKey(), (Point)entry.getValue());
            if (request) {
                if (this.tile == null || !this.tile.isBlocked()) {
                    return request;
                }
                WriteBuffer buffer = new WriteBuffer();
                buffer.putEnumValue(SignalBoxNetwork.REMOVE_SAVEDPW);
                ((Point)entry.getKey()).writeNetwork(buffer);
                ((Point)entry.getValue()).writeNetwork(buffer);
                OpenSignalsMain.network.sendTo(this.tile.get(0).getPlayer(), buffer);
            }
            return request;
        });
        this.executingForEach = false;
        this.toAdd.forEach(this.nextPathways::add);
        this.toAdd.clear();
        if (this.startsToPath.isEmpty()) {
            this.nextPathways.clear();
        }
    }

    public List<Map.Entry<Point, Point>> getNextPathways() {
        return ImmutableList.copyOf(this.nextPathways);
    }

    public boolean addNextPathway(Point start, Point end) {
        Map.Entry entry = Maps.immutableEntry((Object)start, (Object)end);
        if (!this.nextPathways.contains(entry)) {
            if (this.executingForEach) {
                this.toAdd.add(entry);
            } else {
                this.nextPathways.add(entry);
            }
            return true;
        }
        return false;
    }

    public SignalBoxPathway getPathwayByStartPoint(Point start) {
        return this.startsToPath.get(start);
    }

    public SignalBoxPathway getPathwayByLastPoint(Point end) {
        return this.endsToPath.get(end);
    }

    public void updateTrainNumber(Point point, TrainNumber number) {
        SignalBoxNode node = this.modeGrid.getOrDefault(point, new SignalBoxNode());
        this.startsToPath.values().forEach(pathway -> pathway.checkTrainNumberUpdate(number, node));
    }

    public void removeNextPathway(Point start, Point end) {
        this.nextPathways.remove(Maps.immutableEntry((Object)start, (Object)end));
    }

    @Override
    public void write(NBTWrapper tag) {
        tag.putList(NODE_LIST, this.modeGrid.values().stream().filter(node -> !node.isEmpty()).map(node -> {
            NBTWrapper nodeTag = new NBTWrapper();
            node.write(nodeTag);
            Map<ModeSet, SubsidiaryEntry> subsidiaries = this.enabledSubsidiaryTypes.get(node.getPoint());
            if (subsidiaries == null) {
                return nodeTag;
            }
            nodeTag.putList(SUBSIDIARY_LIST, subsidiaries.entrySet().stream().map(entry -> {
                NBTWrapper subsidiaryTag = new NBTWrapper();
                ((ModeSet)entry.getKey()).write(subsidiaryTag);
                ((SubsidiaryEntry)entry.getValue()).writeNBT(subsidiaryTag);
                return subsidiaryTag;
            })::iterator);
            return nodeTag;
        })::iterator);
        tag.putInteger(SUBSIDIARY_COUNTER, this.counter);
    }

    public void writePathways(NBTWrapper tag) {
        tag.putList(PATHWAY_LIST, this.startsToPath.values().stream().filter(pw -> !pw.isEmptyOrBroken()).map(pathway -> {
            NBTWrapper path = new NBTWrapper();
            pathway.write(path);
            return path;
        })::iterator);
        tag.putList(NEXT_PATHWAYS, this.nextPathways.stream().map(entry -> {
            NBTWrapper wrapper = new NBTWrapper();
            NBTWrapper start = new NBTWrapper();
            ((Point)entry.getKey()).write(start);
            NBTWrapper end = new NBTWrapper();
            ((Point)entry.getValue()).write(end);
            wrapper.putWrapper(START_POINT, start);
            wrapper.putWrapper(END_POINT, end);
            return wrapper;
        })::iterator);
    }

    @Override
    public void read(NBTWrapper tag) {
        this.modeGrid.clear();
        this.enabledSubsidiaryTypes.clear();
        tag.getList(NODE_LIST).forEach(comp -> {
            SignalBoxNode node = new SignalBoxNode();
            node.read((NBTWrapper)comp);
            this.modeGrid.put(node.getPoint(), node);
            List<NBTWrapper> subsidiaryTags = comp.getList(SUBSIDIARY_LIST);
            if (subsidiaryTags == null) {
                return;
            }
            HashMap states = new HashMap();
            subsidiaryTags.forEach(subsidiaryTag -> {
                ModeSet mode = new ModeSet((NBTWrapper)subsidiaryTag);
                states.put(mode, SubsidiaryEntry.of(subsidiaryTag));
            });
            this.enabledSubsidiaryTypes.put(node.getPoint(), states);
        });
        this.counter = tag.getInteger(SUBSIDIARY_COUNTER);
    }

    public void readPathways(NBTWrapper tag) {
        SignalBoxFactory factory = SignalBoxFactory.getFactory();
        if (!tag.contains(PATHWAY_LIST)) {
            return;
        }
        this.clearPaths();
        tag.getList(PATHWAY_LIST).forEach(comp -> {
            SignalBoxPathway pathway = factory.getPathway(this.modeGrid);
            pathway.setUpdater(way -> {
                this.updatePrevious((SignalBoxPathway)way);
                this.updateToNet((SignalBoxPathway)way);
            });
            pathway.setSignalBoxGrid(this);
            pathway.setTile(this.tile);
            pathway.read((NBTWrapper)comp);
            if (pathway.isEmptyOrBroken()) {
                OpenSignalsMain.getLogger().error("Remove empty or broken pathway, try to recover!");
                return;
            }
            this.onWayAdd(pathway);
            pathway.readLinkedPathways((NBTWrapper)comp);
        });
        tag.getList(NEXT_PATHWAYS).forEach(comp -> {
            Point start = new Point();
            start.read(comp.getWrapper(START_POINT));
            Point end = new Point();
            end.read(comp.getWrapper(END_POINT));
            this.nextPathways.add(Maps.immutableEntry((Object)start, (Object)end));
        });
    }

    public int hashCode() {
        return Objects.hash(this.enabledSubsidiaryTypes, this.modeGrid, this.tile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignalBoxGrid other = (SignalBoxGrid)obj;
        return Objects.equals(this.enabledSubsidiaryTypes, other.enabledSubsidiaryTypes) && Objects.equals(this.modeGrid, other.modeGrid) && Objects.equals(this.tile, other.tile);
    }

    public String toString() {
        return "SignalBoxGrid [modeGrid=" + this.modeGrid.entrySet().stream().map(entry -> entry.toString()).collect(Collectors.joining("\n")) + "]";
    }

    public SignalBoxNode getNode(Point point) {
        return this.modeGrid.get(point);
    }

    public List<SignalBoxNode> getNodes() {
        return ImmutableList.copyOf(this.modeGrid.values());
    }

    public int getCurrentCounter() {
        return this.counter;
    }

    public void countOne() {
        this.counter = this.counter < 9999 ? ++this.counter : 0;
    }

    public void setCurrentCounter(int counter) {
        this.counter = counter < 9999 ? counter : 0;
    }

    protected Map<Point, SignalBoxNode> getModeGrid() {
        return this.modeGrid;
    }

    public void putNode(Point point, SignalBoxNode node) {
        this.modeGrid.put(point, node);
    }

    public void putAllNodes(Map<Point, SignalBoxNode> nodes) {
        this.modeGrid.putAll(nodes);
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        this.modeGrid.clear();
        this.enabledSubsidiaryTypes.clear();
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            Point point = Point.of(buffer);
            SignalBoxNode node = new SignalBoxNode(point);
            int enabledSubsidariesSize = buffer.getByteToUnsignedInt();
            if (enabledSubsidariesSize != 0) {
                for (int j = 0; j < enabledSubsidariesSize; ++j) {
                    Map allTypes = this.enabledSubsidiaryTypes.computeIfAbsent(point, _u -> new HashMap());
                    ModeSet mode = ModeSet.of(buffer);
                    SubsidiaryEntry type = SubsidiaryEntry.of(buffer);
                    allTypes.put(mode, type);
                    this.enabledSubsidiaryTypes.put(point, allTypes);
                }
            }
            node.readNetwork(buffer);
            this.modeGrid.put(point, node);
        }
        this.counter = buffer.getInt();
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putInt(this.modeGrid.size());
        this.modeGrid.forEach((point, node) -> {
            point.writeNetwork(buffer);
            Map<ModeSet, SubsidiaryEntry> enabledSubsidiaries = this.enabledSubsidiaryTypes.get(point);
            if (enabledSubsidiaries == null) {
                buffer.putByte((byte)0);
            } else {
                buffer.putByte((byte)enabledSubsidiaries.size());
                enabledSubsidiaries.forEach((mode, state) -> {
                    mode.writeNetwork(buffer);
                    state.writeNetwork(buffer);
                });
            }
            node.writeNetwork(buffer);
        });
        buffer.putInt(this.counter);
    }

    public List<SignalBoxNode> readUpdateNetwork(ReadBuffer buffer, boolean override) {
        int size = buffer.getInt();
        ArrayList<SignalBoxNode> allNodesForPathway = new ArrayList<SignalBoxNode>();
        for (int i = 0; i < size; ++i) {
            SignalBoxNode node;
            Point point = Point.of(buffer);
            if (override) {
                this.modeGrid.remove(point);
                node = new SignalBoxNode(point);
            } else {
                node = this.modeGrid.computeIfAbsent(point, _u -> new SignalBoxNode(point));
            }
            node.readUpdateNetwork(buffer);
            allNodesForPathway.add(node);
            this.modeGrid.put(point, node);
        }
        return allNodesForPathway;
    }

    public BlockPos updateManuellRSOutput(Point point, ModeSet mode, boolean state) {
        SignalBoxNode node = this.modeGrid.get(point);
        if (node == null) {
            return null;
        }
        PathOptionEntry entry = node.getOption(mode).get();
        Optional<BlockPos> outputPos = entry.getEntry(PathEntryType.OUTPUT);
        Optional<EnumPathUsage> usage = entry.getEntry(PathEntryType.PATHUSAGE);
        if (!outputPos.isPresent() || usage.isPresent() && !usage.get().equals((Object)EnumPathUsage.FREE)) {
            return null;
        }
        if (state) {
            node.addManuellOutput(mode);
        } else {
            node.removeManuellOutput(mode);
        }
        return outputPos.get();
    }

    public void updateSubsidiarySignal(Point point, ModeSet mode, SubsidiaryEntry entry) {
        SignalBoxNode node = this.modeGrid.get(point);
        if (node == null) {
            return;
        }
        Optional<BlockPos> pos = node.getOption(mode).get().getEntry(PathEntryType.SIGNAL);
        if (!pos.isPresent()) {
            return;
        }
        Signal signal = SignalBoxHandler.getSignal(new StateInfo(this.tile.func_145831_w(), this.tile.func_174877_v()), pos.get());
        if (!entry.state) {
            if (!this.enabledSubsidiaryTypes.containsKey(point)) {
                return;
            }
            SignalConfig.reset(new ResetInfo(new SignalStateInfo(this.tile.func_145831_w(), pos.get(), signal), false));
            Map<ModeSet, SubsidiaryEntry> states = this.enabledSubsidiaryTypes.get(point);
            states.remove(mode);
            if (states.isEmpty()) {
                this.enabledSubsidiaryTypes.remove(point);
            }
            return;
        }
        Map states = this.enabledSubsidiaryTypes.computeIfAbsent(point, _u -> new HashMap());
        Map<SubsidiaryState, PredicatedPropertyBase.ConfigProperty> configs = SubsidiarySignalParser.SUBSIDIARY_SIGNALS.get((Object)signal);
        if (configs == null) {
            return;
        }
        PredicatedPropertyBase.ConfigProperty properties = configs.get(entry.enumValue);
        if (properties == null) {
            return;
        }
        SignalStateInfo info = new SignalStateInfo(this.tile.func_145831_w(), pos.get(), signal);
        SignalStateHandler.runTaskWhenSignalLoaded(info, (stateInfo, oldProperties, _u) -> SignalStateHandler.setStates(info, ((Map)properties.state).entrySet().stream().filter(propertyEntry -> oldProperties.containsKey(propertyEntry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        states.put(mode, entry);
        this.enabledSubsidiaryTypes.put(point, states);
    }

    public boolean getSubsidiaryState(Point point, ModeSet mode, SubsidiaryState type) {
        Map<ModeSet, SubsidiaryEntry> states = this.enabledSubsidiaryTypes.get(point);
        if (states == null) {
            return false;
        }
        SubsidiaryEntry entry = states.get(mode);
        if (entry == null) {
            return false;
        }
        if (entry.enumValue.equals(type)) {
            return entry.state;
        }
        return false;
    }

    public void setClientState(Point point, ModeSet mode, SubsidiaryEntry entry) {
        if (!entry.state) {
            this.enabledSubsidiaryTypes.remove(point);
            return;
        }
        Map states = this.enabledSubsidiaryTypes.computeIfAbsent(point, _u -> new HashMap());
        states.put(mode, entry);
        this.enabledSubsidiaryTypes.put(point, states);
    }

    public Map<Point, Map<ModeSet, SubsidiaryEntry>> getAllSubsidiaries() {
        return ImmutableMap.copyOf(this.enabledSubsidiaryTypes);
    }

    public List<Point> getAllPoints() {
        return ImmutableList.copyOf(this.modeGrid.keySet());
    }
}

