/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.signalbox.entrys.INetworkSavable;

public class Point
implements INetworkSavable {
    private int x;
    private int y;

    public Point() {
        this.x = 0;
        this.y = 0;
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public Point delta(Point other) {
        Point point = new Point(this);
        point.translate(-other.getX(), -other.getY());
        return point;
    }

    public static Point of(ReadBuffer buffer) {
        return new Point(buffer.getByteToUnsignedInt(), buffer.getByteToUnsignedInt());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        return this.x == other.x && this.y == other.y;
    }

    public int hashCode() {
        int sum = this.x + this.y;
        return sum * (sum + 1) / 2 + this.x;
    }

    public String toString() {
        return "Point[x=" + this.x + ",y=" + this.y + "]";
    }

    public String toShortString() {
        return "[x=" + this.x + ",y=" + this.y + "]";
    }

    @Override
    public void write(NBTWrapper tag) {
        tag.putByte("x", (byte)this.x);
        tag.putByte("y", (byte)this.y);
    }

    @Override
    public void read(NBTWrapper tag) {
        this.x = Byte.toUnsignedInt(tag.getByte("x"));
        this.y = Byte.toUnsignedInt(tag.getByte("y"));
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        this.x = buffer.getByteToUnsignedInt();
        this.y = buffer.getByteToUnsignedInt();
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putByte((byte)this.x);
        buffer.putByte((byte)this.y);
    }
}

