/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.signals.signalbox.Point;
import java.util.Objects;

public class Path {
    private static final String POINT_1 = "point1";
    private static final String POINT_2 = "point2";
    public final Point point1;
    public final Point point2;

    public Path() {
        this.point1 = new Point();
        this.point2 = new Point();
    }

    public Path(Point point1, Point point2) {
        this.point1 = Objects.requireNonNull(point1);
        this.point2 = Objects.requireNonNull(point2);
    }

    public Point getPoint1() {
        return this.point1;
    }

    public Point getPoint2() {
        return this.point2;
    }

    public Path getInverse() {
        return new Path(this.point2, this.point1);
    }

    public void write(NBTWrapper tag) {
        NBTWrapper compound1 = new NBTWrapper();
        this.point1.write(compound1);
        tag.putWrapper(POINT_1, compound1);
        NBTWrapper compound2 = new NBTWrapper();
        this.point2.write(compound2);
        tag.putWrapper(POINT_2, compound2);
    }

    public void read(NBTWrapper tag) {
        this.point1.read(tag.getWrapper(POINT_1));
        this.point2.read(tag.getWrapper(POINT_2));
    }

    public int hashCode() {
        return Objects.hash(this.point1, this.point2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Objects.equals(this.point1, other.point1) && Objects.equals(this.point2, other.point2);
    }

    public String toString() {
        return "Path [point1=" + this.point1 + ", point2=" + this.point2 + "]";
    }
}

