/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.signalbox.entrys.INetworkSavable;
import java.util.Objects;
import net.minecraft.util.Rotation;

public class ModeSet
implements INetworkSavable {
    private static final String MODE = "mode";
    private static final String ROTATION = "rotation";
    public EnumGuiMode mode;
    public Rotation rotation;

    public ModeSet(NBTWrapper compound) {
        this.read(Objects.requireNonNull(compound));
    }

    public ModeSet(EnumGuiMode mode, Rotation rotation) {
        this.mode = Objects.requireNonNull(mode);
        this.rotation = Objects.requireNonNull(rotation);
    }

    private ModeSet(ReadBuffer buffer) {
        this.readNetwork(buffer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.rotation});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModeSet other = (ModeSet)obj;
        return this.mode == other.mode && this.rotation == other.rotation;
    }

    public String toString() {
        return "ModeSet [mode=" + (Object)((Object)this.mode) + ", rotation=" + this.rotation + "]";
    }

    @Override
    public void write(NBTWrapper tag) {
        tag.putString(MODE, this.mode.name());
        tag.putString(ROTATION, this.rotation.name());
    }

    @Override
    public void read(NBTWrapper tag) {
        this.mode = EnumGuiMode.valueOf(tag.getString(MODE));
        this.rotation = Rotation.valueOf((String)tag.getString(ROTATION));
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        this.mode = EnumGuiMode.values()[buffer.getByteToUnsignedInt()];
        this.rotation = Rotation.values()[buffer.getByteToUnsignedInt()];
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putByte((byte)this.mode.ordinal());
        buffer.putByte((byte)this.rotation.ordinal());
    }

    public static ModeSet of(ReadBuffer buffer) {
        return new ModeSet(buffer);
    }
}

