/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.parser;

import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.enums.CompareValues;
import com.troblecodings.signals.models.ModelInfoWrapper;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.parser.StringInteger;
import com.troblecodings.signals.parser.ValuePack;
import java.util.Map;
import java.util.function.Predicate;

public final class PredicateHolder {
    private PredicateHolder() {
    }

    public static Predicate<ModelInfoWrapper> has(SEProperty property) {
        return ebs -> ebs.get(property) != null;
    }

    public static Predicate<ModelInfoWrapper> hasNot(SEProperty property) {
        return ebs -> ebs.get(property) == null;
    }

    public static Predicate<ModelInfoWrapper> with(ValuePack pack) {
        return ebs -> {
            String test = ebs.get(pack.property);
            return test != null && pack.predicate.test(test);
        };
    }

    public static Predicate<ModelInfoWrapper> hasAndIs(SEProperty property) {
        return ebs -> {
            Boolean bool = "TRUE".equalsIgnoreCase(ebs.get(property));
            return bool;
        };
    }

    public static Predicate<ModelInfoWrapper> hasAndIsNot(SEProperty property) {
        return ebs -> {
            String cacheString = ebs.get(property);
            if (cacheString == null) {
                return false;
            }
            Boolean bool = "TRUE".equalsIgnoreCase(ebs.get(property));
            return bool == false;
        };
    }

    public static Predicate<Map<SEProperty, String>> config(ValuePack pack) {
        return t -> {
            String value = (String)t.get(pack.property);
            if (value == null) {
                return false;
            }
            return pack.predicate.test(value.toUpperCase());
        };
    }

    public static Predicate<Integer> speed(StringInteger stringInt) {
        CompareValues values = CompareValues.of(stringInt.string);
        if (values == null) {
            throw new LogicalParserException("The given operator of the speed function [" + stringInt.string + "] is not permitted!");
        }
        int speed = stringInt.integer;
        switch (values) {
            case GREATER: {
                return s -> s > speed;
            }
            case GREATEREQUALS: {
                return s -> s >= speed;
            }
            case EQUALS: {
                return s -> s == speed;
            }
            case SMALLEREQUALS: {
                return s -> s <= speed;
            }
            case SMALLER: {
                return s -> s < speed;
            }
            case UNEQUALS: {
                return s -> s != speed;
            }
        }
        return s -> s == speed;
    }

    public static Predicate<String> zs2Value(String value) {
        return s -> s.equalsIgnoreCase(value);
    }

    public static Predicate<Boolean> signalRepeater(boolean state) {
        return s -> s == state;
    }
}

