/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.parser;

import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.models.ModelInfoWrapper;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.IntermidiateLogic;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.parser.MethodInfo;
import com.troblecodings.signals.parser.PredicateHolder;
import com.troblecodings.signals.parser.StringInteger;
import com.troblecodings.signals.parser.ValuePack;
import com.troblecodings.signals.parser.interm.EvaluationLevel;
import com.troblecodings.signals.parser.interm.IntermidiateNode;
import com.troblecodings.signals.parser.interm.LogicalSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraftforge.common.property.IUnlistedProperty;

public final class LogicParser {
    public static final HashMap<String, MethodInfo> TRANSLATION_TABLE = new HashMap();
    public static final HashMap<String, MethodInfo> UNIVERSAL_TRANSLATION_TABLE = new HashMap();
    private static final int ERROR_CLAMP = 20;

    private LogicParser() {
    }

    public static Predicate<ModelInfoWrapper> nDegreeFunctionParser(String name, FunctionParsingInfo parser, String ... parameter) {
        String[] arguments = parameter;
        MethodInfo method = parser.getTable().get(name.toLowerCase());
        if (method == null) {
            throw new LogicalParserException(String.format("Syntax error function=%s does not exist permitted are:%n%s", name, parser.getTable().keySet().toString()));
        }
        int length = method.parameter.length;
        if (arguments.length != length) {
            throw new LogicalParserException(String.format("Wrong argument count in function=%s, needed=%d, actual=%d", name, length, arguments.length));
        }
        return method.blockState.apply(parser.getParameter(method.parameter, arguments));
    }

    private static final String getSubstringError(String input, int index) {
        if (input.isEmpty()) {
            return input;
        }
        int start = index - 20;
        int end = index + 20 + Math.abs(Math.min(0, start));
        int eStart = Math.max(start, 0);
        String erroring = input.substring(eStart, Math.min(end, input.length()));
        char[] nextLine = new char[erroring.length()];
        Arrays.fill(nextLine, ' ');
        nextLine[index - eStart - 1] = 94;
        return erroring + System.lineSeparator() + new String(nextLine);
    }

    public static IntermidiateLogic parse(String input, FunctionParsingInfo info) {
        char[] array = input.toCharArray();
        IntermidiateLogic logic = new IntermidiateLogic();
        StringBuilder builder = new StringBuilder();
        String nextName = null;
        int i = 0;
        for (char current : array) {
            ++i;
            try {
                if (current == '(') {
                    if (builder.length() <= 0) {
                        logic.push();
                        continue;
                    }
                    nextName = builder.toString();
                    builder.setLength(0);
                    continue;
                }
                if (current == ')') {
                    if (nextName == null) {
                        logic.pop();
                        continue;
                    }
                    String arguments = builder.toString();
                    logic.add(new IntermidiateNode(LogicParser.nDegreeFunctionParser(nextName, info, arguments.isEmpty() ? new String[]{} : arguments.split(",")), EvaluationLevel.PRELEVEL));
                    builder.setLength(0);
                    nextName = null;
                    continue;
                }
                if (Character.isWhitespace(current)) continue;
                builder.append(current);
                LogicalSymbols symbol = LogicalSymbols.find(builder.toString());
                if (symbol == null) continue;
                logic.add(symbol.builder.get());
                builder.setLength(0);
            }
            catch (Throwable e) {
                throw new LogicalParserException("Parserstate: " + System.lineSeparator() + LogicParser.getSubstringError(input, i), e);
            }
        }
        return logic;
    }

    public static <T> Predicate<T> predicate(String input, FunctionParsingInfo info) {
        return LogicParser.parse(input, info).pop().getPredicate();
    }

    static {
        TRANSLATION_TABLE.put("with", new MethodInfo(IUnlistedProperty.class, "with", objects -> PredicateHolder.with((ValuePack)objects[0]), ValuePack.class));
        TRANSLATION_TABLE.put("has", new MethodInfo(IUnlistedProperty.class, "has", objects -> PredicateHolder.has((SEProperty)objects[0]), SEProperty.class));
        TRANSLATION_TABLE.put("hasandis", new MethodInfo(IUnlistedProperty.class, "hasandis", objects -> PredicateHolder.hasAndIs((SEProperty)objects[0]), SEProperty.class));
        TRANSLATION_TABLE.put("hasandisnot", new MethodInfo(IUnlistedProperty.class, "hasandisnot", objects -> PredicateHolder.hasAndIsNot((SEProperty)objects[0]), SEProperty.class));
        TRANSLATION_TABLE.put("check", new MethodInfo(Map.class, "check", objects -> PredicateHolder.config((ValuePack)objects[0]), ValuePack.class));
        TRANSLATION_TABLE.put("config", new MethodInfo(Map.class, "config", objects -> PredicateHolder.config((ValuePack)objects[0]), ValuePack.class));
        TRANSLATION_TABLE.put("speed", new MethodInfo(Integer.class, "speed", objects -> PredicateHolder.speed((StringInteger)objects[0]), StringInteger.class));
        TRANSLATION_TABLE.put("zs2value", new MethodInfo(String.class, "zs2value", obj -> PredicateHolder.zs2Value((String)obj[0]), String.class));
        TRANSLATION_TABLE.put("signalrepeater", new MethodInfo(Boolean.class, "signalrepeater", obj -> PredicateHolder.signalRepeater((Boolean)obj[0]), Boolean.class));
        TRANSLATION_TABLE.forEach((name, info) -> UNIVERSAL_TRANSLATION_TABLE.put((String)name, new MethodInfo(Map.class, (String)name, objects -> {
            Predicate original = info.blockState.apply((Object[])objects);
            return inMap -> {
                Map map = inMap;
                Object obj = map.get(info.getSubtype());
                if (obj == null) {
                    throw new IllegalArgumentException(String.format("No data for type=%s was passed to function=%s!", info.getSubtype().toString(), name));
                }
                return original.test(obj);
            };
        }, info.parameter)));
    }
}

