/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.models;

import com.troblecodings.core.interfaces.BlockModelDataWrapper;
import com.troblecodings.signals.SEProperty;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelInfoWrapper
implements BlockModelDataWrapper {
    public IExtendedBlockState state;

    public ModelInfoWrapper(IExtendedBlockState state) {
        this.state = state;
    }

    public ModelInfoWrapper(Block block) {
        this.state = (IExtendedBlockState)block.func_176223_P();
    }

    public ModelInfoWrapper(Block block, Map<SEProperty, String> properties) {
        this(block);
        properties.forEach((property, value) -> {
            this.state = this.state.withProperty((IUnlistedProperty)property, value);
        });
    }

    public IExtendedBlockState getBlockState() {
        return this.state;
    }

    public <T> boolean hasProperty(IUnlistedProperty<T> prop) {
        return this.state.getUnlistedNames().contains(prop);
    }

    public <T> T getData(IUnlistedProperty<T> prop) {
        Optional opt = (Optional)this.state.getUnlistedProperties().get(prop);
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    public <T> T setData(IUnlistedProperty<T> prop, T value) {
        this.state = this.state.withProperty(prop, value);
        return (T)prop;
    }

    public boolean has(SEProperty property) {
        return this.hasProperty(property);
    }

    public String get(SEProperty property) {
        return this.getData(property);
    }

    public void set(SEProperty property, String value) {
        this.setData(property, value);
    }
}

