/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.core.interfaces.INetworkSync;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.LoadHolder;
import com.troblecodings.signals.core.PathGetter;
import com.troblecodings.signals.core.SignalStateListener;
import com.troblecodings.signals.core.StateLoadHolder;
import com.troblecodings.signals.enums.ChangedState;
import com.troblecodings.signals.handler.SignalStateFile;
import com.troblecodings.signals.handler.SignalStateFileV2;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.handler.SignalStatePosV2;
import com.troblecodings.signals.tileentitys.SignalTileEntity;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public final class SignalStateHandler
implements INetworkSync {
    private static ExecutorService writeService = Executors.newFixedThreadPool(5);
    private static final Map<SignalStateInfo, Map<SEProperty, String>> CURRENTLY_LOADED_STATES = new HashMap<SignalStateInfo, Map<SEProperty, String>>();
    private static final Map<World, SignalStateFileV2> ALL_LEVEL_FILES = new HashMap<World, SignalStateFileV2>();
    private static final Map<SignalStateInfo, List<LoadHolder<?>>> SIGNAL_COUNTER = new HashMap();
    private static final Map<SignalStateInfo, List<SignalStateListener>> ALL_LISTENERS = new HashMap<SignalStateInfo, List<SignalStateListener>>();
    private static final Map<SignalStateInfo, List<SignalStateListener>> TASKS_WHEN_LOAD = new HashMap<SignalStateInfo, List<SignalStateListener>>();
    private static final String CHANNELNAME = "statehandlernet";
    private static FMLEventChannel channel;

    private SignalStateHandler() {
    }

    public static void init() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELNAME);
    }

    public static void registerToNetworkChannel(Object object) {
        channel.register(object);
    }

    public static void onServerStop(FMLServerStoppingEvent event) {
        writeService.shutdown();
        try {
            writeService.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        writeService = Executors.newFixedThreadPool(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStates(SignalStateInfo info, Map<SEProperty, String> states, EntityPlayer creator) {
        if (info.world.field_72995_K) {
            return;
        }
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            CURRENTLY_LOADED_STATES.put(info, (Map<SEProperty, String>)ImmutableMap.copyOf(states));
        }
        new Thread(() -> {
            ArrayList<LoadHolder<EntityPlayer>> list = new ArrayList<LoadHolder<EntityPlayer>>();
            list.add(new LoadHolder<EntityPlayer>(creator));
            Map<SignalStateInfo, List<LoadHolder<?>>> map = SIGNAL_COUNTER;
            synchronized (map) {
                SIGNAL_COUNTER.put(info, list);
            }
            SignalStateHandler.sendToAll(info, states);
            SignalStateHandler.createToFile(info, states);
            SignalStateHandler.updateListeners(info, states, ChangedState.ADDED_TO_FILE);
        }, "OSSignalStateHandler:createStates").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSignalLoaded(SignalStateInfo info) {
        if (info.world.field_72995_K) {
            return false;
        }
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            return CURRENTLY_LOADED_STATES.containsKey(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTaskWhenSignalLoaded(SignalStateInfo info, SignalStateListener listener) {
        if (info == null || info.world.field_72995_K) {
            return;
        }
        if (SignalStateHandler.isSignalLoaded(info)) {
            Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
            synchronized (map) {
                listener.update(info, CURRENTLY_LOADED_STATES.get(info), ChangedState.UPDATED);
            }
        }
        Map<SignalStateInfo, List<SignalStateListener>> map = TASKS_WHEN_LOAD;
        synchronized (map) {
            List list = TASKS_WHEN_LOAD.computeIfAbsent(info, _u -> new ArrayList());
            if (!list.contains(listener)) {
                list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SignalStateInfo info, SignalStateListener listener) {
        Map<SignalStateInfo, List<SignalStateListener>> map = ALL_LISTENERS;
        synchronized (map) {
            List listeners = ALL_LISTENERS.computeIfAbsent(info, _u -> new ArrayList());
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(SignalStateInfo info, SignalStateListener listener) {
        List<SignalStateListener> listeners;
        Map<SignalStateInfo, List<SignalStateListener>> map = ALL_LISTENERS;
        synchronized (map) {
            listeners = ALL_LISTENERS.get(info);
        }
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            map = ALL_LISTENERS;
            synchronized (map) {
                ALL_LISTENERS.remove(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateListeners(SignalStateInfo info, Map<SEProperty, String> changedProperties, ChangedState changedState) {
        List<SignalStateListener> listeners;
        Map<SignalStateInfo, List<SignalStateListener>> map = ALL_LISTENERS;
        synchronized (map) {
            listeners = ALL_LISTENERS.get(info);
        }
        if (listeners == null) {
            return;
        }
        info.world.func_73046_m().func_152344_a(() -> listeners.forEach(listener -> listener.update(info, changedProperties, changedState)));
    }

    private static void statesToBuffer(Signal signal, Map<SEProperty, String> states, byte[] readData) {
        states.forEach((property, string) -> {
            readData[signal.getIDFromProperty((SEProperty)property)] = (byte)(property.getParent().getIDFromValue((String)string) + 1);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createToFile(SignalStateInfo info, Map<SEProperty, String> states) {
        SignalStateFileV2 file;
        if (states == null) {
            return;
        }
        Map<World, SignalStateFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            file = ALL_LEVEL_FILES.get(info.world);
            if (file == null) {
                return;
            }
        }
        SignalStatePosV2 pos = file.find(info.pos);
        if (pos == null) {
            pos = file.create(info.pos);
        }
        SignalStateFileV2 signalStateFileV2 = file;
        synchronized (signalStateFileV2) {
            ByteBuffer buffer = file.read(pos);
            SignalStateHandler.statesToBuffer(info.signal, states, buffer.array());
            file.write(pos, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateWorldFilesToV2(World world) {
        SignalStateFileV2 newFile;
        Path oldPath = Paths.get("osfiles/signalfiles/" + ((WorldServer)world).func_73046_m().func_70005_c_().replace(":", "").replace("/", "").replace("\\", "") + "/" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", ""), new String[0]);
        if (!Files.exists(oldPath, new LinkOption[0])) {
            return;
        }
        OpenSignalsMain.getLogger().info("Starting Migration from SignalStateFileV1 to SignalStateFileV2...");
        SignalStateFile oldFile = new SignalStateFile(oldPath);
        Map<World, SignalStateFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            newFile = ALL_LEVEL_FILES.get(world);
        }
        oldFile.getAllEntries().forEach((pos, buffer) -> newFile.create((BlockPos)pos, buffer.array()));
        OpenSignalsMain.getLogger().info("Finished Migration from SignalStateFileV1 to SignalStateFileV2!");
        try {
            Files.list(oldPath).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Files.delete(oldPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStates(SignalStateInfo info, Map<SEProperty, String> states) {
        if (info.world.field_72995_K || states == null || states.isEmpty()) {
            return;
        }
        AtomicBoolean contains = new AtomicBoolean(false);
        HashMap<SEProperty, String> changedProperties = new HashMap<SEProperty, String>();
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            if (CURRENTLY_LOADED_STATES.containsKey(info)) {
                contains.set(true);
                HashMap<SEProperty, String> oldStates = new HashMap<SEProperty, String>(CURRENTLY_LOADED_STATES.get(info));
                states.entrySet().stream().filter(entry -> {
                    String oldState = (String)oldStates.get(entry.getKey());
                    return !((String)entry.getValue()).equals(oldState);
                }).forEach(entry -> {
                    String cfr_ignored_0 = (String)changedProperties.put((SEProperty)entry.getKey(), (String)entry.getValue());
                });
                oldStates.putAll(states);
                CURRENTLY_LOADED_STATES.put(info, (Map<SEProperty, String>)ImmutableMap.copyOf(oldStates));
            } else {
                changedProperties.putAll(states);
            }
        }
        new Thread(() -> {
            SignalStateHandler.sendToAll(info, changedProperties);
            SignalStateHandler.updateListeners(info, changedProperties, ChangedState.UPDATED);
            info.world.func_73046_m().func_152344_a(() -> info.signal.getUpdate(info.world, info.pos));
            if (!contains.get()) {
                SignalStateHandler.createToFile(info, changedProperties);
            }
        }, "OSSignalStateHandler:setStates").start();
        info.world.func_73046_m().func_152344_a(() -> info.world.func_175685_c(info.pos, (Block)info.signal, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<SEProperty, String> getStates(SignalStateInfo info) {
        ImmutableMap states;
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            Map<SEProperty, String> stateVolitile = CURRENTLY_LOADED_STATES.get(info);
            states = stateVolitile == null ? null : ImmutableMap.copyOf(stateVolitile);
        }
        if (states != null) {
            return states;
        }
        if (info.world.field_72995_K) {
            return new HashMap<SEProperty, String>();
        }
        return SignalStateHandler.readAndSerialize(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setState(SignalStateInfo info, SEProperty property, String value) {
        HashMap<SEProperty, String> map = new HashMap<SEProperty, String>();
        Map<SignalStateInfo, Map<SEProperty, String>> map2 = CURRENTLY_LOADED_STATES;
        synchronized (map2) {
            HashMap savedProperties = CURRENTLY_LOADED_STATES.get(info);
            map.putAll(savedProperties == null ? new HashMap() : savedProperties);
        }
        map.put(property, value);
        SignalStateHandler.setStates(info, map);
    }

    public static Optional<String> getState(SignalStateInfo info, SEProperty property) {
        Map<SEProperty, String> properties = SignalStateHandler.getStates(info);
        return Optional.ofNullable(properties.get(property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<SEProperty, String> readAndSerialize(SignalStateInfo stateInfo) {
        ByteBuffer buffer;
        SignalStateFileV2 file;
        HashMap<SEProperty, String> map = new HashMap<SEProperty, String>();
        Map<World, SignalStateFileV2> map2 = ALL_LEVEL_FILES;
        synchronized (map2) {
            file = ALL_LEVEL_FILES.get(stateInfo.world);
        }
        SignalStateFileV2 signalStateFileV2 = file;
        synchronized (signalStateFileV2) {
            SignalStatePosV2 pos = file.find(stateInfo.pos);
            if (pos == null) {
                if (stateInfo.world.field_72995_K) {
                    OpenSignalsMain.getLogger().warn("Position [" + stateInfo + "] not found on client!");
                    return map;
                }
                OpenSignalsMain.getLogger().warn("Position [" + stateInfo + "] not found in file, recovering!");
                pos = file.create(stateInfo.pos);
            }
            buffer = file.read(pos);
        }
        List<SEProperty> properties = stateInfo.signal.getProperties();
        byte[] byteArray = buffer.array();
        for (int i = 0; i < properties.size(); ++i) {
            SEProperty property = properties.get(i);
            int typeID = Byte.toUnsignedInt(byteArray[i]);
            if (typeID <= 0) continue;
            String value = property.getObjFromID(typeID - 1);
            map.put(property, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Path path = PathGetter.getNewPathForFiles(world, "signalfiles");
        Map<World, SignalStateFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            ALL_LEVEL_FILES.put(world, new SignalStateFileV2(path));
        }
        SignalStateHandler.migrateWorldFilesToV2(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save save) {
        ImmutableMap maps;
        World world = save.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            maps = ImmutableMap.copyOf(CURRENTLY_LOADED_STATES);
        }
        writeService.execute(() -> SignalStateHandler.lambda$onWorldSave$15((Map)maps, world));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload unload) {
        if (unload.getWorld().field_72995_K) {
            return;
        }
        Map<World, SignalStateFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            ALL_LEVEL_FILES.remove(unload.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRemoved(SignalStateInfo info) {
        SignalStateFileV2 file;
        Map<SEProperty, String> removedProperties;
        Map<SignalStateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            removedProperties = CURRENTLY_LOADED_STATES.remove(info);
        }
        Map<SignalStateInfo, List<Object>> map2 = ALL_LEVEL_FILES;
        synchronized (map2) {
            file = ALL_LEVEL_FILES.get(info.world);
        }
        map2 = file;
        synchronized (map2) {
            file.deleteIndex(info.pos);
        }
        map2 = SIGNAL_COUNTER;
        synchronized (map2) {
            SIGNAL_COUNTER.remove(info);
        }
        SignalStateHandler.updateListeners(info, removedProperties, ChangedState.REMOVED_FROM_FILE);
        map2 = ALL_LISTENERS;
        synchronized (map2) {
            ALL_LISTENERS.remove(info);
        }
    }

    public static void sendRemoved(SignalStateInfo info) {
        WriteBuffer buffer = new WriteBuffer();
        buffer.putBlockPos(info.pos);
        buffer.putInt(info.signal.getID());
        buffer.putByte((byte)-1);
        info.world.field_73010_i.forEach(player -> SignalStateHandler.sendTo(player, buffer.getBuildedBuffer()));
    }

    public static ByteBuffer packToByteBuffer(SignalStateInfo stateInfo, Map<SEProperty, String> properties) {
        if (properties.size() > 254) {
            throw new IllegalStateException("Too many SEProperties!");
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putBlockPos(stateInfo.pos);
        buffer.putInt(stateInfo.signal.getID());
        buffer.putByte((byte)properties.size());
        properties.forEach((property, value) -> {
            buffer.putByte((byte)stateInfo.signal.getIDFromProperty((SEProperty)property));
            buffer.putByte((byte)property.getParent().getIDFromValue((String)value));
        });
        return buffer.build();
    }

    private static void sendTo(SignalStateInfo info, Map<SEProperty, String> properties, @Nullable EntityPlayer player) {
        if (player == null) {
            SignalStateHandler.sendToAll(info, properties);
        } else {
            SignalStateHandler.sendToPlayer(info, properties, player);
        }
    }

    private static void sendToPlayer(SignalStateInfo stateInfo, Map<SEProperty, String> properties, EntityPlayer player) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SignalStateHandler.sendTo(player, SignalStateHandler.packToByteBuffer(stateInfo, properties));
    }

    private static void sendToAll(SignalStateInfo stateInfo, Map<SEProperty, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        ByteBuffer buffer = SignalStateHandler.packToByteBuffer(stateInfo, properties);
        stateInfo.world.field_73010_i.forEach(player -> SignalStateHandler.sendTo(player, buffer));
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        World world = chunk.func_177412_p();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        ArrayList<StateLoadHolder> states = new ArrayList<StateLoadHolder>();
        ImmutableMap.copyOf((Map)chunk.func_177434_r()).forEach((arg_0, arg_1) -> SignalStateHandler.lambda$onChunkWatch$19(world, states, (EntityPlayer)player, arg_0, arg_1));
        SignalStateHandler.loadSignals(states, (EntityPlayer)player);
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
        Chunk chunk = event.getChunkInstance();
        World world = chunk.func_177412_p();
        if (world.field_72995_K) {
            return;
        }
        ArrayList<StateLoadHolder> states = new ArrayList<StateLoadHolder>();
        ImmutableMap.copyOf((Map)chunk.func_177434_r()).forEach((pos, tile) -> {
            if (tile instanceof SignalTileEntity) {
                SignalTileEntity signalTile = (SignalTileEntity)tile;
                states.add(new StateLoadHolder(new SignalStateInfo(world, (BlockPos)pos, signalTile.getSignal()), new LoadHolder<EntityPlayerMP>(event.getPlayer())));
            }
        });
        SignalStateHandler.unloadSignals(states);
    }

    public static void loadSignal(StateLoadHolder info) {
        SignalStateHandler.loadSignal(info, null);
    }

    public static void loadSignals(List<StateLoadHolder> signals) {
        SignalStateHandler.loadSignals(signals, null);
    }

    public static void loadSignal(StateLoadHolder info, @Nullable EntityPlayer player) {
        SignalStateHandler.loadSignals((List<StateLoadHolder>)ImmutableList.of((Object)info), player);
    }

    public static void loadSignals(List<StateLoadHolder> signals, @Nullable EntityPlayer player) {
        if (signals == null || signals.isEmpty()) {
            return;
        }
        new Thread(() -> signals.forEach(info -> {
            Map<SignalStateInfo, Object> map;
            boolean isLoaded = false;
            Map<SignalStateInfo, List<LoadHolder<?>>> map2 = SIGNAL_COUNTER;
            synchronized (map2) {
                List holders = SIGNAL_COUNTER.computeIfAbsent(info.info, _u -> new ArrayList());
                if (holders.size() > 0) {
                    isLoaded = true;
                }
                if (!holders.contains(info.holder)) {
                    holders.add(info.holder);
                }
            }
            if (isLoaded) {
                Map<SEProperty, String> sendProperties;
                map = CURRENTLY_LOADED_STATES;
                synchronized (map) {
                    sendProperties = CURRENTLY_LOADED_STATES.get(info.info);
                }
                SignalStateHandler.sendTo(info.info, sendProperties, player);
                return;
            }
            Map<SEProperty, String> properties = SignalStateHandler.readAndSerialize(info.info);
            map = CURRENTLY_LOADED_STATES;
            synchronized (map) {
                CURRENTLY_LOADED_STATES.put(info.info, properties);
            }
            SignalStateHandler.sendToAll(info.info, properties);
            SignalStateHandler.updateListeners(info.info, properties, ChangedState.ADDED_TO_CACHE);
            map = TASKS_WHEN_LOAD;
            synchronized (map) {
                List<SignalStateListener> tasks = TASKS_WHEN_LOAD.remove(info.info);
                if (tasks != null) {
                    tasks.forEach(listener -> listener.update(info.info, properties, ChangedState.ADDED_TO_CACHE));
                }
            }
        }), "OSSignalStateHandler:loadSignals").start();
    }

    public static void unloadSignal(StateLoadHolder info) {
        SignalStateHandler.unloadSignals((List<StateLoadHolder>)ImmutableList.of((Object)info));
    }

    public static void unloadSignals(List<StateLoadHolder> signals) {
        if (signals == null || signals.isEmpty() || writeService.isShutdown()) {
            return;
        }
        writeService.execute(() -> signals.forEach(info -> {
            Map<SEProperty, String> properties;
            Map<SignalStateInfo, List<LoadHolder<?>>> map = SIGNAL_COUNTER;
            synchronized (map) {
                List holders = SIGNAL_COUNTER.getOrDefault(info.info, new ArrayList());
                holders.remove(info.holder);
                if (!holders.isEmpty()) {
                    return;
                }
                SIGNAL_COUNTER.remove(info.info);
            }
            Map<SignalStateInfo, Map<SEProperty, String>> map2 = CURRENTLY_LOADED_STATES;
            synchronized (map2) {
                properties = CURRENTLY_LOADED_STATES.remove(info.info);
            }
            if (properties == null) {
                return;
            }
            SignalStateHandler.createToFile(info.info, properties);
            SignalStateHandler.updateListeners(info.info, properties, ChangedState.REMOVED_FROM_CACHE);
        }));
    }

    private static void sendTo(EntityPlayer player, ByteBuffer buf) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((ByteBuffer)((ByteBuffer)buf.position(0))));
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP server = (EntityPlayerMP)player;
            channel.sendTo(new FMLProxyPacket(buffer, CHANNELNAME), server);
        } else {
            channel.sendToServer(new FMLProxyPacket(new CPacketCustomPayload(CHANNELNAME, buffer)));
        }
    }

    @SubscribeEvent
    public void clientEvent(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.deserializeServer(event.getPacket().payload().nioBuffer());
    }

    private static /* synthetic */ void lambda$onChunkWatch$19(World world, List states, EntityPlayer player, BlockPos pos, TileEntity tile) {
        if (tile instanceof SignalTileEntity) {
            SignalTileEntity signalTile = (SignalTileEntity)tile;
            SignalStateInfo info = new SignalStateInfo(world, pos, signalTile.getSignal());
            states.add(new StateLoadHolder(info, new LoadHolder<EntityPlayer>(player)));
        }
    }

    private static /* synthetic */ void lambda$onWorldSave$15(Map maps, World world) {
        maps.entrySet().stream().filter(entry -> ((SignalStateInfo)entry.getKey()).world.equals(world)).forEach(entry -> SignalStateHandler.createToFile((SignalStateInfo)entry.getKey(), (Map)entry.getValue()));
    }
}

