/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.google.common.collect.ImmutableMap;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.interfaces.INetworkSync;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.StateInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientSignalStateHandler
implements INetworkSync {
    private static final Map<StateInfo, Map<SEProperty, String>> CURRENTLY_LOADED_STATES = new HashMap<StateInfo, Map<SEProperty, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<SEProperty, String> getClientStates(StateInfo info) {
        Map<StateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            return ImmutableMap.copyOf((Map)CURRENTLY_LOADED_STATES.computeIfAbsent(info, _u -> new HashMap()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeClient(ReadBuffer buffer) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient level = mc.field_71441_e;
        if (level == null) {
            return;
        }
        BlockPos signalPos = buffer.getBlockPos();
        int signalID = buffer.getInt();
        int propertiesSize = buffer.getByteToUnsignedInt();
        if (propertiesSize == 255) {
            ClientSignalStateHandler.setRemoved(signalPos);
            return;
        }
        int[] propertyIDs = new int[propertiesSize];
        int[] valueIDs = new int[propertiesSize];
        for (int i = 0; i < propertiesSize; ++i) {
            propertyIDs[i] = buffer.getByteToUnsignedInt();
            valueIDs[i] = buffer.getByteToUnsignedInt();
        }
        List<SEProperty> signalProperties = Signal.SIGNAL_IDS.get(signalID).getProperties();
        StateInfo stateInfo = new StateInfo((World)level, signalPos);
        Map<StateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            Map properties = CURRENTLY_LOADED_STATES.computeIfAbsent(stateInfo, _u -> new HashMap());
            for (int i = 0; i < propertiesSize; ++i) {
                SEProperty property = signalProperties.get(propertyIDs[i]);
                String value = property.getObjFromID(valueIDs[i]);
                properties.put(property, value);
            }
            CURRENTLY_LOADED_STATES.put(stateInfo, properties);
        }
        mc.func_152344_a(() -> {
            Chunk chunk = level.func_175726_f(signalPos);
            if (chunk == null) {
                return;
            }
            chunk.func_76630_e();
            IBlockState state = level.func_180495_p(signalPos);
            if (state == null) {
                return;
            }
            mc.field_71438_f.func_174959_b(signalPos);
            mc.field_71438_f.func_184376_a((World)level, signalPos, state, state, 8);
            level.func_184138_a(signalPos, state, state, 3);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRemoved(BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        Map<StateInfo, Map<SEProperty, String>> map = CURRENTLY_LOADED_STATES;
        synchronized (map) {
            CURRENTLY_LOADED_STATES.remove(new StateInfo((World)mc.field_71441_e, pos));
        }
    }

    @SubscribeEvent
    public void serverEvent(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.deserializeClient(event.getPacket().payload().nioBuffer());
    }
}

