/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.interfaces.INetworkSync;
import com.troblecodings.signals.core.StateInfo;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientNameHandler
implements INetworkSync {
    private static final Map<StateInfo, String> CLIENT_NAMES = new HashMap<StateInfo, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClientName(StateInfo info) {
        Map<StateInfo, String> map = CLIENT_NAMES;
        synchronized (map) {
            return new String(CLIENT_NAMES.getOrDefault(info, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeClient(ReadBuffer buffer) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockPos pos = buffer.getBlockPos();
        int byteLength = buffer.getByteToUnsignedInt();
        if (byteLength == 255) {
            ClientNameHandler.setRemoved(pos);
            return;
        }
        byte[] array = new byte[byteLength];
        for (int i = 0; i < byteLength; ++i) {
            array[i] = buffer.getByte();
        }
        String name = "";
        try {
            name = new String(array, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Map<StateInfo, String> e = CLIENT_NAMES;
        synchronized (e) {
            CLIENT_NAMES.put(new StateInfo((World)mc.field_71441_e, pos), name);
        }
        WorldClient level = mc.field_71441_e;
        if (level == null) {
            return;
        }
        mc.func_152344_a(() -> {
            level.func_175726_f(pos).func_76630_e();
            IBlockState state = level.func_180495_p(pos);
            if (state == null) {
                return;
            }
            mc.field_71438_f.func_174959_b(pos);
            mc.field_71438_f.func_184376_a((World)level, pos, state, state, 8);
            level.func_184138_a(pos, state, state, 3);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRemoved(BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        Map<StateInfo, String> map = CLIENT_NAMES;
        synchronized (map) {
            CLIENT_NAMES.remove(new StateInfo((World)mc.field_71441_e, pos));
        }
    }

    @SubscribeEvent
    public void serverEvent(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.deserializeClient(event.getPacket().payload().nioBuffer());
    }
}

