/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UIToolTip;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.guis.TrainNumberContainer;
import com.troblecodings.signals.signalbox.Point;
import net.minecraft.entity.player.EntityPlayer;

public class TrainNumberGui
extends GuiBase {
    private final TrainNumberContainer container;
    private final EntityPlayer player;

    public TrainNumberGui(GuiInfo info) {
        super(info);
        this.container = (TrainNumberContainer)info.base;
        this.player = info.player;
        this.entity.clear();
        this.entity.add(new UILabel("Not connected"));
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new TrainNumberContainer(info);
    }

    private void initOwn() {
        this.entity.clear();
        this.entity.add(new UIBox(UIBox.VBOX, 5));
        UIEntity inner = new UIEntity();
        inner.setWidth(200.0);
        inner.setInheritHeight(true);
        inner.setX(70.0);
        inner.add(new UIBox(UIBox.VBOX, 5));
        inner.add(GuiElements.createSpacerV(10));
        UIEntity label = GuiElements.createLabel(I18Wrapper.format("tile.trainnumberchanger", new Object[0]), 7764128);
        label.setScaleX(1.5f);
        label.setScaleY(1.5f);
        label.setX(-6.0);
        inner.add(label);
        inner.add(GuiElements.createSpacerV(20));
        UIEntity inputEntity = new UIEntity();
        inputEntity.setHeight(20.0);
        inputEntity.setInheritWidth(true);
        inputEntity.add(new UIBox(UIBox.HBOX, 0));
        UITextInput textInput = new UITextInput(this.container.number.trainNumber);
        textInput.setOnTextUpdate(this::sendNewTrainNumber);
        UIEntity input = new UIEntity();
        input.add(textInput);
        input.setHeight(20.0);
        input.setWidth(150.0);
        inputEntity.add(input);
        inputEntity.add(GuiElements.createSpacerH(5));
        inputEntity.add(GuiElements.createButton(I18Wrapper.format("gui.trainnumber.change_set", new Object[0]), e -> {
            this.setTrainNumber();
            textInput.setText("");
        }));
        inputEntity.add(new UIToolTip(I18Wrapper.format("gui.trainnumber.info.change", new Object[0])));
        inner.add(inputEntity);
        IIntegerable<String> points = DrawUtil.SizeIntegerables.of(I18Wrapper.format("gui.setpoint", new Object[0]), this.container.validPoints.size(), e -> {
            if (e == -1) {
                return "Disabled";
            }
            return this.container.validPoints.get(e).toShortString();
        });
        inner.add(GuiElements.createEnumElement(new DrawUtil.DisableIntegerable<String>(points), e -> {
            if (e == -1) {
                this.container.setPoint = new Point(-1, -1);
                this.sendNewPoint();
                return;
            }
            this.container.setPoint = this.container.validPoints.get(e);
            this.sendNewPoint();
        }, this.container.setPoint != null ? (this.container.setPoint.equals(new Point(-1, -1)) ? -1 : this.container.validPoints.indexOf(this.container.setPoint)) : -1));
        inner.add(GuiElements.createSpacerV(5));
        UILabel linkedlabel = new UILabel("Linked SignalBox: " + (this.container.linkedPos == null ? "Not linked!" : this.container.linkedPos.toString()));
        linkedlabel.setCenterY(false);
        UIEntity posLabel = new UIEntity();
        posLabel.setHeight(20.0);
        posLabel.setInheritWidth(true);
        posLabel.add(linkedlabel);
        inner.add(posLabel);
        this.entity.add(inner);
    }

    @Override
    public void updateFromContainer() {
        this.initOwn();
    }

    private void sendNewPoint() {
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(TrainNumberContainer.TrainNumberNetwork.SEND_NEW_POINT);
        this.container.setPoint.writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendNewTrainNumber(String number) {
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(TrainNumberContainer.TrainNumberNetwork.SEND_NEW_TRAINNUMBER);
        buffer.putString(number);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void setTrainNumber() {
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(TrainNumberContainer.TrainNumberNetwork.SET_TRAINNUMBER);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }
}

