/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.QuaternionWrapper;
import com.troblecodings.guilib.ecs.entitys.UIBlockRender;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.input.UIDrag;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.guilib.ecs.entitys.render.UIScissor;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.enums.ChangeableStage;
import com.troblecodings.signals.guis.GuiSignalBox;
import com.troblecodings.signals.models.ModelInfoWrapper;
import java.util.HashMap;
import java.util.Map;

public class PreviewSideBar {
    public static final float MODIFIER = 0.1f;
    private final UIBlockRender blockRender;
    private final Map<SEProperty, String> properties = new HashMap<SEProperty, String>();
    private final UIEntity blockRenderEntity = new UIEntity();

    public PreviewSideBar(float height) {
        this.blockRender = new UIBlockRender(20.0f, height);
        this.blockRenderEntity.setInheritHeight(true);
        this.blockRenderEntity.setWidth(60.0);
        this.blockRenderEntity.add(new UIDrag((x, y) -> this.blockRender.updateRotation(QuaternionWrapper.fromXYZ(0.0f, (float)x * 0.1f, 0.0f))));
        this.blockRenderEntity.add(new UIScissor());
        this.blockRenderEntity.add(new UIColor(GuiSignalBox.BACKGROUND_COLOR));
        this.blockRenderEntity.add(this.blockRender);
    }

    public UIEntity get() {
        return this.blockRenderEntity;
    }

    public void addToRenderList(SEProperty property, int valueId) {
        if (valueId < 0) {
            this.properties.remove(property);
            return;
        }
        if (property.isChangabelAtStage(ChangeableStage.GUISTAGE)) {
            this.properties.put(property, property.getObjFromID(valueId));
        } else if (property.isChangabelAtStage(ChangeableStage.APISTAGE)) {
            if (valueId > 0) {
                this.properties.put(property, property.getDefault());
            } else {
                this.properties.remove(property);
            }
        } else if (property.isChangabelAtStage(ChangeableStage.APISTAGE_NONE_CONFIG)) {
            this.properties.put(property, property.getDefault());
        }
    }

    public void addToRenderNormal(SEProperty property, int valueId) {
        if (valueId < 0) {
            this.properties.put(property, property.getDefault());
            return;
        }
        this.properties.put(property, property.getObjFromID(valueId));
    }

    public void clear() {
        this.properties.clear();
    }

    public void update(Signal signal) {
        this.blockRender.setBlockState(new ModelInfoWrapper(signal, this.properties));
    }
}

