/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.items.Placementtool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ContainerPlacementtool
extends ContainerBase {
    public static final String SIGNAL_NAME = "signalName";
    protected final Map<SEProperty, Integer> properties = new HashMap<SEProperty, Integer>();
    protected int signalID;
    protected String signalName = "";
    private Signal signal;

    public ContainerPlacementtool(GuiInfo info) {
        super(info);
    }

    @Override
    public void sendAllDataToRemote() {
        this.sendItemProperties(this.info.player);
    }

    private void sendItemProperties(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        Placementtool tool = (Placementtool)stack.func_77973_b();
        NBTWrapper wrapper = NBTWrapper.getOrCreateWrapper(stack);
        int signalID = wrapper.getInteger("blocktypeid");
        this.signal = tool.getObjFromID(signalID);
        List<SEProperty> properites = this.signal.getProperties();
        ArrayList<Byte> propertiesToSend = new ArrayList<Byte>();
        for (int i = 0; i < properites.size(); ++i) {
            SEProperty property = properites.get(i);
            if (!wrapper.contains(property.getName())) continue;
            propertiesToSend.add((byte)i);
            String value = wrapper.getString(property.getName());
            propertiesToSend.add((byte)property.getParent().getIDFromValue(value));
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putInt(signalID);
        buffer.putByte((byte)propertiesToSend.size());
        propertiesToSend.forEach(buffer::putByte);
        String signalName = wrapper.getString(SIGNAL_NAME);
        buffer.putString(signalName);
        OpenSignalsMain.network.sendTo(player, buffer);
    }

    @Override
    public void deserializeServer(ReadBuffer buffer) {
        int first = buffer.getByteToUnsignedInt();
        ItemStack stack = this.info.player.func_184614_ca();
        Placementtool tool = (Placementtool)stack.func_77973_b();
        if (first == 255) {
            int id = buffer.getInt();
            if (id == -1) {
                NBTWrapper wrapper = NBTWrapper.getOrCreateWrapper(stack);
                wrapper.putString(SIGNAL_NAME, buffer.getString());
                return;
            }
            NBTWrapper wrapper = NBTWrapper.createForStack(stack);
            wrapper.putInteger("blocktypeid", id);
            this.signal = tool.getObjFromID(id);
            this.properties.clear();
            this.sendItemProperties(this.info.player);
        } else {
            NBTWrapper wrapper = NBTWrapper.getOrCreateWrapper(stack);
            SEProperty property = this.signal.getProperties().get(first);
            String value = property.getObjFromID(buffer.getByteToUnsignedInt());
            if (property.getDefault().equals(value)) {
                wrapper.remove(property.getName());
                return;
            }
            wrapper.putString(property.getName(), value);
        }
    }

    @Override
    public void deserializeClient(ReadBuffer buffer) {
        this.signalID = buffer.getInt();
        int size = buffer.getByteToUnsignedInt();
        Placementtool tool = (Placementtool)this.info.player.func_184614_ca().func_77973_b();
        Signal signal = tool.getObjFromID(this.signalID);
        List<SEProperty> signalProperties = signal.getProperties();
        this.properties.clear();
        for (int i = 0; i < size / 2; ++i) {
            SEProperty property2 = signalProperties.get(buffer.getByteToUnsignedInt());
            int value = buffer.getByteToUnsignedInt();
            this.properties.put(property2, value);
        }
        this.signalName = buffer.getString();
        signalProperties.forEach(property -> {
            if (!this.properties.containsKey(property)) {
                this.properties.put((SEProperty)property, property.getParent().getIDFromValue(property.getDefault()));
            }
        });
        this.update();
    }
}

