/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.enums;

import com.troblecodings.signals.enums.EnumGuiMode;
import java.util.Arrays;

public enum PathType {
    NORMAL(EnumGuiMode.HP, EnumGuiMode.END, EnumGuiMode.IN_CONNECTION, EnumGuiMode.OUT_CONNECTION),
    SHUNTING(EnumGuiMode.RS, EnumGuiMode.RA10, EnumGuiMode.END),
    NONE(new EnumGuiMode[0]);

    private final EnumGuiMode[] modes;

    private PathType(EnumGuiMode ... modes) {
        this.modes = modes;
    }

    public boolean hasMode(EnumGuiMode mode) {
        return Arrays.stream(this.modes).anyMatch(mode::equals);
    }

    public EnumGuiMode[] getModes() {
        return this.modes;
    }

    public static final PathType of(EnumGuiMode mode) {
        return Arrays.stream(PathType.values()).filter(type -> type.hasMode(mode)).findFirst().orElse(NONE);
    }
}

