/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.enums.ShowSubsidiary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SubsidiaryState {
    public static final List<SubsidiaryState> ALL_STATES = new ArrayList<SubsidiaryState>();
    private transient int id;
    private transient ShowSubsidiary showSubsidiary = ShowSubsidiary.SIGNAL_RED;
    private String name;
    private String showSubsidiaryAtSignal;
    private boolean isCountable = false;
    private static final String STATE_ID = "stateID";

    public SubsidiaryState(String name) {
        this.name = name.toLowerCase();
        this.id = ALL_STATES.size();
        ALL_STATES.add(this);
    }

    public void prepareData() {
        this.name = this.name.toLowerCase();
        this.id = ALL_STATES.size();
        ALL_STATES.add(this);
        if (this.showSubsidiaryAtSignal != null) {
            this.showSubsidiary = Enum.valueOf(ShowSubsidiary.class, this.showSubsidiaryAtSignal.toUpperCase());
        }
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ShowSubsidiary getSubsidiaryShowType() {
        return this.showSubsidiary;
    }

    public boolean isCountable() {
        return this.isCountable;
    }

    public void writeNetwork(WriteBuffer buffer) {
        buffer.putByte((byte)this.id);
    }

    public static SubsidiaryState of(ReadBuffer buffer) {
        return ALL_STATES.get(buffer.getByteToUnsignedInt());
    }

    public void writeNBT(NBTWrapper tag) {
        tag.putInteger(STATE_ID, this.id);
    }

    public static SubsidiaryState of(NBTWrapper tag) {
        return ALL_STATES.get(tag.getInteger(STATE_ID));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubsidiaryState other = (SubsidiaryState)obj;
        return this.id == other.id && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.name;
    }
}

