/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.contentpacks.SoundPropertyParser;
import com.troblecodings.signals.core.SignalProperties;
import com.troblecodings.signals.init.OSItems;
import com.troblecodings.signals.init.OSSounds;
import com.troblecodings.signals.items.Placementtool;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.LogicParser;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.parser.ValuePack;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import com.troblecodings.signals.properties.SoundProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.util.SoundEvent;

public class SignalPropertiesBuilder {
    private transient Placementtool placementtool = null;
    private String placementToolName = null;
    private int defaultHeight = 1;
    private Map<String, Integer> signalHeights;
    private float customNameRenderHeight = -1.0f;
    private Map<String, Float> renderHeights;
    private float signWidth = 22.0f;
    private boolean autoscale = false;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float signScale = 1.0f;
    private Map<String, Boolean> doubleSidedText;
    private int textColor = 0;
    private boolean canLink = true;
    private List<Integer> colors;
    private Map<String, SoundPropertyParser> sounds;
    private Map<String, String> redstoneOutputs;
    private Map<String, String> remoteRedstoneOutputs;
    private int defaultItemDamage = 1;

    public SignalProperties build(FunctionParsingInfo info) {
        if (this.placementToolName != null) {
            for (int i = 0; i < OSItems.placementtools.size(); ++i) {
                Placementtool tool = OSItems.placementtools.get(i);
                if (!tool.getRegistryName().func_110623_a().equalsIgnoreCase(this.placementToolName)) continue;
                this.placementtool = tool;
                break;
            }
        }
        if (this.placementtool == null) {
            throw new ContentPackException("There doesn't exists a placementtool with the name '" + this.placementToolName + "'!");
        }
        ArrayList signalheights = new ArrayList();
        if (this.signalHeights != null) {
            this.signalHeights.forEach((property, height) -> {
                try {
                    signalheights.add(new PredicatedPropertyBase.PredicateProperty<Integer>(LogicParser.predicate(property, info), (Integer)height));
                }
                catch (LogicalParserException e) {
                    OpenSignalsMain.getLogger().error("Something went wrong during the registry of a predicate in " + info.signalName + "!\nWith statement:" + property);
                    e.printStackTrace();
                }
            });
        }
        ArrayList renderheights = new ArrayList();
        if (this.renderHeights != null) {
            this.renderHeights.forEach((property, height) -> {
                try {
                    renderheights.add(new PredicatedPropertyBase.PredicateProperty<Float>(LogicParser.predicate(property, info), (Float)height));
                }
                catch (LogicalParserException e) {
                    OpenSignalsMain.getLogger().error("Something went wrong during the registry of a predicate in " + info.signalName + "!\nWith statement:" + property);
                    e.printStackTrace();
                }
            });
        }
        ArrayList<SoundProperty> soundProperties = new ArrayList<SoundProperty>();
        if (this.sounds != null) {
            for (Map.Entry<String, SoundPropertyParser> soundProperty : this.sounds.entrySet()) {
                SoundPropertyParser soundProp = soundProperty.getValue();
                SoundEvent sound = OSSounds.SOUNDS.get(soundProp.getName().toLowerCase());
                if (sound == null) {
                    OpenSignalsMain.getLogger().error("The sound with the name " + soundProp.getName() + " doesn't exists!");
                    continue;
                }
                try {
                    soundProperties.add(new SoundProperty(sound, LogicParser.predicate(soundProperty.getKey(), info), soundProp.getLength()));
                }
                catch (LogicalParserException e) {
                    OpenSignalsMain.getLogger().error("Something went wrong during the registry of a predicate in " + info.signalName + "!\nWith statement:" + soundProperty.getKey());
                    e.printStackTrace();
                }
            }
        }
        ArrayList redstoneValuePacks = new ArrayList();
        ArrayList remoteRedstoneValuePacks = new ArrayList();
        ImmutableList.of((Object)Maps.immutableEntry(this.redstoneOutputs, redstoneValuePacks), (Object)Maps.immutableEntry(this.remoteRedstoneOutputs, remoteRedstoneValuePacks)).forEach(entry -> {
            if (entry.getKey() != null) {
                ((Map)entry.getKey()).forEach((key, value) -> {
                    Predicate predicate = LogicParser.predicate(key, info);
                    SEProperty property = (SEProperty)info.getProperty((String)value);
                    ((List)entry.getValue()).add(new ValuePack(property, predicate));
                });
            }
        });
        ArrayList doubleText = new ArrayList();
        if (this.doubleSidedText != null) {
            this.doubleSidedText.forEach((property, bool) -> {
                try {
                    doubleText.add(new PredicatedPropertyBase.PredicateProperty<Boolean>(LogicParser.predicate(property, info), (Boolean)bool));
                }
                catch (LogicalParserException e) {
                    OpenSignalsMain.getLogger().error("Something went wrong during the registry of a predicate in " + info.signalName + "!\nWith statement:" + property);
                    e.printStackTrace();
                }
            });
        }
        this.colors = this.colors == null ? new ArrayList() : this.colors;
        return new SignalProperties(this.placementtool, this.customNameRenderHeight, this.defaultHeight, (List<PredicatedPropertyBase.PredicateProperty<Integer>>)ImmutableList.copyOf(signalheights), this.signWidth, this.offsetX, this.offsetY, this.signScale, this.autoscale, (List<PredicatedPropertyBase.PredicateProperty<Boolean>>)ImmutableList.copyOf(doubleText), this.textColor, this.canLink, this.colors, (List<PredicatedPropertyBase.PredicateProperty<Float>>)ImmutableList.copyOf(renderheights), (List<SoundProperty>)ImmutableList.copyOf(soundProperties), (List<ValuePack>)ImmutableList.copyOf(redstoneValuePacks), this.defaultItemDamage, (List<ValuePack>)ImmutableList.copyOf(remoteRedstoneValuePacks));
    }
}

