/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.contentpacks;

import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.core.JsonEnum;
import com.troblecodings.signals.core.JsonEnumHolder;
import com.troblecodings.signals.enums.ChangeableStage;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.LogicParser;
import java.util.Map;
import java.util.function.Predicate;

public class SEPropertyParser {
    private String name;
    private String enumClass;
    private Object defaultState;
    private String changeableStage;
    private boolean autoname = false;
    private String dependencies;
    private int itemDamage = 1;
    private transient JsonEnum parent;

    public SEProperty createSEProperty(FunctionParsingInfo info) {
        if (this.defaultState instanceof Boolean) {
            this.parent = JsonEnum.BOOLEAN;
            this.enumClass = JsonEnum.BOOLEAN.getName();
            this.defaultState = String.valueOf(this.defaultState);
        } else {
            this.parent = JsonEnumHolder.PROPERTIES.get(this.enumClass.toLowerCase());
        }
        if (this.parent == null) {
            throw new ContentPackException(String.format("Property[%s], with class %s not found!", this.name, this.enumClass.toLowerCase()) + " Valid EnumClasses: " + JsonEnumHolder.PROPERTIES.keySet());
        }
        ChangeableStage stage = ChangeableStage.APISTAGE;
        if (this.changeableStage != null && !this.changeableStage.isEmpty()) {
            stage = Enum.valueOf(ChangeableStage.class, this.changeableStage);
        }
        Predicate<Map<SEProperty, String>> predicate = t -> true;
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            predicate = LogicParser.predicate(this.dependencies, info);
        }
        if (this.autoname) {
            return new SEProperty.SEAutoNameProp(this.name, this.parent, (String)this.defaultState, stage, predicate, this.itemDamage);
        }
        return new SEProperty(this.name, this.parent, (String)this.defaultState, stage, predicate, this.itemDamage);
    }
}

