/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.contentpacks;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.contentpacks.OneSignalPredicateConfigParser;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OneSignalNonPredicateConfigParser {
    private String currentSignal;
    private List<String> values;
    public static final Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> SHUNTINGCONFIGS = new HashMap<Signal, List<PredicatedPropertyBase.ConfigProperty>>();
    public static final Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> RESETCONFIGS = new HashMap<Signal, List<PredicatedPropertyBase.ConfigProperty>>();
    private static final Gson GSON = new Gson();

    public static void loadOneSignalConfigs() {
        OneSignalNonPredicateConfigParser.loadResetConfigs();
        OneSignalNonPredicateConfigParser.loadOneSignalNonPredicateConfig(SHUNTINGCONFIGS, "signalconfigs/shunting");
    }

    private static void loadResetConfigs() {
        List<Map.Entry<String, String>> list = OpenSignalsMain.contentPacks.getFiles("signalconfigs/reset");
        list.forEach(entry -> {
            try {
                OneSignalPredicateConfigParser.loadOneSignalPredicateConfigs(RESETCONFIGS, entry);
            }
            catch (Exception e) {
                OpenSignalsMain.getLogger().error("Reset Config '" + (String)entry.getKey() + "' is still in old ResetConfig system. Please update with Predicate system!");
                OneSignalNonPredicateConfigParser.loadOneSignalNonPredicateConfig(RESETCONFIGS, entry);
            }
        });
    }

    public static void loadOneSignalNonPredicateConfig(Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> map, String internal) {
        List<Map.Entry<String, String>> list = OpenSignalsMain.contentPacks.getFiles(internal);
        list.forEach(entry -> OneSignalNonPredicateConfigParser.loadOneSignalNonPredicateConfig(map, entry));
    }

    public static void loadOneSignalNonPredicateConfig(Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> map, Map.Entry<String, String> files) {
        OneSignalNonPredicateConfigParser parser = (OneSignalNonPredicateConfigParser)GSON.fromJson(files.getValue(), OneSignalNonPredicateConfigParser.class);
        Signal signal = OneSignalNonPredicateConfigParser.checkSignal(parser.currentSignal, files.getKey());
        if (signal == null) {
            return;
        }
        if (map.containsKey((Object)signal)) {
            throw new LogicalParserException("A signalconfig with the signals [" + signal.getSignalTypeName() + "] does alredy exists! '" + files.getKey() + "' tried to register the same signalconfig!");
        }
        FunctionParsingInfo info = new FunctionParsingInfo(signal);
        ArrayList<PredicatedPropertyBase.ConfigProperty> propertes = new ArrayList<PredicatedPropertyBase.ConfigProperty>();
        for (String property : parser.values) {
            String[] value = property.split("\\.");
            propertes.add(new PredicatedPropertyBase.ConfigProperty(t -> true, (Map<SEProperty, String>)ImmutableMap.of((Object)((SEProperty)info.getProperty(value[0])), (Object)value[1])));
        }
        map.put(signal, propertes);
    }

    private static Signal checkSignal(String signalName, String filename) {
        Signal signal = Signal.SIGNALS.get(signalName.toLowerCase());
        if (signal == null) {
            throw new ContentPackException("The signal '" + signalName + "' doesn't exists! Please check " + filename + " where to problem is! Valid Signals: " + Signal.SIGNALS.keySet());
        }
        return signal;
    }
}

