/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals;

import com.troblecodings.contentpacklib.ContentPackHandler;
import com.troblecodings.core.net.NetworkHandler;
import com.troblecodings.guilib.ecs.GuiHandler;
import com.troblecodings.signals.handler.NameHandler;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.init.OSBlocks;
import com.troblecodings.signals.init.OSItems;
import com.troblecodings.signals.init.OSSounds;
import com.troblecodings.signals.proxy.CommonProxy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

@Mod(modid="opensignals", acceptedMinecraftVersions="[1.12.2]")
public class OpenSignalsMain {
    @Mod.Instance
    private static OpenSignalsMain instance;
    public static final String MODID = "opensignals";
    @SidedProxy(serverSide="com.troblecodings.signals.proxy.CommonProxy", clientSide="com.troblecodings.signals.proxy.ClientProxy")
    public static CommonProxy proxy;
    private static Logger log;
    public static GuiHandler handler;
    public static NetworkHandler network;
    public static ContentPackHandler contentPacks;
    private static boolean debug;
    private static FileSystem fileSystemCache;

    public static OpenSignalsMain getInstance() {
        return instance;
    }

    public OpenSignalsMain() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(OSBlocks.class);
        MinecraftForge.EVENT_BUS.register(OSItems.class);
        MinecraftForge.EVENT_BUS.register(OSSounds.class);
        MinecraftForge.EVENT_BUS.register(NameHandler.class);
        MinecraftForge.EVENT_BUS.register(SignalStateHandler.class);
        MinecraftForge.EVENT_BUS.register(SignalBoxHandler.class);
        debug = true;
        log = LoggerContext.getContext().getLogger(MODID);
        contentPacks = new ContentPackHandler(MODID, "assets/opensignals", log, name -> {
            Optional<Path> path = OpenSignalsMain.getRessourceLocation(name);
            if (path.isPresent()) {
                return path.get().toAbsolutePath();
            }
            return Paths.get("", new String[0]);
        });
    }

    public static boolean isDebug() {
        return debug;
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppingEvent event) {
        SignalStateHandler.onServerStop(event);
        NameHandler.onServerStop(event);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        debug = Files.isDirectory(event.getSourceFile().toPath(), new LinkOption[0]);
        log = event.getModLog();
        proxy.initModEvent(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    public static Logger getLogger() {
        if (log == null) {
            log = LogManager.getLogger((String)MODID);
        }
        return log;
    }

    private static Optional<Path> getRessourceLocation(String location) {
        String filelocation = location;
        URL url = OSBlocks.class.getResource("/assets/opensignals");
        try {
            if (url != null) {
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    URL resource;
                    if (!location.startsWith("/")) {
                        filelocation = "/" + filelocation;
                    }
                    if ((resource = OSBlocks.class.getResource(filelocation)) == null) {
                        return Optional.empty();
                    }
                    return Optional.of(Paths.get(resource.toURI()));
                }
                if (!"jar".equals(uri.getScheme())) {
                    return Optional.empty();
                }
                if (fileSystemCache == null) {
                    fileSystemCache = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                return Optional.of(fileSystemCache.getPath(filelocation, new String[0]));
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    static {
        log = null;
        handler = null;
        network = null;
        contentPacks = null;
    }
}

