/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.linkableapi;

import com.google.common.base.Predicate;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.linkableapi.TaggableFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiLinkingTool
extends Item {
    private static final String LINKED_BLOCKS = "linkedBlocks";
    private final BiPredicate<World, BlockPos> predicate;
    private final Predicate<TileEntity> predicateSet;
    private final TaggableFunction tagFromFunction;

    public MultiLinkingTool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate) {
        this(tab, predicate, (Predicate<TileEntity>)((Predicate)_u -> true));
    }

    public MultiLinkingTool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate, Predicate<TileEntity> predicateSet, TaggableFunction function) {
        this.func_77637_a(tab);
        this.setNoRepair();
        this.func_77656_e(64);
        this.func_77625_d(1);
        this.predicate = predicate;
        this.predicateSet = predicateSet;
        this.tagFromFunction = function;
    }

    public MultiLinkingTool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate, Predicate<TileEntity> predicateSet) {
        this(tab, predicate, predicateSet, (_u1, _u2, _u3) -> {});
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World levelIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null) {
            return EnumActionResult.FAIL;
        }
        if (levelIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity entity = levelIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (entity instanceof ILinkableTile && this.predicateSet.apply((Object)entity)) {
            ILinkableTile controller = (ILinkableTile)entity;
            if (!player.func_70093_af()) {
                NBTTagCompound comp = stack.func_77978_p();
                if (comp == null) {
                    this.message(player, "lt.notset", pos.toString());
                    return EnumActionResult.PASS;
                }
                NBTTagList list = (NBTTagList)comp.func_74781_a(LINKED_BLOCKS);
                if (list == null) {
                    this.message(player, "lt.notlinked", new Object[0]);
                    return EnumActionResult.FAIL;
                }
                list.forEach(tag -> {
                    if (controller.link(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)tag)), comp)) {
                        this.message(player, "lt.linkedpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                });
                stack.func_77982_d(null);
                this.message(player, "lt.reset", new Object[0]);
                return EnumActionResult.FAIL;
            }
            if (controller.canBeLinked() && this.predicate.test(levelIn, pos)) {
                NBTTagList list;
                NBTTagCompound tag2 = stack.func_77978_p();
                if (tag2 == null) {
                    tag2 = new NBTTagCompound();
                }
                if ((list = (NBTTagList)tag2.func_74781_a(LINKED_BLOCKS)) == null) {
                    list = new NBTTagList();
                }
                list.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
                tag2.func_74782_a(LINKED_BLOCKS, (NBTBase)list);
                this.tagFromFunction.test(levelIn, pos, tag2);
                stack.func_77982_d(tag2);
                this.message(player, "lt.setpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.message(player, "lt.setpos.msg", new Object[0]);
                return EnumActionResult.SUCCESS;
            }
            if (controller.hasLink() && controller.unlink()) {
                this.message(player, "lt.unlink", new Object[0]);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.predicate.test(levelIn, pos)) {
            NBTTagList list;
            NBTTagCompound tag3 = stack.func_77978_p();
            if (tag3 == null) {
                tag3 = new NBTTagCompound();
            }
            if ((list = (NBTTagList)tag3.func_74781_a(LINKED_BLOCKS)) == null) {
                list = new NBTTagList();
            }
            list.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            tag3.func_74782_a(LINKED_BLOCKS, (NBTBase)list);
            this.tagFromFunction.test(levelIn, pos, tag3);
            stack.func_77982_d(tag3);
            this.message(player, "lt.setpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.message(player, "lt.setpos.msg", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af() && stack.func_77978_p() != null) {
            stack.func_77982_d(null);
            this.message(player, "lt.reset", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World levelIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagList list;
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && (list = (NBTTagList)itemTag.func_74781_a(LINKED_BLOCKS)) != null) {
            ArrayList linkedPos = new ArrayList();
            list.forEach(tag -> linkedPos.add(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)tag))));
            tooltip.add(((Object)linkedPos).toString());
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"lt.notlinked", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"lt.notlinked.msg", (Object[])new Object[0]));
    }

    public void message(EntityPlayer player, String text, Object ... obj) {
        player.func_145747_a((ITextComponent)this.getComponent(text, obj));
    }

    public TextComponentTranslation getComponent(String text, Object ... obj) {
        return new TextComponentTranslation(text, obj);
    }
}

