/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.render;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import java.util.Arrays;

public class UILines
extends UIComponent {
    private final float[] lines;
    private final float[] lineCache;
    private final float width;
    private int color;
    private double oldWidth = -1.0;
    private double oldHeight = -1.0;

    public UILines(float[] lines, float width) {
        this.lines = Arrays.copyOf(lines, lines.length);
        this.lineCache = new float[lines.length];
        this.width = width;
        this.color = -16777216;
    }

    @Override
    public void draw(DrawInfo info) {
        info.depthOn();
        info.disableTexture();
        info.lines(this.color, this.width, this.lineCache);
        info.depthOff();
    }

    @Override
    public void update() {
        if (this.oldWidth != this.parent.getWidth() || this.oldHeight != this.parent.getHeight()) {
            this.oldWidth = this.parent.getWidth();
            this.oldHeight = this.parent.getHeight();
            for (int i = 0; i < this.lines.length; i += 2) {
                this.lineCache[i] = this.lines[i] * (float)this.oldWidth;
                this.lineCache[i + 1] = this.lines[i + 1] * (float)this.oldHeight;
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

