/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.input;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UIScrollBox;
import com.troblecodings.guilib.ecs.entitys.input.UIScroll;
import com.troblecodings.guilib.ecs.interfaces.IBoxMode;
import java.util.function.DoubleConsumer;

public class UIScrollBar
extends UIComponent {
    private final UIScrollBox box;
    private final int inset;
    private final DoubleConsumer consumer;
    private double internalValue;
    private boolean wasClicked = false;
    private final UIScroll scroll;

    public UIScrollBar(UIScrollBox box, int inset, DoubleConsumer consumer, UIScroll scroll) {
        this.box = box;
        this.inset = inset;
        this.consumer = consumer;
        this.scroll = scroll;
        this.scroll.consumer = this::onScroll;
        this.internalValue = 0.0;
    }

    private void onScroll(double in) {
        this.internalValue = this.clamp(this.internalValue - in * 0.001);
        this.consumer.accept(this.internalValue);
    }

    private double clamp(double in) {
        return Math.min(1.0, Math.max(0.0, in));
    }

    private void updateValue(double data) {
        IBoxMode mode = this.box.getMode();
        double pos = data - mode.getWorldPos(this.parent);
        double localValue = pos / (double)(mode.getBounds(this.parent) - this.inset);
        this.internalValue = this.clamp(localValue);
        this.consumer.accept(this.internalValue);
    }

    public double value() {
        return this.internalValue;
    }

    @Override
    public void mouseEvent(UIEntity.MouseEvent event) {
        if (this.parent.isHovered() && event.state.equals((Object)UIEntity.EnumMouseState.CLICKED)) {
            this.wasClicked = true;
        }
        if (event.state.equals((Object)UIEntity.EnumMouseState.RELEASE)) {
            this.wasClicked = false;
        }
        if (this.wasClicked) {
            this.updateValue(this.box.getMode().choose(event.x, event.y));
        }
    }

    @Override
    public void draw(DrawInfo info) {
    }

    @Override
    public void update() {
    }
}

