/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.google.common.collect.Lists;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class UIEntity
extends UIComponent
implements Iterable<UIEntity> {
    private double x;
    private double y;
    private double worldY;
    private double worldX;
    private double minWidth;
    private double minHeight;
    private double width;
    private double height;
    private double worldWidth;
    private double worldHeight;
    private float scaleX;
    private float scaleY;
    private float worldScaleX;
    private float worldScaleY;
    private boolean hovered;
    private boolean inheritHeight;
    private boolean inheritWidth;
    private UpdateEvent lastUpdateEvent;
    private boolean enableHovering;
    private boolean layoutable;
    protected ArrayList<UIEntity> children = new ArrayList();
    protected ArrayList<UIComponent> components = new ArrayList();

    public UIEntity() {
        this.setVisible(true);
        this.setInheritHeight(false);
        this.setInheritWidth(false);
        this.enableHovering = true;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.layoutable = true;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getLevelY() {
        return this.worldY;
    }

    public double getLevelX() {
        return this.worldX;
    }

    @Override
    public synchronized void postDraw(DrawInfo info) {
        if (this.isVisible()) {
            this.children.forEach((? super E c) -> c.postDraw(info));
            this.components.forEach((? super E c) -> c.postDraw(info));
        }
    }

    @Override
    public synchronized void update() {
        if (this.lastUpdateEvent != null) {
            this.updateWorld();
            Lists.newArrayList(this.components).forEach((? super E c) -> c.update());
            Lists.newArrayList(this.children).forEach((? super E c) -> c.update());
        }
    }

    public synchronized void updateWorld() {
        double cX = this.x * (double)this.lastUpdateEvent.guiScale;
        double cY = this.y * (double)this.lastUpdateEvent.guiScale;
        if (this.parent != null) {
            this.worldScaleX = this.scaleX * this.parent.getLevelScaleX();
            this.worldScaleY = this.scaleY * this.parent.getLevelScaleY();
            this.worldX = (int)(cX * (double)this.parent.worldScaleX + this.parent.getLevelX());
            this.worldY = (int)(cY * (double)this.parent.worldScaleY + this.parent.getLevelY());
        } else {
            this.worldScaleX = this.scaleX;
            this.worldScaleY = this.scaleY;
            this.worldX = (int)(cX * (double)this.scaleX);
            this.worldY = (int)(cY * (double)this.scaleY);
        }
        this.worldWidth = (int)((double)this.worldScaleX * this.width);
        this.worldHeight = (int)((double)this.worldScaleY * this.height);
    }

    @Override
    public synchronized void draw(DrawInfo info) {
        if (this.isVisible()) {
            double wX = this.getLevelX();
            double wY = this.getLevelY();
            if (this.enableHovering) {
                this.hovered = (double)info.mouseX >= wX && (double)info.mouseY >= wY && (double)info.mouseX < wX + this.worldWidth && (double)info.mouseY < wY + this.worldHeight;
            }
            GlStateManager.func_179094_E();
            info.translate(this.x, this.y, 0.0);
            info.scale(this.scaleX, this.scaleY, 1.0);
            this.components.forEach((? super E c) -> c.draw(info));
            this.children.forEach((? super E c) -> c.draw(info));
            this.children.forEach((? super E c) -> c.exitDraw(info));
            this.components.forEach((? super E c) -> c.exitDraw(info));
            GlStateManager.func_179121_F();
        }
    }

    public synchronized void add(UIComponent component) {
        if (!this.components.contains(component)) {
            this.components.add(component);
            component.onAdd(this);
            if (this.lastUpdateEvent != null) {
                this.updateEvent(this.lastUpdateEvent);
            }
        }
    }

    public synchronized void remove(UIComponent component) {
        if (this.components.contains(component)) {
            this.components.remove(component);
            component.onRemove(this);
            this.update();
        }
    }

    public synchronized void add(UIEntity component) {
        if (!this.children.contains(component) && component != this) {
            this.children.add(component);
            component.onAdd(this);
            if (this.lastUpdateEvent != null) {
                this.updateEvent(this.lastUpdateEvent);
            }
        }
    }

    public synchronized void remove(UIEntity component) {
        if (this.children.contains(component)) {
            this.children.remove(component);
            component.onRemove(this);
            this.update();
        }
    }

    @Override
    public synchronized void onClosed() {
        this.children.forEach((? super E c) -> c.onClosed());
    }

    @Override
    public synchronized void mouseEvent(MouseEvent event) {
        if (this.isVisible()) {
            ((Iterable)this.components.clone()).forEach(c -> c.mouseEvent(event));
            ((Iterable)this.children.clone()).forEach(c -> c.mouseEvent(event));
        }
    }

    @Override
    public synchronized void keyEvent(KeyEvent event) {
        if (this.isVisible()) {
            this.children.forEach((? super E c) -> c.keyEvent(event));
            this.components.forEach((? super E c) -> c.keyEvent(event));
        }
    }

    @Override
    public synchronized void updateEvent(UpdateEvent event) {
        this.lastUpdateEvent = event;
        Lists.newArrayList(this.children).forEach((? super E c) -> c.updateEvent(event));
        Lists.newArrayList(this.components).forEach((? super E c) -> c.updateEvent(event));
        this.update();
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearChildren() {
        UIEntity uIEntity = this;
        synchronized (uIEntity) {
            this.children.forEach((? super E entity) -> entity.onRemove(this));
            this.children.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearComponents() {
        UIEntity uIEntity = this;
        synchronized (uIEntity) {
            this.components.forEach((? super E entity) -> entity.onRemove(this));
            this.components.clear();
        }
    }

    public synchronized void clear() {
        this.clearComponents();
        this.clearChildren();
    }

    public synchronized <T extends UIComponent> List<T> findRecursive(Class<T> c) {
        return this.findRecursive(this, c);
    }

    public synchronized <T extends UIComponent> List<T> findRecursive(UIEntity uiEntity, Class<T> c) {
        ArrayList components = new ArrayList();
        uiEntity.components.stream().filter(u -> u.getClass().equals(c)).forEach(f -> components.add(f));
        for (UIEntity nextEntity : uiEntity.children) {
            components.addAll(this.findRecursive(nextEntity, c));
        }
        return components;
    }

    public boolean inheritHeight() {
        return this.inheritHeight;
    }

    public void setInheritHeight(boolean inheritHeight) {
        this.inheritHeight = inheritHeight;
    }

    public boolean inheritWidth() {
        return this.inheritWidth;
    }

    public void setInheritWidth(boolean inheritWidth) {
        this.inheritWidth = inheritWidth;
    }

    public void setInherits(boolean inherit) {
        this.inheritHeight = inherit;
        this.inheritWidth = inherit;
    }

    public UpdateEvent getLastUpdateEvent() {
        return this.lastUpdateEvent;
    }

    @Override
    public Iterator<UIEntity> iterator() {
        return this.children.iterator();
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public float getLevelScaleX() {
        return this.worldScaleX;
    }

    public float getLevelScaleY() {
        return this.worldScaleY;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(double minWidth) {
        this.minWidth = minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(double minHeight) {
        this.minHeight = minHeight;
    }

    public boolean isLayoutable() {
        return this.layoutable;
    }

    public void setLayoutable(boolean layoutable) {
        this.layoutable = layoutable;
    }

    public boolean isHoveringEnabled() {
        return this.enableHovering;
    }

    public void setHoveringEnabled(boolean enableHovering) {
        if (!enableHovering) {
            this.hovered = false;
        }
        this.enableHovering = enableHovering;
        this.children.forEach((? super E entity) -> entity.setHoveringEnabled(enableHovering));
    }

    public double getWorldY() {
        return this.worldY;
    }

    public double getWorldX() {
        return this.worldX;
    }

    public static final class MouseEvent {
        public final double x;
        public final double y;
        public final int key;
        public final EnumMouseState state;
        public final int inputLayer;

        public MouseEvent(double x, double y, int key, EnumMouseState enumState) {
            this(x, y, key, enumState, 0);
        }

        public MouseEvent(double x, double y, int key, EnumMouseState enumState, int inputLayer) {
            this.x = x;
            this.y = y;
            this.key = key;
            this.state = enumState;
            this.inputLayer = inputLayer;
        }

        public MouseEvent promote(int value) {
            return new MouseEvent(this.x, this.y, this.key, this.state, this.inputLayer + value);
        }
    }

    public static final class KeyEvent {
        public final int typedChar;
        public final int keyCode;

        public KeyEvent(int typedChar, int keyCode) {
            this.typedChar = typedChar;
            this.keyCode = keyCode;
        }
    }

    public static final class UpdateEvent {
        public final int width;
        public final int height;
        public final double scaleFactor;
        public final int guiScale;
        public final GuiBase base;

        public UpdateEvent(int width, int height, double scaleFactor, int guiScale, GuiBase base) {
            this.width = width;
            this.height = height;
            this.scaleFactor = scaleFactor;
            this.guiScale = guiScale;
            this.base = base;
        }
    }

    public static enum EnumMouseState {
        CLICKED,
        RELEASE,
        MOVE,
        SCROLL;

    }
}

