/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.troblecodings.core.QuaternionWrapper;
import com.troblecodings.core.interfaces.BlockModelDataWrapper;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Quaternion;

public class UIBlockRender
extends UIComponent {
    private final BufferBuilder buffer = new BufferBuilder(500);
    private final float scale;
    private final float height;
    private final Quaternion quaternion = QuaternionWrapper.fromXYZ(0.0f, (float)Math.PI, 0.0f);

    public UIBlockRender(float scale, float height) {
        this.scale = scale;
        this.height = height;
    }

    @Override
    public void draw(DrawInfo info) {
        info.applyTexture(TextureMap.field_110575_b);
        GlStateManager.func_179091_B();
        info.depthOn();
        info.alphaOn();
        info.scale(this.scale, -this.scale, this.scale);
        info.translate(1.5, 0.0, 1.5);
        info.rotate(this.quaternion);
        info.translate(-0.5, this.height, -0.5);
        info.drawBuffer(this.buffer);
        info.alphaOff();
        info.depthOff();
        GlStateManager.func_179101_C();
    }

    public void updateRotation(Quaternion quaternion) {
        Quaternion.mul((Quaternion)this.quaternion, (Quaternion)quaternion, (Quaternion)this.quaternion);
    }

    @Override
    public void update() {
    }

    public void setBlockState(BlockModelDataWrapper wrapper) {
        this.setBlockState(wrapper, 0.0, 0.0, 0.0);
    }

    public void setBlockState(BlockModelDataWrapper wrapper, double x, double y, double z) {
        IBlockState ebs = wrapper.getBlockState();
        assert (ebs != null);
        IBlockState cleanState = ebs instanceof IExtendedBlockState ? ((IExtendedBlockState)ebs).getClean() : ebs;
        BlockModelShapes shapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        IBakedModel mdl = shapes.func_178125_b(cleanState);
        this.buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.buffer.func_178969_c(x, y, z);
        ArrayList lst = new ArrayList();
        lst.addAll(mdl.func_188616_a(ebs, null, 0L));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            lst.addAll(mdl.func_188616_a(ebs, face, 0L));
        }
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (BakedQuad quad : lst) {
            int k = quad.func_178212_b() ? blockColors.func_186724_a(cleanState, null, null, quad.func_178211_c()) + -16777216 : -1;
            LightUtil.renderQuadColor((BufferBuilder)this.buffer, (BakedQuad)quad, (int)k);
        }
        this.buffer.func_178977_d();
    }
}

