/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs;

import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.BufferWrapper;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import java.io.IOException;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBase
extends GuiScreen {
    private static final int GUI_MIN_WIDTH = 350;
    private static final int GUI_MAX_HEIGHT = 300;
    private static final int GUI_INSET = 4;
    public static final ResourceLocation CREATIVE_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    protected int guiLeft;
    protected int guiTop;
    protected int xSize = 340;
    protected int ySize = 230;
    protected Stack<UIEntity> entityStack = new Stack();
    protected UIEntity entity;
    private int lastButton = -1;

    public GuiBase(GuiInfo info) {
        info.base = this.getNewGuiContainer(info);
        this.entityStack.add(new UIEntity());
        this.entity = (UIEntity)this.entityStack.lastElement();
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146297_k.field_71439_g.field_71070_bA = info.base;
    }

    public abstract ContainerBase getNewGuiContainer(GuiInfo var1);

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.field_146297_k = mc;
        this.field_146294_l = width;
        this.field_146295_m = height;
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre((GuiScreen)this, this.field_146292_n))) {
            this.func_73866_w_();
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post((GuiScreen)this, this.field_146292_n));
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawBack(DrawInfo info, int xLeft, int xRight, int yTop, int yBottom) {
        info.applyTexture(CREATIVE_TAB);
        info.color();
        info.blendOn();
        info.depthOn();
        BufferWrapper builder = info.builder(7, DefaultVertexFormats.field_181707_g);
        int inset = 8;
        int topOffset = 32;
        int leftOffset = 20;
        int bottomOffset = 120;
        builder.quadNonNormalized(xLeft, xLeft + 8, yTop, yTop + 8, 0, 8, 32, 40);
        builder.quadNonNormalized(xLeft, xLeft + 8, yBottom - 8, yBottom, 0, 8, 120, 128);
        builder.quadNonNormalized(xRight - 8, xRight, yTop, yTop + 8, 20, 28, 32, 40);
        builder.quadNonNormalized(xRight - 8, xRight, yBottom - 8, yBottom, 20, 28, 120, 128);
        builder.quadNonNormalized(xLeft, xLeft + 8, yTop + 8, yBottom - 8, 0, 8, 40, 41);
        builder.quadNonNormalized(xRight - 8, xRight, yTop + 8, yBottom - 8, 20, 28, 40, 41);
        builder.quadNonNormalized(xLeft + 8, xRight - 8, yTop, yTop + 8, 8, 9, 32, 40);
        builder.quadNonNormalized(xLeft + 8, xRight - 8, yBottom - 8, yBottom, 8, 9, 120, 128);
        builder.quadNonNormalized(xLeft + 8, xRight - 8, yTop + 8, yBottom - 8, 8, 9, 41, 42);
        info.end();
        info.depthOff();
        info.blendOff();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        DrawInfo info = new DrawInfo(mouseX, mouseY, partialTicks);
        this.drawBack(info, this.guiLeft, this.guiLeft + this.xSize, this.guiTop, this.guiTop + this.ySize);
        this.entityStack.forEach(entity -> entity.draw(info));
        ((UIEntity)this.entityStack.lastElement()).postDraw(info);
    }

    public void updateFromContainer() {
    }

    public void preClose() {
    }

    private void updateSingle(UIEntity entity) {
        entity.setWidth(350.0);
        entity.setHeight(this.ySize - 4);
        entity.setX(this.guiLeft + 4);
        entity.setY(this.guiTop + 4);
        ScaledResolution rs = new ScaledResolution(this.field_146297_k);
        entity.updateEvent(new UIEntity.UpdateEvent(this.field_146294_l, this.field_146295_m, rs.func_78325_e(), 1, this));
    }

    public void push(UIEntity entity) {
        ((UIEntity)this.entityStack.lastElement()).setHoveringEnabled(false);
        entity.setHoveringEnabled(true);
        this.entityStack.push(entity);
        this.updateSingle(entity);
    }

    public UIEntity pop() {
        UIEntity old = this.entityStack.pop();
        ((UIEntity)this.entityStack.lastElement()).setHoveringEnabled(true);
        return old;
    }

    public void func_73866_w_() {
        this.ySize = Math.min(300, this.field_146295_m - 16);
        this.xSize = 354;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.entityStack.forEach(this::updateSingle);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.preClose();
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        ((UIEntity)this.entityStack.lastElement()).keyEvent(new UIEntity.KeyEvent(typedChar, keyCode));
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.lastButton = mouseButton;
        ((UIEntity)this.entityStack.lastElement()).mouseEvent(new UIEntity.MouseEvent(mouseX, mouseY, mouseButton, UIEntity.EnumMouseState.CLICKED));
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        ((UIEntity)this.entityStack.lastElement()).mouseEvent(new UIEntity.MouseEvent(mouseX, mouseY, this.lastButton, UIEntity.EnumMouseState.RELEASE));
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        ((UIEntity)this.entityStack.lastElement()).mouseEvent(new UIEntity.MouseEvent(mouseX, mouseY, clickedMouseButton, UIEntity.EnumMouseState.CLICKED));
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getDWheel();
        if (scroll != 0) {
            ((UIEntity)this.entityStack.lastElement()).mouseEvent(new UIEntity.MouseEvent(scroll, scroll, -1, UIEntity.EnumMouseState.SCROLL));
        }
    }
}

