/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.contentpacklib;

import com.troblecodings.contentpacklib.ContentPackHandler;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class NetworkContentPackHandler {
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CPHandlerNet");
    private final String channelName = "CPHandlerNet";
    private final ContentPackHandler handler;

    public NetworkContentPackHandler(String modid, ContentPackHandler handler) {
        this.handler = handler;
        this.channel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverEvent(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBuffer buffer = event.getPacket().payload().nioBuffer();
        long serverHash = buffer.getLong();
        if (serverHash != this.handler.getHash()) {
            throw new IllegalArgumentException("Server and Client Hash are not equal! Please check that you have got the same ContentPacks on Client and Server! Server Hash: [" + serverHash + "], Client Hash: [" + this.handler.getHash() + "]");
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(this.handler.getHash());
        this.sendTo(event.player, buffer);
    }

    private void sendTo(EntityPlayer player, ByteBuffer buf) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((ByteBuffer)((ByteBuffer)buf.position(0))));
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP server = (EntityPlayerMP)player;
            this.channel.sendTo(new FMLProxyPacket(buffer, "CPHandlerNet"), server);
        } else {
            this.channel.sendToServer(new FMLProxyPacket(new CPacketCustomPayload("CPHandlerNet", buffer)));
        }
    }
}

