/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.contentpacklib;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.troblecodings.contentpacklib.NetworkContentPackHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Logger;

public class ContentPackHandler {
    private final String modid;
    private final String internalBaseFolder;
    private final Logger logger;
    private final Function<String, Path> function;
    private final Gson gson;
    private final Path contentDirectory;
    private final List<Path> paths = new ArrayList<Path>();
    private final long hash;

    public ContentPackHandler(String modid, String internalBaseFolder, Logger logger, Function<String, Path> function) {
        this.modid = modid;
        this.internalBaseFolder = internalBaseFolder;
        this.logger = logger;
        this.function = function;
        this.gson = new Gson();
        this.contentDirectory = Paths.get("./contentpacks", modid);
        try {
            Files.createDirectories(this.contentDirectory, new FileAttribute[0]);
            Files.list(this.contentDirectory).filter(path -> path.toString().endsWith(".zip")).forEach(path -> {
                try {
                    this.paths.add(FileSystems.newFileSystem(path, ClassLoader.getSystemClassLoader()).getRootDirectories().iterator().next());
                }
                catch (IOException e) {
                    logger.error(String.format("Could not load %s!", path.toString()), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(this.paths, (path1, path2) -> path1.compareTo((Path)path2));
        AtomicLong counter = new AtomicLong(0L);
        try {
            Files.list(this.contentDirectory).filter(path -> path.toString().endsWith(".zip")).forEach(path -> {
                try {
                    ZipInputStream stream = new ZipInputStream(new FileInputStream(path.toFile()));
                    ZipEntry entry = stream.getNextEntry();
                    while (entry != null) {
                        ZipEntry currentEntry = entry;
                        counter.getAndUpdate(current -> current ^ currentEntry.getCrc());
                        entry = stream.getNextEntry();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hash = counter.get();
        new NetworkContentPackHandler(modid, this);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            ArrayList packs = new ArrayList();
            ResourcePackRepository packRepo = Minecraft.func_71410_x().func_110438_M();
            try {
                Files.list(this.contentDirectory).forEach(path -> {
                    packRepo.func_177319_a(path.toFile());
                    packs.add(packRepo.func_188565_b());
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            packRepo.func_148527_a(packs);
            packRepo.func_148529_f();
        }
    }

    public long getHash() {
        return this.hash;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    private String fromInternal(String internal) {
        return this.internalBaseFolder + "/" + internal;
    }

    public List<Map.Entry<String, String>> getFiles(String internal, List<Path> paths) {
        ArrayList<Path> internalPaths = new ArrayList<Path>();
        internalPaths.add(this.function.apply(this.fromInternal(internal)));
        internalPaths.addAll(paths);
        return this.getFiles(internalPaths);
    }

    public List<Map.Entry<String, String>> getFiles(List<Path> paths) {
        ArrayList<Map.Entry<String, String>> files = new ArrayList<Map.Entry<String, String>>();
        paths.forEach(path -> {
            try {
                if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                Stream<Path> inputs = Files.list(path);
                inputs.forEach(file -> {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String name = file.getFileName().toString();
                        files.add(Maps.immutableEntry((Object)name, (Object)content));
                    }
                    catch (IOException e) {
                        this.logger.warn("There was a problem during reading " + file + " !");
                        e.printStackTrace();
                    }
                });
                inputs.close();
            }
            catch (IOException e) {
                this.logger.warn("There was a problem during listing all files from " + path + " !");
                e.printStackTrace();
            }
        });
        return files;
    }

    public List<Map.Entry<String, String>> getFiles(String internal) {
        ArrayList<Path> externalPaths = new ArrayList<Path>();
        String fullPath = this.fromInternal(internal);
        this.paths.forEach(path -> externalPaths.add(path.resolve(fullPath)));
        return this.getFiles(internal, externalPaths);
    }

    public <T> Map<String, T> toJson(Class<T> clazz, Map<String, String> file) {
        HashMap map = new HashMap();
        file.forEach((name, content) -> map.put(name, this.gson.fromJson(content, clazz)));
        return map;
    }
}

