/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class Magneticraft {
    private static final String tileModules = "com.cout970.magneticraft.systems.tilemodules.";
    private static final String tileEntities = "com.cout970.magneticraft.systems.tileentities.";

    public static class BigChamberLiquidFuel
    extends BaseChamber {
        private final MethodSignature fluidTankDrain = MethodSignature.FLUID_TANK_DRAIN.with("com/cout970/magneticraft/misc/fluid/Tank");

        public BigChamberLiquidFuel() {
            super("ModuleBigCombustionChamber", "burnLiquidFuel");
        }

        @Override
        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.fluidTankDrain.complyWith(instruct);
        }

        @Override
        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE_AMOUNT;
        }

        @Override
        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeVirtual(this.getContainer).invokeInterface(this.getTile).loadObjFrom(1, "fluid").loadIntFrom(2, "fluidAmount").invokeStatic(this.getHandler()).insertBefore();
        }
    }

    public static class BigChamberSolidFuel
    extends BaseChamber {
        public BigChamberSolidFuel() {
            super("ModuleBigCombustionChamber", "burnSolidFuel");
        }
    }

    public static class CombustionChamber
    extends BaseChamber {
        public CombustionChamber() {
            super("ModuleCombustionChamber", "consumeFuel");
        }
    }

    private static abstract class BaseChamber
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod;
        protected final MethodSignature getContainer;
        protected final MethodSignature getTile;

        public BaseChamber(String targetClassName, String targetMethodName) {
            targetClassName = Magneticraft.tileModules + targetClassName;
            this.targetMethod = MethodSignature.of((String)targetClassName, (String)targetMethodName, (MethodDescriptor)MethodDescriptor.of((Types)Types.BOOLEAN));
            String iModuleContainer = "com.cout970.magneticraft.systems.tileentities.IModuleContainer";
            this.getContainer = MethodSignature.of((String)targetClassName, (String)"getContainer", (MethodDescriptor)MethodDescriptor.of((Descriptor)ClassDescriptor.from((String)iModuleContainer)));
            this.getTile = MethodSignature.of((String)iModuleContainer, (String)"getTile", (MethodDescriptor)MethodDescriptor.of((Descriptor)ClassDescriptor.from((String)"com.cout970.magneticraft.systems.tileentities.TileBase")));
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().invokeVirtual(this.getContainer).invokeInterface(this.getTile).loadObjFrom(1, "fuel").invokeStatic(this.getHandler()).insertBefore();
        }
    }
}

