/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.Biome;

public class PollutionInfo
implements INBTSerializable<PollutionInfo> {
    private Pollutant<?> pollutant;
    private int currentAmount = 0;
    private double fractAmount = 0.0;
    private boolean dirty = false;
    public static final String FLOAT_VALUE_FORMAT = "%.4f";

    public PollutionInfo(Pollutant<?> pollutant) {
        this.pollutant = pollutant;
    }

    public float getFactorIn(Biome biome) {
        int criticalAmount = this.getCriticalAmountIn(biome);
        if (criticalAmount == 0) {
            return 0.0f;
        }
        return (float)this.getAmount() / (float)criticalAmount;
    }

    public Percentage getPercentageIn(Biome biome) {
        return Percentage.from((float)this.getFactorIn(biome));
    }

    public Pollutant<?> getPollutant() {
        return this.pollutant;
    }

    public int getCriticalAmountIn(Biome biome) {
        return this.pollutant.getCriticalAmountIn(biome);
    }

    public int getAmount() {
        return this.currentAmount;
    }

    public double getFractAmount() {
        return this.fractAmount;
    }

    public String getFormatedAmount() {
        return String.format(FLOAT_VALUE_FORMAT, (double)this.getAmount() + this.getFractAmount());
    }

    public String toChatString(Biome biome) {
        return Args.get((String)(this.getPollutant().getTextColor() + this.getPollutant().func_149732_F()), (Object)this.getFormatedAmount()) + " " + this.getPercentageIn(biome).toColoredText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"pollutant", (Object)this.getPollutant().getId().getRegName()), Args.get((String)"amount", (Object)this.getFormatedAmount())});
    }

    public void setFractAmount(double fractAmount) {
        if (this.fractAmount != fractAmount) {
            this.fractAmount = fractAmount;
            this.setDirty(true);
        }
    }

    public void setAmount(int amount) {
        if (this.currentAmount != amount) {
            this.currentAmount = amount;
            this.setDirty(true);
        }
    }

    protected void setPollutant(Pollutant<?> pollutant) {
        if (this.pollutant != pollutant) {
            this.pollutant = pollutant;
            this.setDirty(true);
        }
    }

    public void increaseAmount(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public boolean isEmpty() {
        return this.getPollutant() == null || this.getAmount() == 0 && CommonMath.isAlmostZero((double)this.getFractAmount());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public PollutionInfo readFrom(NBTTagCompound compound) {
        int id = compound.func_74762_e(Tags.POLLUTANT_ID.name());
        Block block = Block.func_149729_e((int)id);
        if (block instanceof Pollutant) {
            Pollutant pollutant = (Pollutant)block;
            this.setPollutant(pollutant);
            this.setAmount(compound.func_74762_e(Tags.CURRENT_AMOUNT.name()));
            this.setFractAmount(compound.func_74769_h(Tags.FRACT_AMOUNT.name()));
        }
        return this;
    }

    public NBTTagCompound writeTo(NBTTagCompound compound) {
        compound.func_74768_a(Tags.POLLUTANT_ID.name(), Block.func_149682_b(this.pollutant));
        compound.func_74768_a(Tags.CURRENT_AMOUNT.name(), this.getAmount());
        compound.func_74780_a(Tags.FRACT_AMOUNT.name(), this.getFractAmount());
        return compound;
    }

    protected static enum Tags {
        POLLUTANT_ID,
        CURRENT_AMOUNT,
        FRACT_AMOUNT;

    }
}

