/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import baubles.api.BaubleType;
import baubles.api.render.IRenderBauble;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.IBaubleWear;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.endertech.minecraft.forge.api.IBaubleWear", modid="baubles", striprefs=true)
public class Respirator
extends EquipmentItem
implements IBaubleWear {
    public Respirator(ForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.func_176610_l(), CreativeTabs.field_78040_i, material.durability, UnitId.from((String)"leather"), EntityEquipmentSlot.HEAD, SoundEvents.field_189109_ed);
        this.addCraftingRecipe("131 262 454", 1, new String[]{"glass_bottle", "leather", "leather_helmet", "wool:*", "treeLeaves", material.getDictName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType != IRenderBauble.RenderType.HEAD) {
            return;
        }
        GlStateManager.func_179094_E();
        this.translateForHead(player);
        this.renderItemOn((EntityLivingBase)player, stack, ItemCameraTransforms.TransformType.HEAD);
        GlStateManager.func_179121_F();
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        Respirators.Respirator respirator = (Respirators.Respirator)Main.getRespirators().findBy(stack);
        if (respirator != null) {
            respirator.installFiltersFor(stack, new Pollutant[]{Pollutants.BuiltIn.CARBON.get(), Pollutants.BuiltIn.SULFUR.get()});
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.HEAD;
    }
}

