/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Torch;

public class Torches
extends EmittersInit<Torch, BuiltInEmitters> {
    public Torches(ForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Torch createCustomUnitFrom(UnitConfig config, String name) {
        return new Torch(config, UnitId.EMPTY, Emissions.of());
    }

    public Torch createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        UnitId id = UnitId.from((Enum)e, (boolean)true);
        if (!e.metadata.isEmpty()) {
            id = id.withMetaData(e.metadata);
        }
        return new Torch(config, id, e.emissions);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        torch(0.1f, 0.01f),
        atum$palm_torch(0.1f, 0.01f),
        atum$deadwood_torch(0.1f, 0.01f),
        atum$limestone_torch(0.1f, 0.01f),
        atum$bone_torch(0.1f, 0.01f),
        atum$pharaoh_torch(0.1f, 0.01f),
        bonetorch$bonetorch(0.1f, 0.01f),
        burningtorch$burningtorch("[lit=true]", 0.1f, 0.01f),
        harvestcraft$candledeco1(0.05f, 0.005f),
        harvestcraft$candledeco2(0.05f, 0.005f),
        harvestcraft$candledeco3(0.05f, 0.005f),
        harvestcraft$candledeco4(0.05f, 0.005f),
        harvestcraft$candledeco5(0.05f, 0.005f),
        harvestcraft$candledeco6(0.05f, 0.005f),
        harvestcraft$candledeco7(0.05f, 0.005f),
        harvestcraft$candledeco8(0.05f, 0.005f),
        harvestcraft$candledeco9(0.05f, 0.005f),
        harvestcraft$candledeco10(0.05f, 0.005f),
        harvestcraft$candledeco11(0.05f, 0.005f),
        harvestcraft$candledeco12(0.05f, 0.005f),
        harvestcraft$candledeco13(0.05f, 0.005f),
        harvestcraft$candledeco14(0.05f, 0.005f),
        harvestcraft$candledeco15(0.05f, 0.005f),
        harvestcraft$candledeco16(0.05f, 0.005f),
        mysticalagriculture$miners_torch(0.1f, 0.01f),
        primal$lantern_torch("[lit=true]", 0.1f, 0.01f),
        primal$lantern_nether("[lit=true]", 0.1f, 0.1f),
        primal$lantern_ignis("[lit=true]", 0.1f, 0.01f),
        pyrotech$torch_fiber("[type=lit]", 0.2f, 0.02f),
        pyrotech$torch_stone("[type=lit]", 0.1f, 0.01f),
        realistictorches$torch_lit(0.1f, 0.02f),
        realistictorches$torch_smoldering(0.2f, 0.01f),
        tconstruct$stone_torch(0.1f, 0.01f);

        final String metadata;
        final Emissions emissions;

        private BuiltInEmitters(float carbon, float sulfur) {
            this("", carbon, sulfur);
        }

        private BuiltInEmitters(String metadata, float carbon, float sulfur) {
            this.metadata = metadata;
            this.emissions = Emissions.of().carbon(carbon).sulfur(sulfur);
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

