/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import java.util.Collections;
import java.util.Map;

public class Breakables
extends RelatedUnitsInit<BreakableBlock, BuiltInBreakables> {
    public Breakables(ForgeMod mod) {
        super(mod, BuiltInBreakables.class);
    }

    public BreakableBlock createCustomUnitFrom(UnitConfig config, String name) {
        return new BreakableBlock(config, UnitId.EMPTY, Emissions.of());
    }

    public BreakableBlock createDefaultUnitFrom(UnitConfig config, BuiltInBreakables e) {
        UnitId id = e.id.isEmpty() ? UnitId.from((Enum)e, (boolean)true) : UnitId.from((String)e.id);
        return e.createBreakable(config, id);
    }

    public Map<BlockState, BreakableBlock> getBlockStates() {
        return Collections.unmodifiableMap(this.blockStates);
    }

    static enum BuiltInBreakables implements IForgeEnum
    {
        coal_ore("oreCoal", 0.4f, 0.0f, 0.0f),
        coal_block("blockCoal", 3.6f, 0.0f, 0.0f),
        sulfur_ore("oreSulfur", 0.0f, 0.4f, 0.0f),
        sulfur_block("blockSulfur", 0.0f, 3.6f, 0.0f),
        charcoal_block("blockCharcoal", 3.6f, 0.0f, 0.0f),
        coke_block("blockCoke", 3.6f, 0.0f, 0.0f),
        dumpsterdiving$trash_ore(0.8f, 0.2f, 0.0f),
        dumpsterdiving$trash_oren(0.8f, 0.8f, 0.0f);

        final String id;
        final Emissions emissions;

        private BuiltInBreakables(float carbon, float sulfur, float dust) {
            this("", carbon, sulfur, dust);
        }

        private BuiltInBreakables(String id, float carbon, float sulfur, float dust) {
            this.id = id;
            this.emissions = Emissions.of().carbon(carbon).sulfur(sulfur).dust(dust);
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        BreakableBlock createBreakable(UnitConfig config, UnitId id) {
            return new BreakableBlock(config, id, this.emissions);
        }
    }
}

