/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class WorldEvents {
    static final GameTime IGNITION_FROM_TORCH_CHECK_INTERVAL = GameTime.second();

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
        World world = event.getWorld();
        if (ForgeWorld.isServerSide((World)world)) {
            world.func_72954_a((IWorldEventListener)new WorldListener());
        }
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        WorldData.removeDataFor(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        World world = event.world;
        if (ForgeWorld.isServerSide((World)world)) {
            WorldData data = WorldData.getData(world);
            data.updateScheduledEmissions();
            if (IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn(world)) {
                data.updateDroppedTorches();
            }
        }
    }

    public static class WorldListener
    implements IWorldEventListener {
        public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            WorldData.BlockStateChange.handle(world, pos, oldState, newState);
            if (ForgeWorld.isAirBlock((IBlockState)oldState) || oldState.func_177230_c() instanceof Pollutant) {
                WorldData.updateIgnitionSource(world, pos, newState);
            }
        }

        public void func_72703_a(Entity entity) {
            World world = entity.func_130014_f_();
            WorldData data = WorldData.getData(world);
            data.getPollutantEntityLimiter().onEntityAdded(entity);
            data.addIfDroppedTorch(entity);
            Emitter emitter = (Emitter)Main.getEmitters().findBy(entity);
            if (emitter != null) {
                data.scheduleEmissionFor(entity, emitter);
            }
        }

        public void func_72709_b(Entity entity) {
            WorldData data = WorldData.getData(entity.field_70170_p);
            data.getPollutantEntityLimiter().onEntityRemoved(entity);
            data.removePollutionInfoFor(entity);
            data.removeScheduledEmissionFor(entity);
            data.removeIfDroppedTorch(entity);
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }
    }
}

