/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ChunkEvents {
    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        ChunkLoc location = ChunkLoc.from((Chunk)event.getChunk());
        ChunkPollution pollution = WorldData.getChunkPollution(event.getWorld(), location);
        pollution.readFrom(event.getData());
        pollution.setUnloaded(false);
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        ChunkLoc location;
        World world = event.getWorld();
        ChunkPollution pollution = WorldData.getChunkPollution(world, location = ChunkLoc.from((Chunk)event.getChunk()));
        if (!pollution.isEmpty()) {
            pollution.writeTo(event.getData());
        }
        if (pollution.isUnloaded()) {
            WorldData.getData(world).removePollutionInfoAt(location);
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        World world = event.getWorld();
        ChunkLoc location = ChunkLoc.from((Chunk)event.getChunk());
        WorldData data = WorldData.getData(world);
        ChunkPollution pollution = WorldData.getChunkPollution(world, location);
        pollution.setUnloaded(true);
        if (ForgeWorld.isClientSide((World)world)) {
            data.removePollutionInfoAt(location);
        }
    }
}

