/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Emissions {
    public static final Emissions NONE = new Emissions(Collections.emptyMap());
    protected final Map<Pollutant<?>, Emission> emissions;

    protected Emissions(Map<Pollutant<?>, Emission> emissions) {
        this.emissions = emissions;
    }

    public static Emissions of() {
        return new Emissions(new HashMap());
    }

    public Emissions carbon(float amount) {
        return this.add(Pollutants.BuiltIn.CARBON.get(), amount);
    }

    public Emissions sulfur(float amount) {
        return this.add(Pollutants.BuiltIn.SULFUR.get(), amount);
    }

    public Emissions dust(float amount) {
        return this.add(Pollutants.BuiltIn.DUST.get(), amount);
    }

    protected Emissions add(Pollutant<?> pollutant, float amount) {
        this.emissions.put(pollutant, Emission.of(pollutant, amount));
        return this;
    }

    public Collection<Emission> get() {
        return Collections.unmodifiableCollection(this.emissions.values());
    }
}

