/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;

public class TConstruct {
    public static void onAlloyFilled(TileEntity tile, FluidStack alloy) {
        String name;
        if (alloy != null && (name = alloy.getFluid().getName()).equals("obsidian")) {
            WorldData.onFuelBurned(tile, alloy);
        }
    }

    public static class HeatingStructure
    extends Emitter {
        public HeatingStructure(UnitConfig config, UnitId id, String activeTag, String[] relatedBlocks, Emissions emissions) {
            super(config, id, KeyValuePair.EMPTY, false, activeTag, false, relatedBlocks, emissions, 1.0f);
        }

        @Override
        public boolean isActive(INBTSerializable<NBTTagCompound> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            NBTTagCompound compound = (NBTTagCompound)nbtSource.serializeNBT();
            boolean active = compound.func_74767_n("active");
            int fuel = compound.func_74762_e("fuel");
            if (active && fuel > 0) {
                int[] temps = compound.func_74759_k("itemTemperatures");
                for (int i = 0; i < temps.length; ++i) {
                    if (temps[i] <= 1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

