/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.ModConfigGui;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveVehicles;
import com.endertech.minecraft.mods.adpother.config.ImmuneEntities;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.EntityEmission;
import com.endertech.minecraft.mods.adpother.events.AnvilEvents;
import com.endertech.minecraft.mods.adpother.events.PlayerEvents;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.endertech.minecraft.mods.adpother.transformers.Galacticraft;
import com.endertech.minecraft.mods.adpother.transformers.ImmersiveRailroading;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class Config
extends ModConfig {
    public Config(String modId, FMLPreInitializationEvent event) {
        super(modId, event);
    }

    public void init() {
        String category = "Client";
        PlayerEvents.Smog.renderSmog = this.getBool(category, "renderSmog", true, "Defines whether the smog from pollution should be rendered for the player.");
        PlayerEvents.Smog.colorSky = this.getBool(category, "colorSky", true, "Defines whether the smog should color the sky.");
        Emission.globalRate = this.getPercentage("Server", "globalEmissionRate", 100, BOUNDS_PERCENTAGE_SLIDER, "Global rate of emissions for all pollutants and sources on the server (in percents).").toFraction();
        AnvilEvents.filterReplacingExpGain = this.getIntSlider("Server", "filterReplacingExpGain", 0, IntBounds.from((Integer)-10, (Integer)10), "Experience gain after replacing the filter material in a respirator or a vacuum bag.");
        Pollutant.globalImmuneEntities = new ImmuneEntities((ForgeConfig)this, "Server", "List of entities immune to all pollutants.").loadEntities();
        WorldData.altitudeBounds = this.getIntBounds("Server", "Altitude", ForgeBounds.HEIGHT.getIntBounds(), IntBounds.INTEGER, "Altitude bounds pollution can act within.");
        GasExplosion.maxChainLength = this.getIntSlider("Server", "maxExplosionChainLength", 512, IntBounds.from((Integer)0, (Integer)2048), "Maximum gas blocks that can be involved in an explosive chain reaction.");
        category = Names.dotted().join(new String[]{"Server", "Emission Sources"});
        String switch_comment = "Enables / disables emissions from this source.";
        String rate_comment = "Defines the rate of emissions from this source (in percents).";
        BreakableBlock.rate = this.getPercentage(category, "Breakables", 100, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
        EntityEmission.rate = this.getPercentage(category, "Entities", 100, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
        Torch.rate = this.getPercentage(category, "Torches", 0, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
        WorldData.FurnaceFuelBurned.generateEmissions = this.getBool(category, "VanillaFurnace", true, switch_comment);
        WorldData.BlockCaughtFire.generateEmissions = this.getBool(category, "Fire", true, switch_comment);
        Sources sources = Main.getSources();
        if (sources != null) {
            for (SourceBase src : sources.getAll()) {
                boolean enabled = this.getBool(category, ((Object)((Object)src)).getClass().getSimpleName(), true, switch_comment);
                src.setEnabled(enabled);
            }
        }
        ImmersiveVehicles.rate = this.getPercentage(category, "ImmersiveVehicles(MTS)", 100, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
        ImmersiveRailroading.LocomotiveDiesel.rate = this.getPercentage(category, "IR Diesel Locomotives", 100, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
        ImmersiveRailroading.LocomotiveSteam.enabled = this.getBool(category, "IR Steam Locomotives", true, switch_comment);
        Galacticraft.AutoRocket.rate = this.getPercentage(category, "Galacticraft Rockets", 100, BOUNDS_PERCENTAGE_SLIDER, rate_comment).toFraction();
    }

    public int getInt(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        try {
            return this.getInt(key, category, defaultValue, bounds.getMin(), bounds.getMax(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose((int)defaultValue, (IntBounds)bounds);
        }
    }

    public int getIntSlider(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        Property prop = this.get(category, key, defaultValue, comment, bounds.getMin(), bounds.getMax());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        return prop.getInt();
    }

    public static class Factory
    extends ModConfigGui.Factory {
        public GuiScreen createConfigGui(GuiScreen parent) {
            return new ModConfigGui((ForgeMod)Main.instance, parent);
        }
    }
}

