/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.recipe.RecipesMachine;

public abstract class RecipeMachineFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        LinkedList<List<ItemStack>> inputs = new LinkedList();
        List<Object> outputs = new LinkedList();
        LinkedList<FluidStack> inputFluids = new LinkedList<FluidStack>();
        LinkedList<RecipesMachine.ChanceFluidStack> outputFluids = new LinkedList();
        int timeTaken = 0;
        int energy = 0;
        int maxOutput = -1;
        try {
            JsonElement fluidResultElement;
            JsonElement fluidIngredientElement;
            JsonElement ingredientElement = json.get("itemingredients");
            if (ingredientElement != null) {
                inputs = this.getIngredientsFromArray(context, ingredientElement);
            }
            JsonElement itemResults = json.get("itemresults");
            JsonElement maxOutputJson = json.get("maxoutputsize");
            if (maxOutputJson != null) {
                maxOutput = maxOutputJson.getAsInt();
            }
            if (itemResults != null) {
                if (itemResults.isJsonArray()) {
                    for (JsonElement element : itemResults.getAsJsonArray()) {
                        outputs.addAll(this.getFirstIngredient(context, element));
                    }
                } else {
                    outputs = this.getFirstIngredient(context, itemResults);
                }
            }
            if ((fluidIngredientElement = json.get("fluidingredients")) != null) {
                for (RecipesMachine.ChanceFluidStack stack : this.getFluidStacks(context, fluidIngredientElement)) {
                    inputFluids.add(stack.stack);
                }
            }
            if ((fluidResultElement = json.get("fluidresults")) != null) {
                outputFluids = this.getFluidStacks(context, fluidResultElement);
            }
            timeTaken = json.get("time").getAsInt();
            energy = json.get("energy").getAsInt();
        }
        catch (NullPointerException e) {
            throw new JsonParseException("Missing parameters");
        }
        RecipesMachine.Recipe recipe = new RecipesMachine.Recipe(outputs, inputs, outputFluids, inputFluids, timeTaken, energy, new HashMap<Integer, String>());
        if (maxOutput > 0) {
            recipe.setMaxOutputSize(maxOutput);
        }
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).add(recipe);
        return new RecipesMachine.DummyRecipe();
    }

    public abstract Class getMachine();

    public List<RecipesMachine.ChanceFluidStack> getFluidStacks(JsonContext context, JsonElement json) {
        if (!json.isJsonArray()) {
            return null;
        }
        LinkedList<RecipesMachine.ChanceFluidStack> fluidstacks = new LinkedList<RecipesMachine.ChanceFluidStack>();
        JsonArray ingredientListJSON = json.getAsJsonArray();
        for (JsonElement ingredient : ingredientListJSON) {
            fluidstacks.add(this.parseFluid(context, ingredient));
        }
        return fluidstacks;
    }

    public RecipesMachine.ChanceFluidStack parseFluid(JsonContext context, JsonElement json) {
        String fluidname = json.getAsJsonObject().get("fluid").getAsString();
        int size = json.getAsJsonObject().get("amount").getAsInt();
        JsonElement chanceElem = json.getAsJsonObject().get("chance");
        float chance = 0.0f;
        if (chanceElem != null) {
            chance = chanceElem.getAsFloat();
        }
        return new RecipesMachine.ChanceFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluidname), size), chance);
    }

    List<List<ItemStack>> getIngredientsFromArray(JsonContext context, JsonElement json) {
        if (!json.isJsonArray()) {
            return null;
        }
        JsonArray ingredientListJSON = json.getAsJsonArray();
        LinkedList<List<ItemStack>> inputs = new LinkedList<List<ItemStack>>();
        for (JsonElement ingredient : ingredientListJSON) {
            LinkedList<ItemStack> newList = new LinkedList<ItemStack>();
            for (RecipesMachine.ChanceItemStack stack3 : this.getIngredients(context, ingredient)) {
                newList.add(stack3.stack);
            }
            inputs.add(newList);
        }
        return inputs;
    }

    List<RecipesMachine.ChanceItemStack> getIngredients(JsonContext context, JsonElement json) {
        LinkedList<RecipesMachine.ChanceItemStack> stacks = new LinkedList<RecipesMachine.ChanceItemStack>();
        for (ItemStack stack : CraftingHelper.getIngredient((JsonElement)json, (JsonContext)context).func_193365_a()) {
            int count = stack.func_190916_E();
            int data = stack.func_77952_i();
            float chance = 0.0f;
            ItemStack stack2 = stack.func_77946_l();
            JsonElement countElem = json.getAsJsonObject().get("count");
            JsonElement dataElem = json.getAsJsonObject().get("data");
            JsonElement chanceElem = json.getAsJsonObject().get("chance");
            if (countElem != null) {
                count = countElem.getAsInt();
            }
            if (dataElem != null) {
                data = dataElem.getAsInt();
            }
            if (chanceElem != null) {
                chance = chanceElem.getAsFloat();
            }
            stack2.func_190920_e(count);
            stack2.func_77964_b(data);
            stacks.add(new RecipesMachine.ChanceItemStack(stack2, chance));
        }
        return stacks;
    }

    List<RecipesMachine.ChanceItemStack> getFirstIngredient(JsonContext context, JsonElement json) {
        List<RecipesMachine.ChanceItemStack> stacks = this.getIngredients(context, json);
        if (stacks.size() > 1) {
            RecipesMachine.ChanceItemStack stack = stacks.get(0);
            stacks = new LinkedList<RecipesMachine.ChanceItemStack>();
            stacks.add(stack);
        }
        return stacks;
    }
}

