/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.client;

import com.creativemd.opf.client.PictureTexture;
import com.creativemd.opf.client.ProcessedImageData;

public class AnimatedPictureTexture
extends PictureTexture {
    private final int[] textureIDs;
    private final long[] delay;
    private final long duration;
    private int completedFrames;
    private ProcessedImageData imageData;

    public AnimatedPictureTexture(ProcessedImageData image) {
        super(image.getWidth(), image.getHeight());
        this.imageData = image;
        this.textureIDs = new int[image.getFrameCount()];
        this.delay = image.getDelay();
        this.duration = image.getDuration();
        for (int i = 0; i < this.textureIDs.length; ++i) {
            this.textureIDs[i] = -1;
        }
    }

    @Override
    public void tick() {
        if (this.imageData != null) {
            long startTime = System.currentTimeMillis();
            int index = 0;
            while (this.completedFrames < this.textureIDs.length && index < this.textureIDs.length && System.currentTimeMillis() - startTime < 10L) {
                while (this.textureIDs[index] != -1 && index < this.textureIDs.length - 1) {
                    ++index;
                }
                if (this.textureIDs[index] != -1) continue;
                this.textureIDs[index] = this.uploadFrame(index);
            }
        }
    }

    @Override
    public int getTextureID() {
        long time = this.duration > 0L ? System.currentTimeMillis() % this.duration : 0L;
        int index = 0;
        for (int i = 0; i < this.delay.length; ++i) {
            if (this.delay[i] < time) continue;
            index = i;
            break;
        }
        return this.textureIDs[index];
    }

    private int uploadFrame(int index) {
        int id;
        this.textureIDs[index] = id = this.imageData.uploadFrame(index);
        if (++this.completedFrames >= this.imageData.getFrameCount()) {
            this.imageData = null;
        }
        return id;
    }
}

