/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.mojang.authlib.GameProfile;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDestructor;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeDestructor
extends NetworkNode
implements IComparable,
IFilterable,
IType,
ICoverable {
    public static final String ID = "destructor";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final String NBT_COVERS = "Covers";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory fluidFilters = new FluidInventory(9, new ListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 6, 7, 8, 9);
    private int compare = 3;
    private int mode = 1;
    private int type = 0;
    private boolean pickupItem = false;
    private CoverManager coverManager = new CoverManager(this);

    public NetworkNodeDestructor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.destructorUsage + this.upgrades.getEnergyUsage();
    }

    private FakePlayer getFakePlayer() {
        PlayerProfileCache profileCache;
        GameProfile profile;
        WorldServer world = (WorldServer)this.world;
        UUID owner = this.getOwner();
        if (owner != null && (profile = (profileCache = world.func_73046_m().func_152358_ax()).func_152652_a(owner)) != null) {
            return FakePlayerFactory.get((WorldServer)world, (GameProfile)profile);
        }
        return FakePlayerFactory.getMinecraft((WorldServer)world);
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0) {
            BlockPos front = this.pos.func_177972_a(this.getDirection());
            if (this.pickupItem && this.type == 0) {
                ArrayList droppedItems = new ArrayList();
                Chunk chunk = this.world.func_175726_f(front);
                chunk.func_177414_a(null, new AxisAlignedBB(front), droppedItems, null);
                for (Entity entity : droppedItems) {
                    ItemStack droppedItem;
                    if (!(entity instanceof EntityItem) || !IFilterable.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, droppedItem = ((EntityItem)entity).func_92059_d()) || this.network.insertItem(droppedItem, droppedItem.func_190916_E(), Action.SIMULATE) != null) continue;
                    this.network.insertItemTracked(droppedItem.func_77946_l(), droppedItem.func_190916_E());
                    this.world.func_72900_e(entity);
                    break;
                }
            } else if (this.type == 0) {
                IBlockState frontBlockState = this.world.func_180495_p(front);
                Block frontBlock = frontBlockState.func_177230_c();
                ItemStack frontStack = frontBlock.getPickBlock(frontBlockState, new RayTraceResult(new Vec3d((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p()), this.getDirection().func_176734_d()), this.world, front, (EntityPlayer)this.getFakePlayer());
                if (!frontStack.func_190926_b() && IFilterable.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, frontStack) && (double)frontBlockState.func_185887_b(this.world, front) != -1.0) {
                    NonNullList drops = NonNullList.func_191196_a();
                    if (frontBlock instanceof BlockShulkerBox) {
                        drops.add((Object)((BlockShulkerBox)frontBlock).func_185473_a(this.world, front, frontBlockState));
                        TileEntity shulkerBoxTile = this.world.func_175625_s(front);
                        if (shulkerBoxTile instanceof TileEntityShulkerBox) {
                            ((TileEntityShulkerBox)shulkerBoxTile).func_190579_a(true);
                            ((TileEntityShulkerBox)shulkerBoxTile).func_174888_l();
                        }
                    } else if (this.upgrades.hasUpgrade(6) && frontBlock.canSilkHarvest(this.world, front, frontBlockState, null)) {
                        drops.add((Object)frontStack);
                    } else {
                        frontBlock.getDrops(drops, (IBlockAccess)this.world, front, frontBlockState, this.upgrades.getFortuneLevel());
                    }
                    for (ItemStack drop : drops) {
                        if (this.network.insertItem(drop, drop.func_190916_E(), Action.SIMULATE) == null) continue;
                        return;
                    }
                    BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.world, front, frontBlockState, (EntityPlayer)this.getFakePlayer());
                    if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
                        this.world.func_180498_a(null, 2001, front, Block.func_176210_f((IBlockState)frontBlockState));
                        this.world.func_175698_g(front);
                        for (ItemStack drop : drops) {
                            if (this.network == null) {
                                InventoryHelper.func_180173_a((World)this.world, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                                continue;
                            }
                            this.network.insertItemTracked(drop, drop.func_190916_E());
                        }
                    }
                }
            } else if (this.type == 1) {
                FluidStack stack;
                Block frontBlock = this.world.func_180495_p(front).func_177230_c();
                BlockLiquidWrapper handler = null;
                if (frontBlock instanceof BlockLiquid) {
                    handler = new BlockLiquidWrapper((BlockLiquid)frontBlock, this.world, front);
                } else if (frontBlock instanceof IFluidBlock) {
                    handler = new FluidBlockWrapper((IFluidBlock)frontBlock, this.world, front);
                }
                if (handler != null && (stack = handler.drain(1000, false)) != null && IFilterable.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, Action.SIMULATE) == null) {
                    FluidStack drained = handler.drain(1000, true);
                    this.network.insertFluidTracked(drained, drained.amount);
                }
            }
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_PICKUP, this.pickupItem);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_PICKUP)) {
            this.pickupItem = tag.func_74767_n(NBT_PICKUP);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        OneSixMigrationHelper.migrateEmptyWhitelistToEmptyBlacklist(this.version, this, this.itemFilters);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getInventory() {
        return this.itemFilters;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileDestructor.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    public boolean isPickupItem() {
        return this.pickupItem;
    }

    public void setPickupItem(boolean pickupItem) {
        this.pickupItem = pickupItem;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

