/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.network;

import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import com.paneedah.weaponlib.vehicle.network.VehicleDataContainer;
import com.paneedah.weaponlib.vehicle.network.VehiclePacketLatencyTracker;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.Vec3d;

public class VehicleSmoothShell {
    public EntityVehicle vehicle;
    public VehicleDataContainer cs;
    public boolean inTransition = false;
    public long finishTime = 0L;
    public long lastTransition = -1L;
    public ConcurrentLinkedQueue<VehicleDataContainer> states = new ConcurrentLinkedQueue();

    public VehicleSmoothShell(EntityVehicle v) {
        this.vehicle = v;
    }

    public void upload(VehicleDataContainer state) {
        if (this.states.size() > 5) {
            this.states.clear();
        }
        this.states.add(state);
    }

    public void update() {
        double currentTime = System.currentTimeMillis();
        if (this.inTransition && currentTime > (double)this.finishTime) {
            this.inTransition = false;
            ((VehicleDataContainer)this.states.element()).updateVehicle(this.vehicle);
            this.states.remove();
        }
        if (!this.inTransition && !this.states.isEmpty()) {
            this.lastTransition = System.currentTimeMillis();
            this.cs = new VehicleDataContainer(this.vehicle);
            this.inTransition = true;
            this.finishTime = System.currentTimeMillis() + VehiclePacketLatencyTracker.getLastDelta(this.vehicle);
        }
        if (!this.inTransition) {
            return;
        }
        double mu = (currentTime - (double)this.lastTransition) / (double)(this.finishTime - this.lastTransition);
        VehicleDataContainer next = (VehicleDataContainer)this.states.element();
        this.vehicle.throttle = this.q(this.cs.throttle, next.throttle, mu);
        this.vehicle.driftTuner = this.q(this.cs.driftTuner, next.driftTuner, mu);
        this.vehicle.forwardLean = this.q(this.cs.forwardLean, next.forwardLean, mu);
        this.vehicle.sideLean = this.q(this.cs.sideLean, next.sideLean, mu);
        this.vehicle.wheelRotationAngle = (float)this.q(this.cs.wheelRotationAngle, next.wheelRotationAngle, mu);
        this.vehicle.steerangle = this.q(this.cs.steerangle, next.steerangle, mu);
        this.vehicle.field_70169_q = this.vehicle.field_70165_t;
        this.vehicle.field_70167_r = this.vehicle.field_70163_u;
        this.vehicle.field_70166_s = this.vehicle.field_70161_v;
        Vec3d iP = this.qv(this.cs.position, next.position, mu);
        Vec3d pD = iP.func_178788_d(this.vehicle.func_174791_d());
        this.vehicle.func_70091_d(MoverType.SELF, pD.field_72450_a, pD.field_72448_b, pD.field_72449_c);
        this.vehicle.prevRotationRoll = this.vehicle.rotationRoll;
        this.vehicle.field_70127_C = this.vehicle.field_70125_A;
        this.vehicle.field_70126_B = this.vehicle.field_70177_z;
        this.vehicle.rotationRoll = (float)this.q(this.cs.rotationRoll, next.rotationRoll, mu);
        this.vehicle.field_70125_A = (float)this.q(this.cs.rotationPitch, next.rotationPitch, mu);
        this.vehicle.field_70177_z = (float)this.q(this.cs.rotationYaw, next.rotationYaw, mu);
        this.vehicle.getSolver().synthAccelFor = this.q(this.cs.synthAccelFor, next.synthAccelFor, mu);
        this.vehicle.getSolver().velocity = this.qv(this.cs.velocity, next.velocity, mu);
    }

    public double q(double a, double b, double mu) {
        return InterpolationKit.interpolateValue(a, b, mu);
    }

    public Vec3d qv(Vec3d a, Vec3d b, double mu) {
        return InterpolationKit.interpolateVector(a, b, mu);
    }
}

