/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics.solver;

import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.jimphysics.Engine;
import com.paneedah.weaponlib.vehicle.jimphysics.PhysicsConfiguration;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import com.paneedah.weaponlib.vehicle.jimphysics.VehiclePhysUtil;
import com.paneedah.weaponlib.vehicle.jimphysics.engines.FlywheelSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.WheelAxel;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.WheelSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.aero.IAeroComponent;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.components.EngineSolver;
import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector2d;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.Vec3d;

public class VehiclePhysicsSolver {
    public FlywheelSolver flywheel = new FlywheelSolver(9.07, 0.1651, 0.0025);
    public Matrix3d rotMat;
    public WheelAxel frontAxel;
    public WheelAxel rearAxel;
    public EntityVehicle vehicle;
    public Engine engine;
    int revolutions = 0;
    public double timeStep = 0.05;
    public Vec3d positonDelta = new Vec3d(0.0, 0.0, 0.0);
    double mass;
    public Vec3d acceleration = Vec3d.field_186680_a;
    public Vec3d velocity = new Vec3d(0.0, 0.0, 0.0);
    double brakeTorque = 12000.0;
    double COGHeight = 0.3;
    public Transmission transmission;
    public EngineSolver engineSolver;
    public float[] angles;
    public double angularVelocity = 0.0;
    double yawspeed = 0.0;
    double wheelBase = 1.0;
    public double synthAccelFor = 0.0;
    public double synthAccelSide = 0.0;
    public double accelerationValue = 0.0;
    public double rotationalImpulse = 0.0;
    public int physicsStep = 0;
    Vec3d sideForAccel = new Vec3d(0.0, 0.0, 0.0);
    Vector2d longLatVal = new Vector2d(0.0, 0.0);
    Vector2d accelLongLat = new Vector2d(0.0, 0.0);
    public boolean isDrifting = true;
    public Material materialBelow;
    public ArrayList<WheelSolver> wheels = new ArrayList();
    public PhysicsConfiguration configuration;
    public ArrayList<IAeroComponent> aeroComponents = new ArrayList();
    public double collisionTorque = 0.0;
    public double weightRatio;
    public double prevSuspensionPitch = 0.0;
    public double suspensionPitch = 0.0;
    public double prevSuspensionRoll = 0.0;
    public double suspensionRoll = 0.0;
    public double angAccel = 0.0;

    public VehiclePhysicsSolver(PhysicsConfiguration config) {
        this.configuration = config;
        this.setupConfiguration(config);
    }

    public VehiclePhysicsSolver withAero(IAeroComponent aeroPiece) {
        this.aeroComponents.add(aeroPiece);
        return this;
    }

    public void step() {
        ++this.physicsStep;
    }

    public void resetStep() {
        this.physicsStep = 0;
    }

    public ArrayList<IAeroComponent> getAeroEquipment() {
        return this.aeroComponents;
    }

    public double getCurrentRPM() {
        return this.engineSolver.rpm;
    }

    public double getPreviousRPM() {
        return this.engineSolver.previousRPM;
    }

    public VehiclePhysicsSolver clone() {
        VehiclePhysicsSolver solv = new VehiclePhysicsSolver(this.configuration);
        solv.withAxels(this.frontAxel.newInstance(), this.rearAxel.newInstance());
        solv.aeroComponents = this.aeroComponents;
        return solv;
    }

    public PhysicsConfiguration compileStructure() {
        return this.configuration;
    }

    public void activate(EntityVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public PhysicsConfiguration getPhysConf() {
        return this.configuration;
    }

    public void setupConfiguration(PhysicsConfiguration conf) {
        this.wheelBase = conf.wheelBase;
        this.COGHeight = conf.COGHeight;
        this.transmission = conf.trans.cloneTransmission();
        this.engine = conf.getEngine();
        this.engineSolver = new EngineSolver(this, this.engine);
    }

    public Vec3d getAccelerationVector() {
        return this.acceleration;
    }

    public Vec3d getOreintationVector() {
        return Vec3d.func_189986_a((float)0.0f, (float)this.vehicle.field_70177_z);
    }

    public Vec3d getVelocityVector() {
        if (this.velocity == null) {
            return Vec3d.field_186680_a;
        }
        return this.velocity;
    }

    public void applyHandbrake() {
        this.isDrifting = true;
        this.rearAxel.applyHandbrake();
    }

    public double getSyntheticAcceleration() {
        if (Double.isNaN(this.synthAccelFor)) {
            return 0.0;
        }
        return this.synthAccelFor;
    }

    public void releaseHandbrake() {
        this.isDrifting = false;
        this.rearAxel.releaseHandbrake();
    }

    public double getSideSlipAngle() {
        try {
            Vec3d uVec = this.getOreintationVector();
            Vector2d u2D = new Vector2d(uVec.field_72450_a, uVec.field_72449_c);
            Vector2d v2D = new Vector2d(this.velocity.field_72450_a, this.velocity.field_72449_c);
            v2D.normalize();
            double mult = Math.signum(uVec.func_72431_c((Vec3d)this.velocity).field_72448_b);
            double result = u2D.angle(v2D) * mult;
            if (Double.isNaN(result)) {
                return 0.0;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public void setupSolver() {
    }

    public double getLongSpeedDir() {
        return 0.0;
    }

    public double getLongitudinalSpeed() {
        if (Double.isNaN(this.velocity.func_72433_c())) {
            return 0.0;
        }
        return this.velocity.func_72433_c();
    }

    public void updateSuspensionPlatform() {
        double height;
        Vec3d pointA = this.rearAxel.leftWheel.getSuspensionPosition();
        Vec3d pointB = this.rearAxel.rightWheel.getSuspensionPosition();
        Vec3d pointC = this.frontAxel.rightWheel.getSuspensionPosition();
        this.vehicle.rideOffset = height = (pointA.field_72448_b + pointB.field_72448_b + pointC.field_72448_b) / 3.0;
        System.out.println(pointA + " | " + pointB + " | " + pointC);
        Vec3d ab = pointB.func_178788_d(pointA);
        Vec3d ac = pointC.func_178788_d(pointA);
        Vec3d planeNormal = ab.func_72431_c(ac);
        Vec3d oreintation = this.getOreintationVector();
        Vec3d forwardVec = planeNormal.func_72431_c(oreintation).func_72431_c(oreintation);
        Vec3d bitangent = planeNormal.func_72431_c(forwardVec);
        float[] angles = this.anglesFromVectors(forwardVec.func_72432_b(), planeNormal.func_72432_b());
        this.angles = angles;
        System.out.println("Angles (YPR): " + angles[0] + " | " + angles[1] + " | " + angles[2]);
        this.rotMat = new Matrix3d(planeNormal.field_72450_a, planeNormal.field_72448_b, planeNormal.field_72449_c, forwardVec.field_72450_a, forwardVec.field_72448_b, forwardVec.field_72449_c, bitangent.field_72450_a, bitangent.field_72448_b, bitangent.field_72449_c);
    }

    public float[] anglesFromVectors(Vec3d forward, Vec3d up) {
        float[] angles = new float[3];
        float yaw = (float)Math.atan2(forward.field_72448_b, forward.field_72450_a);
        float pitch = (float)(-Math.asin(forward.field_72449_c));
        float planeRightX = (float)Math.sin(yaw);
        float planeRightY = (float)(-Math.cos(yaw));
        float roll = (float)Math.asin(up.field_72450_a * (double)planeRightX + up.field_72448_b * (double)planeRightY);
        if (up.field_72449_c < 0.0) {
            roll = (float)((double)Math.signum(roll) * Math.PI - (double)roll);
        }
        angles[0] = (float)((double)(yaw * 180.0f) / Math.PI);
        angles[1] = (float)((double)(pitch * 180.0f) / Math.PI);
        angles[2] = (float)((double)(roll * 180.0f) / Math.PI);
        return angles;
    }

    public double getTractionTorque() {
        return this.rearAxel.tractionTorque;
    }

    public void updateEngineForces() {
        if (this.engineSolver.rpm != 0.0) {
            this.engineSolver.rpm -= 3.0;
            if (this.engineSolver.rpm < 0.0) {
                this.engineSolver.rpm = 0.0;
            }
        }
        if (!this.vehicle.isVehicleRunning()) {
            return;
        }
        double driveTorque = this.engineSolver.getDriveTorque();
        this.rearAxel.applyDriveTorque(driveTorque);
        this.transmission.runAutomaticTransmission(this.vehicle, this.engineSolver.rpm);
    }

    public void updateLoad() {
        this.materialBelow = this.vehicle.field_70170_p.func_180495_p(this.vehicle.func_180425_c().func_177977_b()).func_185904_a();
        double downForce = 0.0;
        if (!this.aeroComponents.isEmpty()) {
            for (IAeroComponent comp : this.getAeroEquipment()) {
                downForce += VehiclePhysUtil.calculateLift((float)comp.getLiftCoefficient(), this.getLongitudinalSpeed(), comp.getAreaOfWing()) * 10.0;
            }
        }
        double mass = this.configuration.vehicleMass;
        double weight = mass * 9.81 + downForce;
        double accel = this.accelerationValue;
        double b = this.wheelBase / 2.0;
        double c = -(this.wheelBase / 2.0);
        double weightFront = b / this.wheelBase * weight - this.COGHeight / this.wheelBase * mass * accel;
        double weightRear = c / this.wheelBase * weight - this.COGHeight / this.wheelBase * mass * accel;
        double newSynth = Math.abs(this.synthAccelFor) * 0.8 * Math.signum(this.synthAccelFor);
        double newSynthSide = Math.toDegrees(this.vehicle.steerangle) / 5.0;
        this.synthAccelFor = newSynth;
        this.rearAxel.applySuspensionLoad(weightRear * 9.81);
        this.frontAxel.applySuspensionLoad(weightFront * -9.81);
        this.rearAxel.distributeLoad(weightFront);
        this.frontAxel.distributeLoad(-weightRear);
    }

    public void updateSimpleSuspension() {
        double acceleration = this.accelerationValue;
        if (this.physicsStep == 0) {
            this.prevSuspensionPitch = this.suspensionPitch;
            this.prevSuspensionRoll = this.suspensionRoll;
        }
        Vec3d sideG = this.velocity.func_186678_a(this.velocity.func_72430_b(this.getOreintationVector().func_178785_b((float)Math.toRadians(-90.0)))).func_186678_a(this.timeStep);
        double sideAcceleration = 0.0;
        for (WheelSolver ws : this.wheels) {
            sideAcceleration += ws.lateralForce;
        }
        sideAcceleration *= this.timeStep;
        this.suspensionRoll = 5.53 * sideG.func_72433_c() * Math.signum(this.getSideSlipAngle());
        this.suspensionPitch = -1.53 * (acceleration * 2.81);
    }

    public void updateWheels() {
        if (this.vehicle.isBraking) {
            this.synthAccelFor -= 3.0;
            this.frontAxel.applyBrakingForce(8000.0);
            this.rearAxel.applyBrakingForce(8000.0);
        }
        this.frontAxel.setSteeringAngle(this.vehicle.steerangle);
        this.frontAxel.doPhysics();
        this.rearAxel.doPhysics();
    }

    public Vec3d calculateResistiveForces(Vec3d speed) {
        Vec3d drag = VehiclePhysUtil.realDrag((float)this.configuration.getDragCoefficient(), speed, this.configuration.getFrontArea());
        Vec3d rolling = VehiclePhysUtil.rollingResistance(0.02f, speed);
        return drag.func_178787_e(rolling);
    }

    public void updateRotationalVelocity() {
        double forwardG;
        double rC = this.transmission.isReverseGear ? -1.0 : 1.0;
        double torqueContributionRear = this.rearAxel.latNonVec() * this.rearAxel.COGoffset * rC;
        double torqueContributionFront = Math.cos(this.vehicle.steerangle) * this.frontAxel.latNonVec() * this.frontAxel.COGoffset * rC;
        double totalAxelTorque = torqueContributionFront + torqueContributionRear + this.collisionTorque;
        Matrix3f inertia = this.getPhysConf().getVehicleMassObject().inertia;
        if (this.rotationalImpulse != 0.0) {
            this.vehicle.rotationRoll = (float)((double)this.vehicle.rotationRoll + this.rotationalImpulse);
            this.rotationalImpulse = 0.0;
        }
        float mR = 5.0f;
        if (this.vehicle.rotationRoll < 0.0f) {
            this.vehicle.rotationRoll = Math.max(this.vehicle.rotationRoll, -mR);
        } else if (this.vehicle.rotationRoll > 0.0f) {
            this.vehicle.rotationRoll = Math.min(this.vehicle.rotationRoll, mR);
        }
        this.angAccel += totalAxelTorque / (double)inertia.m11;
        if (this.materialBelow == Material.field_151576_e) {
            // empty if block
        }
        if (this.vehicle.getRealSpeed() == 0.0) {
            this.angAccel = 0.0;
            if (this.angularVelocity != 0.0) {
                // empty if block
            }
            this.angularVelocity *= 0.2;
        }
        this.angularVelocity *= 0.999;
        this.angularVelocity += this.timeStep * this.angAccel;
        this.vehicle.field_70177_z = (float)((double)this.vehicle.field_70177_z + Math.toDegrees(this.timeStep * this.angularVelocity));
        this.angAccel = 0.0;
        this.vehicle.field_70177_z = (float)((double)this.vehicle.field_70177_z + this.vehicle.driftTuner);
        this.vehicle.steerangle += Math.toDegrees(this.timeStep * this.angularVelocity * -1.0) * 0.02 * rC;
        this.vehicle.forwardLean = forwardG = this.accelerationValue;
        if (Double.isNaN(this.vehicle.forwardLean)) {
            this.vehicle.forwardLean = 0.0;
        }
    }

    public void updatePosition() {
        boolean wheelThrottle;
        Vec3d newVel;
        this.timeStep = 0.001;
        double mass = this.configuration.vehicleMass;
        Vec3d lForce = this.rearAxel.getLongitudinalForce().func_178785_b((float)Math.toRadians((double)(-this.vehicle.field_70177_z) + this.vehicle.driftTuner));
        Vec3d latForce = this.rearAxel.adjLateralForce().func_178787_e(this.frontAxel.adjLateralForce().func_186678_a(Math.cos(this.vehicle.steerangle)));
        Vec3d destructive = this.calculateResistiveForces(this.velocity);
        Vec3d vertForce = Vec3d.field_186680_a;
        boolean b = this.vehicle.field_70170_p.func_180495_p(this.vehicle.func_180425_c()).func_185904_a().func_76224_d();
        if (!this.vehicle.field_70122_E) {
            vertForce = new Vec3d(0.0, -mass * 9.81 * 2.0, 0.0);
        }
        Vec3d net = lForce.func_178787_e(latForce).func_178787_e(destructive).func_178787_e(vertForce);
        Vec3d acceleration = new Vec3d(net.field_72450_a / mass, net.field_72448_b / mass, net.field_72449_c / mass);
        if (acceleration == null) {
            return;
        }
        double xV = this.velocity.field_72450_a + this.timeStep * acceleration.field_72450_a;
        double yV = this.velocity.field_72448_b + this.timeStep * acceleration.field_72448_b;
        double zV = this.velocity.field_72449_c + this.timeStep * acceleration.field_72449_c;
        this.velocity = newVel = new Vec3d(xV, yV, zV);
        double oYV = yV;
        if (b) {
            oYV *= 0.7;
        }
        double r = 1.0;
        if (b) {
            r = 0.8;
        }
        this.velocity = new Vec3d(this.velocity.field_72450_a * r, oYV, this.velocity.field_72449_c * r);
        double rG = 1.0;
        if (this.transmission.isReverseGear) {
            rG = -1.0;
        }
        double yT = this.velocity.field_72448_b;
        boolean bl = wheelThrottle = this.vehicle.throttle == 0.0 || this.transmission.isEngineDeclutched();
        if (this.vehicle.getRealSpeed() < 2.0 && wheelThrottle && !this.transmission.isReverseGear) {
            this.velocity = this.velocity.func_186678_a(0.01);
        }
        if (this.velocity.func_72433_c() < 0.03 && wheelThrottle) {
            this.velocity = Vec3d.field_186680_a;
        }
        if (!b) {
            yT = this.velocity.field_72448_b;
        }
        double xP = this.timeStep * this.velocity.field_72450_a * rG;
        double yP = this.timeStep * yT;
        double zP = this.timeStep * this.velocity.field_72449_c * rG;
        Vec3d pD = new Vec3d(xP, yP, zP);
        this.vehicle.func_70091_d(MoverType.SELF, xP, yP, zP);
        if (this.physicsStep % 10 == 0) {
            this.doBlockCollision();
        }
        this.acceleration = acceleration;
    }

    public void doBlockCollision() {
        this.vehicle.doOBBCollision();
    }

    public void updatePhysics() {
        this.vehicle.field_70177_z = (float)((double)this.vehicle.field_70177_z - this.vehicle.driftTuner);
        this.updateEngineForces();
        this.updateLoad();
        this.updateWheels();
        this.updateRotationalVelocity();
        this.updateSimpleSuspension();
        this.updatePosition();
        this.step();
    }

    public VehiclePhysicsSolver jimHansen(Object object) {
        return null;
    }

    public VehiclePhysicsSolver withAxels(WheelAxel front, WheelAxel rear) {
        front.assignSolver(this);
        rear.assignSolver(this);
        this.frontAxel = front;
        this.rearAxel = rear;
        return this;
    }
}

