/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.weaponlib.vehicle.collisions.Contact;
import com.paneedah.weaponlib.vehicle.collisions.ContactManifold;
import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.OBBCollider;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import com.paneedah.weaponlib.vehicle.collisions.QuaternionTool;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RigidBody {
    public static final Vec3d[] cardinals = new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, -1.0, 0.0), new Vec3d(0.0, 0.0, -1.0)};
    public static final RigidBody DUMMY = new RigidBody(null){

        @Override
        public void solveContacts(float dt) {
        }

        @Override
        public void impulse(Vec3d force, Vec3d position) {
        }

        @Override
        public void updateOrientation() {
        }

        @Override
        public void updateGlobalCentroidFromPosition() {
        }

        @Override
        public void updatePositionFromGlobalCentroid() {
        }

        @Override
        public void doTimeStep(float dt) {
        }

        @Override
        public void addColliders(OreintedBB ... collide) {
        }

        @Override
        public Vec3d globalToLocalPos(Vec3d pos) {
            return pos;
        }

        @Override
        public Vec3d localToGlobalPos(Vec3d pos) {
            return pos;
        }

        @Override
        public Vec3d globalToLocalVec(Vec3d vec) {
            return vec;
        }

        @Override
        public Vec3d localToGlobalVec(Vec3d vec) {
            return vec;
        }

        @Override
        public void addLinearVelocity(Vec3d v) {
        }

        @Override
        public void addAngularVelocity(Vec3d v) {
        }

        @Override
        public void addContact(Contact c) {
        }
    };
    public World world;
    public AxisAlignedBB boundingBox;
    public List<OreintedBB> colliders = new ArrayList<OreintedBB>();
    public List<AxisAlignedBB> colliderBoundingBoxes = new ArrayList<AxisAlignedBB>();
    public Vec3d position = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d globalCentroid;
    public Matrix3f rotation = new Matrix3f();
    public Matrix3f inv_rotation;
    public Vec3d prevPosition = new Vec3d(0.0, 0.0, 0.0);
    public Quat4f prevRotation = new Quat4f();
    public Vec3d linearVelocity = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d angularVelocity = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d force = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d torque = new Vec3d(0.0, 0.0, 0.0);
    public float mass;
    public float inv_mass;
    public Matrix3f localInertiaTensor;
    public Matrix3f inv_localInertiaTensor;
    public Matrix3f inv_globalInertiaTensor;
    public float friction = 0.5f;
    public float restitution = 0.0f;
    public Vec3d localCentroid;
    public ContactManifold contacts = new ContactManifold();

    public RigidBody(World w) {
        this.world = w;
        this.rotation.setIdentity();
    }

    public RigidBody(World w, double x, double y, double z) {
        this(w);
        this.position = new Vec3d(x, y, z);
    }

    public void minecraftTimestep() {
        this.setPrevData();
        int timeStepSubDiv = 8;
        float step = 0.05f / (float)timeStepSubDiv;
        for (int i = 0; i < timeStepSubDiv; ++i) {
            this.doTimeStep(step);
        }
    }

    public void doTimeStep(float dt) {
        this.contacts.update();
        Object bestInfo = null;
        Object a = null;
        OreintedBB b = null;
        AxisAlignedBB bb = new AxisAlignedBB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
        List l = this.world.func_184144_a(null, bb.func_191194_a(this.position));
        for (AxisAlignedBB box : l) {
            for (int i = 0; i < this.colliders.size(); ++i) {
                OreintedBB c = this.colliders.get(i);
                b = OreintedBB.fromAABB(box);
                GJKResult info = OBBCollider.areColliding(c, b);
                if (info.status != GJKResult.Status.COLLIDING) continue;
                this.contacts.addContact(new Contact(this, null, c, b, info));
            }
        }
        this.solveContacts(dt);
        this.integrateVelocityAndPosition(dt);
        for (OreintedBB ob : this.colliders) {
            ob.axis = new Matrix3d(this.rotation);
            ob.inverse = new Matrix3d(this.inv_rotation);
            ob.setPosition(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c);
        }
    }

    public void integrateVelocityAndPosition(float dt) {
        this.linearVelocity = this.linearVelocity.func_178787_e(this.force.func_186678_a((double)(this.inv_mass * dt)));
        this.angularVelocity = this.angularVelocity.func_178787_e(RigidBody.matrixTransformVector(this.inv_globalInertiaTensor, this.torque.func_186678_a((double)dt)));
        this.force = Vec3d.field_186680_a;
        this.torque = Vec3d.field_186680_a;
        this.globalCentroid = this.globalCentroid.func_178787_e(this.linearVelocity.func_186678_a((double)dt));
        if (this.angularVelocity.func_189985_c() > 0.0) {
            Vec3d axis = this.angularVelocity.func_72432_b();
            double angle = this.angularVelocity.func_72433_c() * (double)dt;
            Matrix3f turn = new Matrix3f();
            turn.set(new AxisAngle4f((float)axis.field_72450_a, (float)axis.field_72448_b, (float)axis.field_72449_c, (float)angle));
            turn.mul(this.rotation);
            this.rotation = turn;
            this.updateOrientation();
        }
        this.updatePositionFromGlobalCentroid();
        this.updateAABBs();
        this.addLinearVelocity(new Vec3d(0.0, -9.81 * (double)dt, 0.0));
    }

    public void setPrevData() {
        this.prevPosition = this.position;
        RigidBody.setFromMat(this.prevRotation, this.rotation);
    }

    public void addContact(Contact c) {
        this.contacts.addContact(c);
    }

    public void solveContacts(float dt) {
        for (int j = 0; j < this.contacts.contactCount; ++j) {
            this.contacts.contacts[j].init(dt);
        }
        int velocityIterations = 4;
        for (int i = 0; i < velocityIterations; ++i) {
            for (int j = 0; j < this.contacts.contactCount; ++j) {
                this.contacts.contacts[j].solve(dt);
            }
        }
    }

    public Vec3d localToGlobalPos(Vec3d pos) {
        return RigidBody.matrixTransformVector(this.rotation, pos).func_178787_e(pos);
    }

    public Vec3d globalToLocalPos(Vec3d pos) {
        return RigidBody.matrixTransformVector(this.inv_rotation, pos.func_178788_d(this.position));
    }

    public Vec3d localToGlobalVec(Vec3d vec) {
        return RigidBody.matrixTransformVector(this.rotation, vec);
    }

    public Vec3d globalToLocalVec(Vec3d vec) {
        return RigidBody.matrixTransformVector(this.inv_rotation, vec);
    }

    public void addLinearVelocity(Vec3d v) {
        this.linearVelocity = this.linearVelocity.func_178787_e(v);
    }

    public void addAngularVelocity(Vec3d v) {
        this.angularVelocity = this.angularVelocity.func_178787_e(v);
    }

    public void impulse(Vec3d force, Vec3d position) {
        this.force = this.force.func_178787_e(force);
        this.torque = this.torque.func_178787_e(position.func_178788_d(this.globalCentroid).func_72431_c(force));
    }

    public void impulseVelocity(Vec3d force, Vec3d position) {
        this.linearVelocity = this.linearVelocity.func_178787_e(force.func_186678_a((double)this.inv_mass));
        this.angularVelocity = this.angularVelocity.func_178787_e(RigidBody.matrixTransformVector(this.inv_globalInertiaTensor, position.func_178788_d(this.globalCentroid).func_72431_c(force)));
    }

    public void impulseVelocityDirect(Vec3d force, Vec3d position) {
        this.linearVelocity = this.linearVelocity.func_178787_e(force);
        this.angularVelocity = this.angularVelocity.func_178787_e(position.func_178788_d(this.globalCentroid).func_72431_c(force));
    }

    public void updateOrientation() {
        Quat4f quat = new Quat4f();
        float epsilon = 1.0E-5f;
        RigidBody.setFromMat(quat, this.rotation);
        quat.normalize();
        QuaternionTool.matrixFromQuat(this.rotation, quat);
        this.inv_rotation = (Matrix3f)this.rotation.clone();
        this.inv_rotation.transpose();
        this.inv_globalInertiaTensor.set(this.inv_rotation);
        this.inv_globalInertiaTensor.mul(this.inv_localInertiaTensor);
        this.inv_globalInertiaTensor.mul(this.rotation);
    }

    public void updatePositionFromGlobalCentroid() {
        this.position = this.globalCentroid.func_178787_e(RigidBody.matrixTransformVector(this.rotation, this.localCentroid.func_186678_a(-1.0)));
    }

    public void updateGlobalCentroidFromPosition() {
        this.globalCentroid = RigidBody.matrixTransformVector(this.rotation, this.localCentroid).func_178787_e(this.position);
    }

    public void updateAABBs() {
        this.colliderBoundingBoxes.clear();
        double tMaxZ = -1.7976931348623157E308;
        double tMaxY = -1.7976931348623157E308;
        double tMaxX = -1.7976931348623157E308;
        double tMinZ = Double.MAX_VALUE;
        double tMinY = Double.MAX_VALUE;
        double tMinX = Double.MAX_VALUE;
        for (OreintedBB c : this.colliders) {
            double maxX = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[0]).field_72450_a;
            double maxY = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[1]).field_72448_b;
            double maxZ = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[2]).field_72449_c;
            double minX = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[3]).field_72450_a;
            double minY = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[4]).field_72448_b;
            double minZ = OBBCollider.localSupport((RigidBody)this, (OreintedBB)c, (Vec3d)RigidBody.cardinals[5]).field_72449_c;
            this.colliderBoundingBoxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
            tMaxX = Math.max(tMaxX, maxX);
            tMaxY = Math.max(tMaxY, maxY);
            tMaxZ = Math.max(tMaxZ, maxZ);
            tMinX = Math.min(tMinX, minX);
            tMinY = Math.min(tMinY, minY);
            tMinZ = Math.min(tMinZ, minZ);
        }
        this.boundingBox = new AxisAlignedBB(tMinX / 2.0, tMinY / 2.0, tMinZ / 2.0, tMaxX / 2.0, tMaxY / 2.0, tMaxZ / 2.0);
    }

    public void addColliders(OreintedBB ... collide) {
        for (OreintedBB c : collide) {
            this.colliders.add(c);
        }
        this.localCentroid = new Vec3d(0.0, 0.0, 0.0);
        this.mass = 0.0f;
        for (OreintedBB c : this.colliders) {
            this.mass = (float)((double)this.mass + c.mass);
            this.localCentroid = this.localCentroid.func_178787_e(c.localCentroid.func_186678_a(c.mass));
        }
        this.inv_mass = 1.0f / this.mass;
        this.localCentroid = this.localCentroid.func_186678_a((double)this.inv_mass);
        this.localInertiaTensor = new Matrix3f();
        for (OreintedBB c : this.colliders) {
            Vec3d colliderToLocal = this.localCentroid.func_178788_d(c.localCentroid);
            double lenSquared = colliderToLocal.func_72430_b(colliderToLocal);
            Matrix3f outerProduct = this.outerProduct(colliderToLocal, colliderToLocal);
            Matrix3f colliderToLocalMat = new Matrix3f();
            colliderToLocalMat.setIdentity();
            colliderToLocalMat.mul((float)lenSquared);
            colliderToLocalMat.sub(outerProduct);
            colliderToLocalMat.mul((float)c.mass);
            Matrix3f cLocalIT = (Matrix3f)c.inertiaTensor.clone();
            cLocalIT.add(colliderToLocalMat);
            this.localInertiaTensor.add(cLocalIT);
        }
        this.inv_localInertiaTensor = new Matrix3f();
        this.inv_localInertiaTensor.set(this.localInertiaTensor);
        this.inv_localInertiaTensor.invert();
        this.inv_globalInertiaTensor = new Matrix3f();
        this.updateOrientation();
        this.updateGlobalCentroidFromPosition();
        this.prevPosition = this.position;
        this.updateAABBs();
    }

    public void setRotation(float yaw, float pitch, float roll) {
        this.rotation.setIdentity();
        this.rotate(yaw, pitch, roll);
    }

    public void rotate(float yaw, float pitch, float roll) {
        Matrix3f mY = new Matrix3f();
        mY.rotY(yaw);
        Matrix3f mP = new Matrix3f();
        mP.rotX(pitch);
        Matrix3f mR = new Matrix3f();
        mR.rotZ(roll);
        mR.mul(mP);
        mR.mul(mY);
        this.rotation.mul(mR);
    }

    public static Vector3f getRealVector(Vec3d vec) {
        return new Vector3f((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    public static Vec3d getCringeVec(Vector3f v) {
        return new Vec3d((double)v.x, (double)v.y, (double)v.z);
    }

    public static Vec3d matrixTransformVector(Matrix3f mat, Vec3d v) {
        Vector3f re = RigidBody.getRealVector(v);
        mat.transform((Tuple3f)re);
        return RigidBody.getCringeVec(re);
    }

    public static void setFromMat(Quat4f q, Matrix3f mat) {
        RigidBody.setFromMat(q, mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22);
    }

    public static void setFromMat(Quat4f q, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float tr = m00 + m11 + m22;
        if ((double)tr >= 0.0) {
            float s = (float)Math.sqrt((double)tr + 1.0);
            q.w = s * 0.5f;
            s = 0.5f / s;
            q.x = (m21 - m12) * s;
            q.y = (m02 - m20) * s;
            q.z = (m10 - m01) * s;
        } else {
            float max = Math.max(Math.max(m00, m11), m22);
            if (max == m00) {
                float s = (float)Math.sqrt((double)(m00 - (m11 + m22)) + 1.0);
                q.x = s * 0.5f;
                s = 0.5f / s;
                q.y = (m01 + m10) * s;
                q.z = (m20 + m02) * s;
                q.w = (m21 - m12) * s;
            } else if (max == m11) {
                float s = (float)Math.sqrt((double)(m11 - (m22 + m00)) + 1.0);
                q.y = s * 0.5f;
                s = 0.5f / s;
                q.z = (m12 + m21) * s;
                q.x = (m01 + m10) * s;
                q.w = (m02 - m20) * s;
            } else {
                float s = (float)Math.sqrt((double)(m22 - (m00 + m11)) + 1.0);
                q.z = s * 0.5f;
                s = 0.5f / s;
                q.x = (m20 + m02) * s;
                q.y = (m12 + m21) * s;
                q.w = (m10 - m01) * s;
            }
        }
    }

    public Matrix3f outerProduct(Vec3d one, Vec3d two) {
        Matrix3f mat = new Matrix3f((float)(one.field_72450_a * two.field_72450_a), (float)(one.field_72450_a * two.field_72448_b), (float)(one.field_72450_a * two.field_72449_c), (float)(one.field_72448_b * two.field_72450_a), (float)(one.field_72448_b * two.field_72448_b), (float)(one.field_72448_b * two.field_72449_c), (float)(one.field_72449_c * two.field_72450_a), (float)(one.field_72449_c * two.field_72448_b), (float)(one.field_72449_c * two.field_72449_c));
        return mat;
    }

    public void solveCollisionWith(RigidBody body) {
    }

    static {
        RigidBody.DUMMY.inv_rotation = (Matrix3f)RigidBody.DUMMY.rotation.clone();
        RigidBody.DUMMY.localInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.inv_localInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.inv_globalInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.localCentroid = new Vec3d(0.0, 0.0, 0.0);
        RigidBody.DUMMY.globalCentroid = new Vec3d(0.0, 0.0, 0.0);
    }
}

