/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.vehicle.collisions.InertiaKit;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class OreintedBB {
    public Matrix3d inverse;
    public AxisAlignedBB aabb;
    public Vec3d c;
    public Matrix3d axis;
    public Vector3d previousEuler = new Vector3d(0.0, 0.0, 0.0);
    public boolean doPhysics = false;
    public Vec3d localCentroid = Vec3d.field_186680_a;
    public Matrix3f inertiaTensor;
    public double mass;

    public OreintedBB(AxisAlignedBB aabb) {
        this.axis = new Matrix3d();
        this.axis.setIdentity();
        this.c = Vec3d.field_186680_a;
        this.aabb = aabb;
    }

    public void setupPhysically(double mass) {
        this.doPhysics = true;
        this.mass = mass;
        AxisAlignedBB box = this.aabb;
        this.inertiaTensor = InertiaKit.inertiaTensorCube((float)mass, (float)(box.field_72336_d - box.field_72340_a), (float)(box.field_72337_e - box.field_72338_b), (float)(box.field_72334_f - box.field_72339_c));
    }

    public Vec3d getGlobalCentroid() {
        return this.localCentroid.func_178787_e(this.c);
    }

    public double[] doubleArrayFromMatrix(Matrix3d mat) {
        double[] dAr = new double[]{mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22};
        return dAr;
    }

    public static Vector3d matrixToEuler(Matrix3d mat) {
        double z;
        double y;
        double x;
        boolean singular;
        double sy = Math.sqrt(mat.m00 * mat.m00 + mat.m10 * mat.m10);
        boolean bl = singular = sy < 1.0E-6;
        if (!singular) {
            x = Math.atan2(mat.m21, mat.m22);
            y = Math.atan2(-mat.m20, sy);
            z = Math.atan2(mat.m10, mat.m00);
        } else {
            x = Math.atan2(-mat.m12, mat.m11);
            y = Math.atan2(-mat.m20, sy);
            z = 0.0;
        }
        return new Vector3d(x, y, z);
    }

    public void move(double x, double y, double z) {
        this.c = this.c.func_72441_c(x, y, z);
    }

    public double qPTI(double a, double b, float t) {
        return InterpolationKit.interpolateValue(a, b, t);
    }

    public void renderOBB() {
        GL11.glPushMatrix();
        Vector3d eulerRotations = OreintedBB.matrixToEuler(this.axis);
        float t = ClientProxy.MC.func_184121_ak();
        GL11.glRotated((double)Math.toDegrees(eulerRotations.x), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)Math.toDegrees(eulerRotations.y), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)Math.toDegrees(eulerRotations.z), (double)0.0, (double)0.0, (double)1.0);
        this.previousEuler = eulerRotations;
        GL11.glLineWidth((float)2.0f);
        RenderGlobal.func_189694_a((double)this.aabb.field_72340_a, (double)this.aabb.field_72338_b, (double)this.aabb.field_72339_c, (double)this.aabb.field_72336_d, (double)this.aabb.field_72337_e, (double)this.aabb.field_72334_f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void setRotation(double yaw, double pitch, double roll) {
        this.axis.setIdentity();
        this.rotate(yaw, pitch, roll);
    }

    public void rotatePitch(double pitch) {
        this.axis.rotY(pitch);
    }

    public void rotateYaw(double yaw) {
        this.axis.rotZ(yaw);
    }

    public void rotateRoll(double roll) {
        this.axis.rotX(roll);
    }

    public void rotate(double yaw, double pitch, double roll) {
        Matrix3d mY = new Matrix3d();
        mY.rotY(yaw);
        Matrix3d mP = new Matrix3d();
        mP.rotX(pitch);
        Matrix3d mR = new Matrix3d();
        mR.rotZ(roll);
        mR.mul(mP);
        mR.mul(mY);
        this.axis.mul(mR);
    }

    public double cleanVal(double d) {
        if (Math.abs(d) < 0.001) {
            return 0.0;
        }
        return d;
    }

    public void cleanMatrix(Matrix3d m) {
        m.m00 = this.cleanVal(m.m00);
        m.m01 = this.cleanVal(m.m01);
        m.m02 = this.cleanVal(m.m02);
        m.m10 = this.cleanVal(m.m10);
        m.m11 = this.cleanVal(m.m11);
        m.m12 = this.cleanVal(m.m12);
        m.m20 = this.cleanVal(m.m20);
        m.m21 = this.cleanVal(m.m21);
        m.m22 = this.cleanVal(m.m22);
    }

    public static OreintedBB fromAABB(AxisAlignedBB aabb) {
        Vec3d center = aabb.func_189972_c();
        Vec3d pos = new Vec3d(aabb.field_72336_d - 0.5, aabb.field_72337_e - 0.5, aabb.field_72334_f - 0.5);
        AxisAlignedBB fixedBB = aabb.func_191194_a(pos.func_186678_a(-1.0));
        return OreintedBB.fromAABB(fixedBB, pos);
    }

    public static OreintedBB fromAABB(AxisAlignedBB aabb, Vec3d position) {
        OreintedBB o = new OreintedBB(aabb);
        o.setPosition(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        return o;
    }

    public void setPosition(double x, double y, double z) {
        this.c = new Vec3d(x, y, z);
    }

    public Vec3d transformVec3dWithMatrix(Vec3d v, Matrix3d m) {
        Vector3d v1 = new Vector3d(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        m.transform((Tuple3d)v1);
        return new Vec3d(v1.x, v1.y, v1.z);
    }

    public void updateInverse() {
        Matrix3d inverseM = (Matrix3d)this.axis.clone();
        inverseM.invert();
        this.inverse = inverseM;
    }

    public RayTraceResult doRayTrace(Vec3d start, Vec3d end) {
        this.updateInverse();
        Vec3d a = this.transformToLocalSpace(start);
        Vec3d b = this.transformToLocalSpace(end);
        RayTraceResult rtr = this.aabb.func_72327_a(a, b);
        if (rtr != null) {
            rtr.field_72307_f = this.transformBackToWorld(rtr.field_72307_f);
        }
        return rtr;
    }

    public Vec3d support(Vec3d direction) {
        this.updateInverse();
        direction = this.transformVec3dWithMatrix(direction, this.inverse);
        Vec3d s = new Vec3d(direction.field_72450_a > 0.0 ? this.aabb.field_72336_d : this.aabb.field_72340_a, direction.field_72448_b > 0.0 ? this.aabb.field_72337_e : this.aabb.field_72338_b, direction.field_72449_c > 0.0 ? this.aabb.field_72334_f : this.aabb.field_72339_c);
        s = this.transformBackToWorld(s);
        return s;
    }

    public Vec3d transformToLocalSpace(Vec3d v) {
        v = v.func_178788_d(this.c);
        v = this.transformVec3dWithMatrix(v, this.inverse);
        return v;
    }

    public Vec3d transformBackToWorld(Vec3d v) {
        v = this.transformVec3dWithMatrix(v, this.axis);
        v = v.func_178787_e(this.c);
        return v;
    }

    public static Vec3d getExtentFromAABB(AxisAlignedBB ab) {
        double sizeX = Math.abs(ab.field_72336_d - ab.field_72340_a);
        double sizeY = Math.abs(ab.field_72337_e - ab.field_72338_b);
        double sizeZ = Math.abs(ab.field_72334_f - ab.field_72339_c);
        return new Vec3d(sizeX / 2.0, sizeY / 2.0, sizeZ / 2.0);
    }
}

