/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.collisions;

import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import com.paneedah.weaponlib.vehicle.collisions.RigidBody;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Contact {
    public RigidBody bodyA;
    public RigidBody bodyB;
    public OreintedBB a;
    public OreintedBB b;
    public Vec3d localA;
    public Vec3d localB;
    public Vec3d globalA;
    public Vec3d globalB;
    public Vec3d normal;
    public float depth;
    public Vec3d tangent;
    public Vec3d bitangent;
    public Vec3d rA;
    public Vec3d rB;
    public Jacobian normalContact;
    public Jacobian tangentContact;
    public Jacobian bitangentContact;

    public Contact(RigidBody bodyA, RigidBody bodyB, OreintedBB a, OreintedBB b, GJKResult info) {
        this.a = a;
        this.b = b;
        if (bodyA == null) {
            bodyA = RigidBody.DUMMY;
        }
        if (bodyB == null) {
            bodyB = RigidBody.DUMMY;
        }
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.localA = bodyA.globalToLocalPos(info.contactPointA);
        this.localB = bodyB.globalToLocalPos(info.contactPointB);
        this.globalA = info.contactPointA;
        this.globalB = info.contactPointB;
        this.normal = info.separationVector;
        this.depth = (float)info.penetrationDepth;
        this.tangent = Math.abs(this.normal.field_72450_a) >= 0.57735 ? new Vec3d(this.normal.field_72448_b, -this.normal.field_72450_a, 0.0).func_72432_b() : new Vec3d(0.0, this.normal.field_72449_c, -this.normal.field_72448_b).func_72432_b();
        this.bitangent = this.normal.func_72431_c(this.tangent);
        this.normalContact = new Jacobian(false);
        this.tangentContact = new Jacobian(true);
        this.bitangentContact = new Jacobian(true);
    }

    public void init(float dt) {
        this.rA = this.globalA.func_178788_d(this.bodyA == RigidBody.DUMMY ? this.a.localCentroid : this.bodyA.globalCentroid);
        this.rB = this.globalB.func_178788_d(this.bodyB == RigidBody.DUMMY ? this.b.localCentroid : this.bodyB.globalCentroid);
        this.normalContact.init(this, this.normal, dt);
        this.tangentContact.init(this, this.tangent, dt);
        this.bitangentContact.init(this, this.bitangent, dt);
    }

    public void solve(float dt) {
        this.normalContact.solve(this, dt);
        this.tangentContact.solve(this, dt);
        this.bitangentContact.solve(this, dt);
    }

    public static class Jacobian {
        boolean tangent;
        Vec3d j_va;
        Vec3d j_wa;
        Vec3d j_vb;
        Vec3d j_wb;
        float bias;
        double effectiveMass;
        double totalLambda;

        public Jacobian(boolean tangent) {
            this.tangent = tangent;
        }

        public void init(Contact c, Vec3d dir, float dt) {
            this.j_va = dir.func_186678_a(-1.0);
            this.j_wa = c.rA.func_72431_c(dir).func_186678_a(-1.0);
            this.j_vb = dir;
            this.j_wb = c.rB.func_72431_c(dir);
            if (!this.tangent) {
                float closingVel = (float)c.bodyA.linearVelocity.func_186678_a(-1.0).func_178788_d(c.bodyA.angularVelocity.func_72431_c(c.rA)).func_178787_e(c.bodyB.linearVelocity).func_178787_e(c.bodyB.angularVelocity.func_72431_c(c.rB)).func_72430_b(c.normal);
                float restitution = 1.0f;
                float beta = 0.2f;
                float dslop = 5.0E-4f;
                float rslop = 0.5f;
                this.bias = -(beta / dt) * Math.max(c.depth - dslop, 0.0f) + Math.max(restitution * closingVel - rslop, 0.0f);
            }
            this.effectiveMass = (double)c.bodyA.inv_mass + this.j_wa.func_72430_b(RigidBody.matrixTransformVector(c.bodyA.inv_globalInertiaTensor, this.j_wa)) + (double)c.bodyB.inv_mass + this.j_wb.func_72430_b(RigidBody.matrixTransformVector(c.bodyB.inv_globalInertiaTensor, this.j_wb));
            this.effectiveMass = 1.0 / this.effectiveMass;
            this.totalLambda = 0.0;
        }

        public void solve(Contact c, float dt) {
            double jv = this.j_va.func_72430_b(c.bodyA.linearVelocity) + this.j_wa.func_72430_b(c.bodyA.angularVelocity) + this.j_vb.func_72430_b(c.bodyB.linearVelocity) + this.j_wb.func_72430_b(c.bodyB.angularVelocity);
            double lambda = this.effectiveMass * -(jv + (double)this.bias);
            double oldTotalLambda = this.totalLambda;
            if (this.tangent) {
                float friction = c.bodyA.friction * c.bodyB.friction;
                double maxFriction = (double)friction * c.normalContact.totalLambda;
                this.totalLambda = MathHelper.func_151237_a((double)(this.totalLambda + lambda), (double)(-maxFriction), (double)maxFriction);
            } else {
                this.totalLambda = Math.max(0.0, oldTotalLambda + lambda);
            }
            lambda = this.totalLambda - oldTotalLambda;
            c.bodyA.addLinearVelocity(this.j_va.func_186678_a((double)c.bodyA.inv_mass * lambda));
            c.bodyA.addAngularVelocity(RigidBody.matrixTransformVector(c.bodyA.inv_globalInertiaTensor, this.j_wa).func_186678_a(lambda));
            c.bodyB.addLinearVelocity(this.j_vb.func_186678_a((double)c.bodyB.inv_mass * lambda));
            c.bodyB.addAngularVelocity(RigidBody.matrixTransformVector(c.bodyB.inv_globalInertiaTensor, this.j_wb).func_186678_a(lambda));
        }
    }
}

