/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.weaponlib.compatibility.CompatibleMovingSound;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.SoundEvent;

public abstract class VehicleTransmissionStrategy {
    public abstract void update(double var1);

    public static class DefaultTransmissionStrategy
    extends VehicleTransmissionStrategy {
        private double speed;
        private Gear[] gears;

        @Override
        public void update(double speed) {
            for (int i = 0; i < this.gears.length && speed > this.gears[i].minSpeed; ++i) {
            }
        }

        private static class Gear
        implements Comparable<Gear> {
            double minSpeed;
            double maxSpeed;
            MovingSound sound;
            DefaultTransmissionStrategy strategy;

            private Gear() {
            }

            @Override
            public int compareTo(Gear o) {
                return Double.compare(this.minSpeed, o.minSpeed);
            }
        }
    }

    public static class Builder {
        private List<DefaultTransmissionStrategy.Gear> gears = new ArrayList<DefaultTransmissionStrategy.Gear>();
        private EntityVehicle entity;

        public Builder withGear(double minSpeed, SoundEvent sound) {
            DefaultTransmissionStrategy.Gear gear = new DefaultTransmissionStrategy.Gear();
            Supplier<Vector3D> soundPositionProvider = () -> new Vector3D(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
            Supplier<Float> drivingSoundVolumeProvider = () -> {
                if (gear.strategy.speed >= gear.minSpeed && gear.strategy.speed < gear.maxSpeed) {
                    return Float.valueOf((float)Math.log10((0.01 + gear.strategy.speed - gear.minSpeed) * 20.0) * 0.9f);
                }
                return Float.valueOf(0.0f);
            };
            Supplier<Boolean> donePlayingSoundProvider = () -> this.entity.field_70128_L;
            gear.sound = new CompatibleMovingSound(sound, soundPositionProvider, drivingSoundVolumeProvider, donePlayingSoundProvider);
            this.gears.add(gear);
            return this;
        }

        public VehicleTransmissionStrategy build() {
            this.gears.sort(null);
            for (int i = 0; i < this.gears.size() - 1; ++i) {
                this.gears.get((int)i).maxSpeed = this.gears.get((int)(i + 1)).minSpeed;
            }
            this.gears.get((int)(this.gears.size() - 1)).maxSpeed = Double.MAX_VALUE;
            return null;
        }
    }
}

