/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.HierarchicalPartRenderer;
import com.paneedah.weaponlib.vehicle.HierarchicalRendererBuilder;
import com.paneedah.weaponlib.vehicle.PartRenderContext;
import com.paneedah.weaponlib.vehicle.RenderState;
import com.paneedah.weaponlib.vehicle.StatefulRenderers;
import com.paneedah.weaponlib.vehicle.VehicleModel;
import com.paneedah.weaponlib.vehicle.VehiclePart;
import com.paneedah.weaponlib.vehicle.VehicleRenderableState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class VehicleRendererBuilder
extends HierarchicalRendererBuilder<VehiclePart, VehicleRenderableState> {
    private boolean doShiftAnimation = false;
    private boolean shiftRight = false;
    private static List<VehiclePart> allParts = Arrays.asList(VehiclePart.MAIN, VehiclePart.WINDOWS, VehiclePart.STEERING_WHEEL, VehiclePart.LEFT_HAND, VehiclePart.RIGHT_HAND, VehiclePart.FRONT_LEFT_CONTROL_ARM, VehiclePart.FRONT_RIGHT_CONTROL_ARM, VehiclePart.FRONT_LEFT_WHEEL, VehiclePart.FRONT_RIGHT_WHEEL, VehiclePart.REAR_LEFT_WHEEL, VehiclePart.REAR_RIGHT_WHEEL);
    private static BiConsumer<MultipartRenderStateManager<VehicleRenderableState, HierarchicalPartRenderer.SinglePart, PartRenderContext<VehicleRenderableState>>, PartRenderContext<VehicleRenderableState>> DEFAULT_CONTINOUS_STATE_SETTER = (stateManager, renderContext) -> stateManager.setContinousState(renderContext.getState(), true, false, false);
    private static Function<PartRenderContext<VehicleRenderableState>, Float> DEFAULT_TURN_PROGRESS_PROVIDER = context -> Float.valueOf(((EntityVehicle)context.getEntity()).getInterpolatedYawDelta());
    private static Function<PartRenderContext<VehicleRenderableState>, Float> DEFAULT_WHEEL_TURN_PROGRESS_PROVIDER = context -> Float.valueOf(((EntityVehicle)context.getEntity()).getInterpolatedWheelRotation());

    public VehicleRendererBuilder performShiftAnimation(boolean state) {
        this.doShiftAnimation = state;
        return this;
    }

    public VehicleRendererBuilder shiftWithRight(boolean state) {
        this.shiftRight = state;
        return this;
    }

    public VehicleRendererBuilder withMainModelProvider(Supplier<VehicleModel> mainModelProvider) {
        VehicleModel model = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.MAIN, renderContext -> model.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        return this;
    }

    public VehicleRendererBuilder withWindowModelProvider(Supplier<VehicleModel> mainModelProvider) {
        VehicleModel model = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.WINDOWS, renderContext -> model.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        return this;
    }

    public VehicleRendererBuilder withSteeringWheelModelProvider(Supplier<VehicleModel> steeringWheelModelProvider) {
        VehicleModel steeringWheelModel = steeringWheelModelProvider.get();
        this.withPartRenderer(VehiclePart.STEERING_WHEEL, renderContext -> steeringWheelModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        return this;
    }

    public VehicleRendererBuilder withWheelModelProvider(Supplier<VehicleModel> mainModelProvider) {
        VehicleModel frontLeftWheelModel = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.FRONT_LEFT_WHEEL, renderContext -> frontLeftWheelModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        VehicleModel frontRightWheelModel = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.FRONT_RIGHT_WHEEL, renderContext -> frontRightWheelModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        VehicleModel rearLeftWheelModel = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.REAR_LEFT_WHEEL, renderContext -> rearLeftWheelModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        VehicleModel rearRightWheelModel = mainModelProvider.get();
        this.withPartRenderer(VehiclePart.REAR_RIGHT_WHEEL, renderContext -> rearRightWheelModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        return this;
    }

    public VehicleRendererBuilder withControlArmModelProvider(Supplier<VehicleModel> controlArmModelProvider) {
        VehicleModel frontLeftControlArmModel = controlArmModelProvider.get();
        this.withPartRenderer(VehiclePart.FRONT_LEFT_CONTROL_ARM, renderContext -> frontLeftControlArmModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        VehicleModel frontRightControlArmModel = controlArmModelProvider.get();
        this.withPartRenderer(VehiclePart.FRONT_RIGHT_CONTROL_ARM, renderContext -> frontRightControlArmModel.render((EntityVehicle)renderContext.getEntity(), 0.0625f));
        return this;
    }

    public HierarchicalRendererBuilder<VehiclePart, VehicleRenderableState> withPartPosition(VehiclePart part, Consumer<PartRenderContext<VehicleRenderableState>> positionFunction, VehicleRenderableState ... states) {
        if (states.length == 0) {
            this.withPartPosition(part, positionFunction, VehicleRenderableState.IDLE, VehicleRenderableState.PREPARED_TO_DRIVE, VehicleRenderableState.DRIVING, VehicleRenderableState.STARTING_SHIFT, VehicleRenderableState.SHIFTING, VehicleRenderableState.FINISHING_SHIFT, VehicleRenderableState.STOPPING);
        } else {
            super.withPartPosition((Object)part, positionFunction, (RenderState[])states);
        }
        return this;
    }

    @Override
    protected void prebuild() {
        this.withInitialState(VehicleRenderableState.IDLE);
        this.withPartStateSetter(VehiclePart.STEERING_WHEEL, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.FRONT_LEFT_WHEEL, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.FRONT_RIGHT_WHEEL, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.REAR_LEFT_WHEEL, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.REAR_RIGHT_WHEEL, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.FRONT_LEFT_CONTROL_ARM, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartStateSetter(VehiclePart.FRONT_RIGHT_CONTROL_ARM, DEFAULT_CONTINOUS_STATE_SETTER);
        this.withPartRenderer(VehiclePart.LEFT_HAND, StatefulRenderers.createLeftHandRenderer(null, c -> c.getEntity().func_184179_bs()));
        this.withPartRenderer(VehiclePart.RIGHT_HAND, StatefulRenderers.createRightHandRenderer(null, c -> c.getEntity().func_184179_bs()));
        for (VehiclePart part : allParts) {
            HierarchicalRendererBuilder.PartConfiguration partConfiguration = this.partConfigurations.computeIfAbsent(part, p -> new HierarchicalRendererBuilder.PartConfiguration());
            if (partConfiguration.currentProgressProvider == null) {
                partConfiguration.currentProgressProvider = part instanceof VehiclePart.Wheel ? DEFAULT_WHEEL_TURN_PROGRESS_PROVIDER : DEFAULT_TURN_PROGRESS_PROVIDER;
            }
            for (VehicleRenderableState state : VehicleRenderableState.values()) {
                List<HierarchicalRendererBuilder.TransitionDescriptor> idleTransitionDescriptors;
                List<HierarchicalRendererBuilder.TransitionDescriptor> drivingTransitionDescriptors;
                List transitionDescriptors = partConfiguration.transitionDescriptors.computeIfAbsent(state, k -> new ArrayList());
                if (this.doShiftAnimation) {
                    if (this.shiftRight) {
                        if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                            drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                            idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.LEFT_HAND && (state == VehicleRenderableState.FINISHING_SHIFT || state == VehicleRenderableState.SHIFTING || state == VehicleRenderableState.STARTING_SHIFT) && transitionDescriptors.isEmpty()) {
                            idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                            drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                            idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STARTING_SHIFT && transitionDescriptors.isEmpty()) {
                            drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.SHIFTING);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.FINISHING_SHIFT && transitionDescriptors.isEmpty()) {
                            idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                            transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                        }
                    } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                        drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                        idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.RIGHT_HAND && (state == VehicleRenderableState.FINISHING_SHIFT || state == VehicleRenderableState.SHIFTING || state == VehicleRenderableState.STARTING_SHIFT) && transitionDescriptors.isEmpty()) {
                        idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                        drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                        idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.STARTING_SHIFT && transitionDescriptors.isEmpty()) {
                        drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.SHIFTING);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.FINISHING_SHIFT && transitionDescriptors.isEmpty()) {
                        idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                        transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                    }
                } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.LEFT_HAND && (state == VehicleRenderableState.FINISHING_SHIFT || state == VehicleRenderableState.SHIFTING || state == VehicleRenderableState.STARTING_SHIFT) && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && (state == VehicleRenderableState.FINISHING_SHIFT || state == VehicleRenderableState.SHIFTING || state == VehicleRenderableState.STARTING_SHIFT) && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                }
                if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.LEFT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.LEFT_HAND && (state == VehicleRenderableState.FINISHING_SHIFT || state == VehicleRenderableState.SHIFTING || state == VehicleRenderableState.STARTING_SHIFT) && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.PREPARED_TO_DRIVE && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STOPPING && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.IDLE);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.STARTING_SHIFT && transitionDescriptors.isEmpty()) {
                    drivingTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.SHIFTING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(drivingTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                } else if (part == VehiclePart.RIGHT_HAND && state == VehicleRenderableState.FINISHING_SHIFT && transitionDescriptors.isEmpty()) {
                    idleTransitionDescriptors = partConfiguration.transitionDescriptors.get(VehicleRenderableState.DRIVING);
                    transitionDescriptors.add(new HierarchicalRendererBuilder.TransitionDescriptor(idleTransitionDescriptors.get((int)0).positionFunction, this.animationDuration));
                }
                if (transitionDescriptors != null && !transitionDescriptors.isEmpty()) continue;
                this.withPartPosition(part, state, (PartRenderContext<State> c) -> {});
            }
        }
    }
}

