/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.vehicle.PartRenderContext;
import com.paneedah.weaponlib.vehicle.StatefulRenderer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class StatefulRenderers {
    @SideOnly(value=Side.CLIENT)
    public static <State> StatefulRenderer<State> createLeftHandRenderer(ModelBiped model, Function<PartRenderContext<State>, Entity> entitySupplier) {
        return new LeftHandRenderer<State>(model, entitySupplier);
    }

    @SideOnly(value=Side.CLIENT)
    public static <State> StatefulRenderer<State> createRightHandRenderer(ModelBiped model, Function<PartRenderContext<State>, Entity> entitySupplier) {
        return new RightHandRenderer<State>(model, entitySupplier);
    }

    private static class RightHandRenderer<State>
    implements StatefulRenderer<State> {
        private Function<PartRenderContext<State>, Entity> entitySupplier;

        public RightHandRenderer(ModelBiped model, Function<PartRenderContext<State>, Entity> entitySupplier) {
            this.entitySupplier = entitySupplier;
        }

        @Override
        public void render(PartRenderContext<State> context) {
            Entity entity = this.entitySupplier.apply(context);
            if (entity != null && entity instanceof EntityPlayer) {
                Minecraft minecraft = ClientProxy.MC;
                if (minecraft.field_71474_y.field_74320_O == 0) {
                    minecraft.func_110434_K().func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                    Render entityRenderObject = ClientProxy.MC.func_175598_ae().func_78713_a((Entity)((AbstractClientPlayer)entity));
                    RenderPlayer render = (RenderPlayer)entityRenderObject;
                    ModelPlayer model = render.func_177087_b();
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    model.field_78093_q = false;
                    model.field_78117_n = false;
                    model.func_78087_a(0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0625f, entity);
                    model.field_178723_h.field_78808_h = 0.0f;
                    model.field_178723_h.field_78796_g = 0.0f;
                    model.field_178723_h.field_78795_f = 0.0f;
                    model.field_178723_h.func_78785_a(0.0625f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    EntityPlayer player = (EntityPlayer)entity;
                    ItemStack itemstack = player.func_184582_a(EntityEquipmentSlot.CHEST);
                    if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
                        render.func_110776_a(WeaponRenderer.getArmorResource((Entity)player, itemstack, EntityEquipmentSlot.CHEST, null));
                        ModelBiped armorModel = WeaponRenderer.getArmorModelHook((EntityLivingBase)player, itemstack, EntityEquipmentSlot.CHEST, null);
                        if (armorModel != null) {
                            armorModel.field_178723_h.field_78808_h = 0.0f;
                            armorModel.field_178723_h.field_78796_g = 0.0f;
                            armorModel.field_178723_h.field_78795_f = 0.0f;
                            WeaponRenderer.renderVehicleRightArm(armorModel, (AbstractClientPlayer)player);
                        }
                    }
                }
            }
        }
    }

    private static class LeftHandRenderer<State>
    implements StatefulRenderer<State> {
        private Function<PartRenderContext<State>, Entity> entitySupplier;

        public LeftHandRenderer(ModelBiped model, Function<PartRenderContext<State>, Entity> entitySupplier) {
            this.entitySupplier = entitySupplier;
        }

        @Override
        public void render(PartRenderContext<State> context) {
            Entity entity = this.entitySupplier.apply(context);
            if (entity != null && entity instanceof EntityPlayer) {
                Minecraft minecraft = ClientProxy.MC;
                if (minecraft.field_71474_y.field_74320_O == 0) {
                    minecraft.func_110434_K().func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                    Render entityRenderObject = ClientProxy.MC.func_175598_ae().func_78713_a((Entity)((AbstractClientPlayer)entity));
                    RenderPlayer render = (RenderPlayer)entityRenderObject;
                    ModelPlayer model = render.func_177087_b();
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    model.field_78117_n = false;
                    model.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, entity);
                    model.field_178724_i.field_78808_h = 0.0f;
                    model.field_178724_i.field_78796_g = 0.0f;
                    model.field_178724_i.field_78795_f = 0.0f;
                    model.field_178724_i.func_78785_a(0.0625f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    EntityPlayer player = (EntityPlayer)entity;
                    ItemStack itemstack = player.func_184582_a(EntityEquipmentSlot.CHEST);
                    if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor) {
                        render.func_110776_a(WeaponRenderer.getArmorResource((Entity)player, itemstack, EntityEquipmentSlot.CHEST, null));
                        ModelBiped armorModel = WeaponRenderer.getArmorModelHook((EntityLivingBase)player, itemstack, EntityEquipmentSlot.CHEST, null);
                        if (armorModel != null) {
                            armorModel.field_178724_i.field_78808_h = 0.0f;
                            armorModel.field_178724_i.field_78796_g = 0.0f;
                            armorModel.field_178724_i.field_78795_f = 0.0f;
                            WeaponRenderer.renderLeftVehicleArm(armorModel, (AbstractClientPlayer)player);
                        }
                    }
                }
            }
        }
    }
}

